/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tiered;

import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.tiered.ImmutableAddition;
import org.projectnessie.versioned.tiered.ImmutableRemoval;

public interface Mutation {
    public MutationType getType();

    public Key getKey();

    @Value.Immutable
    public static abstract class Removal
    implements Mutation {
        @Override
        public final MutationType getType() {
            return MutationType.REMOVAL;
        }

        @Override
        public abstract Key getKey();

        public static Removal of(Key key) {
            return ImmutableRemoval.builder().key(key).build();
        }
    }

    @Value.Immutable
    public static abstract class Addition
    implements Mutation {
        @Override
        public final MutationType getType() {
            return MutationType.ADDITION;
        }

        @Override
        public abstract Key getKey();

        @Nullable
        public abstract Byte getPayload();

        public static Addition of(Key key, Byte payload) {
            return ImmutableAddition.builder().key(key).payload(payload).build();
        }
    }

    public static enum MutationType {
        ADDITION,
        REMOVAL;

    }
}

