/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.Value;
import org.projectnessie.versioned.impl.condition.ValueVisitor;
import org.projectnessie.versioned.store.Entity;

class TestValueVisitor {
    private static final Visitor VISITOR = new Visitor();

    TestValueVisitor() {
    }

    @Test
    void testEntityValue() {
        Value numValue = Value.of((Entity)Entity.ofNumber((int)55));
        Assertions.assertEquals((Object)"n55", (Object)numValue.accept((ValueVisitor)VISITOR));
        Value strValue = Value.of((Entity)Entity.ofString((String)"myString"));
        Assertions.assertEquals((Object)"\"myString\"", (Object)strValue.accept((ValueVisitor)VISITOR));
        Value boolValue = Value.of((Entity)Entity.ofBoolean((boolean)true));
        Assertions.assertEquals((Object)"true", (Object)boolValue.accept((ValueVisitor)VISITOR));
    }

    @Test
    void testExpressionPathValue() {
        ExpressionPath.PathSegment.Builder builder = ExpressionPath.builder((String)"root");
        Assertions.assertEquals((Object)"root", (Object)builder.build().accept((ValueVisitor)VISITOR));
        builder = builder.position(2);
        Assertions.assertEquals((Object)"root[2]", (Object)builder.build().accept((ValueVisitor)VISITOR));
        builder = builder.name("notRoot");
        Assertions.assertEquals((Object)"root[2].notRoot", (Object)builder.build().accept((ValueVisitor)VISITOR));
    }

    @Test
    void testExpressionFunctionValue() {
        ExpressionPath.PathSegment.Builder pathBuilder = ExpressionPath.builder((String)"arrayPath");
        ExpressionFunction value = ExpressionFunction.equals((ExpressionFunction)ExpressionFunction.size((ExpressionPath)pathBuilder.build()), (Entity)Entity.ofNumber((int)10));
        Assertions.assertEquals((Object)"EQUALS[SIZE[arrayPath], n10]", (Object)value.accept((ValueVisitor)VISITOR));
    }

    static class Visitor
    implements ValueVisitor<String> {
        Visitor() {
        }

        public String visit(Entity entity) {
            return entity.toString();
        }

        public String visit(ExpressionFunction value) {
            return value.getName() + "[" + value.getArguments().stream().map(a -> (String)a.accept((ValueVisitor)this)).collect(Collectors.joining(", ")) + "]";
        }

        public String visit(ExpressionPath value) {
            return value.asString();
        }
    }
}

