/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalKeyWithPayload;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="InternalKeyWithPayload", generator="Immutables")
@Immutable
public final class ImmutableInternalKeyWithPayload
implements InternalKeyWithPayload {
    private final InternalKey key;
    @Nullable
    private final Byte payload;

    private ImmutableInternalKeyWithPayload(InternalKey key, @Nullable Byte payload) {
        this.key = key;
        this.payload = payload;
    }

    @Override
    public InternalKey getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public Byte getPayload() {
        return this.payload;
    }

    public final ImmutableInternalKeyWithPayload withKey(InternalKey value) {
        if (this.key == value) {
            return this;
        }
        InternalKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableInternalKeyWithPayload(newValue, this.payload);
    }

    public final ImmutableInternalKeyWithPayload withPayload(@Nullable Byte value) {
        if (Objects.equals(this.payload, value)) {
            return this;
        }
        return new ImmutableInternalKeyWithPayload(this.key, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInternalKeyWithPayload && this.equalTo((ImmutableInternalKeyWithPayload)another);
    }

    private boolean equalTo(ImmutableInternalKeyWithPayload another) {
        return this.key.equals(another.key) && Objects.equals(this.payload, another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + Objects.hashCode(this.payload);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"InternalKeyWithPayload").omitNullValues().add("key", (Object)this.key).add("payload", (Object)this.payload).toString();
    }

    public static ImmutableInternalKeyWithPayload copyOf(InternalKeyWithPayload instance) {
        if (instance instanceof ImmutableInternalKeyWithPayload) {
            return (ImmutableInternalKeyWithPayload)instance;
        }
        return ImmutableInternalKeyWithPayload.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InternalKeyWithPayload", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private InternalKey key;
        @Nullable
        private Byte payload;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(InternalKeyWithPayload instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            Byte payloadValue = instance.getPayload();
            if (payloadValue != null) {
                this.payload(payloadValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(InternalKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(@Nullable Byte payload) {
            this.payload = payload;
            return this;
        }

        public ImmutableInternalKeyWithPayload build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInternalKeyWithPayload(this.key, this.payload);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build InternalKeyWithPayload, some of required attributes are not set " + attributes;
        }
    }
}

