/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl.condition;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.projectnessie.versioned.impl.condition.AliasCollector;
import org.projectnessie.versioned.impl.condition.ImmutableUpdateExpression;
import org.projectnessie.versioned.impl.condition.UpdateClause;

@Value.Immutable
public abstract class UpdateExpression
implements AliasCollector.Aliasable<UpdateExpression> {
    public abstract List<UpdateClause> getClauses();

    public static UpdateExpression initial() {
        return ImmutableUpdateExpression.builder().build();
    }

    @Override
    public UpdateExpression alias(AliasCollector c) {
        return ImmutableUpdateExpression.builder().clauses((Iterable)this.getClauses().stream().map(f -> (UpdateClause)f.alias(c)).collect(ImmutableList.toImmutableList())).build();
    }

    public String toUpdateExpressionString() {
        Preconditions.checkArgument((!this.getClauses().isEmpty() ? 1 : 0) != 0, (Object)"At least one clauses must be defined.");
        ImmutableListMultimap clauses = Multimaps.index(this.getClauses(), c -> c.getType());
        StringBuilder sb = new StringBuilder();
        this.addIfExist(sb, clauses.get((Object)UpdateClause.Type.SET), UpdateClause.Type.SET);
        this.addIfExist(sb, clauses.get((Object)UpdateClause.Type.REMOVE), UpdateClause.Type.REMOVE);
        this.addIfExist(sb, clauses.get((Object)UpdateClause.Type.DELETE), UpdateClause.Type.DELETE);
        return sb.toString();
    }

    private void addIfExist(StringBuilder sb, List<UpdateClause> clauses, UpdateClause.Type type) {
        if (clauses == null || clauses.isEmpty()) {
            return;
        }
        sb.append(" ");
        sb.append(type.name());
        sb.append(" ");
        sb.append(clauses.stream().map(UpdateClause::toClauseString).collect(Collectors.joining(", ")));
    }

    public static UpdateExpression of(UpdateClause ... clauses) {
        return ImmutableUpdateExpression.builder().addClauses(clauses).build();
    }

    public UpdateExpression and(UpdateClause clause) {
        return ImmutableUpdateExpression.builder().from(this).addClauses(clause).build();
    }

    public UpdateExpression and(UpdateExpression expr) {
        return ImmutableUpdateExpression.builder().from(this).addAllClauses(expr.getClauses()).build();
    }

    public static final Collector<UpdateExpression, List<UpdateClause>, UpdateExpression> toUpdateExpression() {
        return Collector.of(Lists::newArrayList, (A o1, T l1) -> o1.addAll(l1.getClauses()), (o1, o2) -> {
            o1.addAll(o2);
            return o1;
        }, (A o1) -> ImmutableUpdateExpression.builder().addAllClauses((Iterable<? extends UpdateClause>)o1).build(), new Collector.Characteristics[0]);
    }
}

