/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import com.google.common.primitives.Ints;
import java.util.stream.Stream;
import org.bson.BsonWriter;
import org.bson.Document;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.mongodb.MongoBaseValue;
import org.projectnessie.versioned.mongodb.MongoSerDe;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.L1;

final class MongoL1
extends MongoBaseValue<L1>
implements L1 {
    static final String MUTATIONS = "mutations";
    static final String FRAGMENTS = "fragments";
    static final String IS_CHECKPOINT = "chk";
    static final String ORIGIN = "origin";
    static final String DISTANCE = "dist";
    static final String PARENTS = "parents";
    static final String TREE = "tree";
    static final String METADATA = "metadata";
    static final String KEY_LIST = "keys";

    static void produce(Document document, L1 v) {
        v = MongoL1.produceBase(document, v).commitMetadataId(MongoSerDe.deserializeId(document, METADATA)).ancestors(MongoSerDe.deserializeIds(document, PARENTS)).children(MongoSerDe.deserializeIds(document, TREE)).keyMutations(MongoSerDe.deserializeKeyMutations(document, MUTATIONS));
        Document keyList = (Document)document.get((Object)KEY_LIST);
        boolean checkpoint = keyList.getBoolean((Object)IS_CHECKPOINT);
        if (checkpoint) {
            v.completeKeyList(MongoSerDe.deserializeIds(keyList, FRAGMENTS));
        } else {
            Id checkpointId = MongoSerDe.deserializeId(keyList, ORIGIN);
            int distanceFromCheckpoint = Ints.checkedCast((long)keyList.getLong((Object)DISTANCE));
            v.incrementalKeyList(checkpointId, distanceFromCheckpoint);
        }
    }

    MongoL1(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    public L1 commitMetadataId(Id id) {
        this.serializeId(METADATA, id);
        return this;
    }

    public L1 ancestors(Stream<Id> ids) {
        this.serializeIds(PARENTS, ids);
        return this;
    }

    public L1 children(Stream<Id> ids) {
        this.serializeIds(TREE, ids);
        return this;
    }

    public L1 keyMutations(Stream<Key.Mutation> keyMutations) {
        this.serializeArray(MUTATIONS, keyMutations, MongoSerDe::serializeKeyMutation);
        return this;
    }

    public L1 incrementalKeyList(Id checkpointId, int distanceFromCheckpoint) {
        this.addProperty(KEY_LIST);
        this.bsonWriter.writeName(KEY_LIST);
        this.bsonWriter.writeStartDocument();
        this.bsonWriter.writeBoolean(IS_CHECKPOINT, false);
        this.serializeId(ORIGIN, checkpointId);
        this.serializeLong(DISTANCE, distanceFromCheckpoint);
        this.bsonWriter.writeEndDocument();
        return this;
    }

    public L1 completeKeyList(Stream<Id> fragmentIds) {
        this.addProperty(KEY_LIST);
        this.bsonWriter.writeName(KEY_LIST);
        this.bsonWriter.writeStartDocument();
        this.bsonWriter.writeBoolean(IS_CHECKPOINT, true);
        this.serializeIds(FRAGMENTS, fragmentIds);
        this.bsonWriter.writeEndDocument();
        return this;
    }

    @Override
    BsonWriter build() {
        this.checkPresent(METADATA, METADATA);
        this.checkPresent(TREE, "children");
        this.checkPresent(PARENTS, "ancestors");
        return super.build();
    }
}

