/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import java.util.List;
import java.util.stream.Stream;
import org.bson.BsonWriter;
import org.bson.Document;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.mongodb.MongoBaseValue;
import org.projectnessie.versioned.mongodb.MongoSerDe;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.KeyDelta;
import org.projectnessie.versioned.tiered.L3;

final class MongoL3
extends MongoBaseValue<L3>
implements L3 {
    static final String TREE = "tree";
    static final String TREE_KEY = "key";
    static final String TREE_ID = "id";

    static void produce(Document document, L3 v) {
        MongoL3.produceBase(document, v).keyDelta(MongoL3.deserializeKeyDeltas(document));
    }

    MongoL3(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    public L3 keyDelta(Stream<KeyDelta> keyDelta) {
        this.serializeArray(TREE, keyDelta, MongoL3::serializeKeyDelta);
        return this;
    }

    private static void serializeKeyDelta(BsonWriter writer, KeyDelta keyDelta) {
        writer.writeStartDocument();
        MongoSerDe.serializeKey(writer, TREE_KEY, keyDelta.getKey());
        writer.writeBinaryData(TREE_ID, MongoSerDe.serializeId(keyDelta.getId()));
        writer.writeEndDocument();
    }

    static Stream<KeyDelta> deserializeKeyDeltas(Document entity) {
        List deltas = (List)entity.get((Object)TREE);
        return deltas.stream().map(MongoL3::deserializeKeyDelta);
    }

    private static KeyDelta deserializeKeyDelta(Document d) {
        Key key = MongoSerDe.deserializeKey((List)d.get((Object)TREE_KEY));
        Id id = MongoSerDe.deserializeId(d, TREE_ID);
        return KeyDelta.of((Key)key, (Id)id);
    }

    @Override
    BsonWriter build() {
        this.checkPresent(TREE, "keyDelta");
        return super.build();
    }
}

