/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import com.google.common.primitives.Ints;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.bson.BsonWriter;
import org.bson.Document;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.mongodb.MongoBaseValue;
import org.projectnessie.versioned.mongodb.MongoSerDe;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.Ref;

final class MongoRef
extends MongoBaseValue<Ref>
implements Ref {
    static final String TYPE = "type";
    static final String NAME = "name";
    static final String COMMIT = "commit";
    static final String COMMITS = "commits";
    static final String DELTAS = "deltas";
    static final String PARENT = "parent";
    static final String POSITION = "position";
    static final String NEW_ID = "new";
    static final String OLD_ID = "old";
    static final String REF_TYPE_BRANCH = "b";
    static final String REF_TYPE_TAG = "t";
    static final String TREE = "tree";
    static final String METADATA = "metadata";
    static final String KEY_LIST = "keys";
    private Type type = Type.INIT;

    static void produce(Document document, Ref v) {
        String type;
        v = MongoRef.produceBase(document, v).name(document.getString((Object)NAME));
        switch (type = document.getString((Object)TYPE)) {
            case "t": {
                v.tag().commit(MongoSerDe.deserializeId(document, COMMIT));
                break;
            }
            case "b": {
                v.branch().metadata(MongoSerDe.deserializeId(document, METADATA)).children(MongoSerDe.deserializeIds(document, TREE)).commits(bc -> MongoRef.deserializeBranchCommits(bc, document));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ref-type " + type);
            }
        }
    }

    MongoRef(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    public Ref.Tag tag() {
        if (this.type != Type.INIT) {
            throw new IllegalStateException("branch()/tag() has already been called");
        }
        this.type = Type.TAG;
        this.serializeString(TYPE, REF_TYPE_TAG);
        return new MongoTag();
    }

    public Ref.Branch branch() {
        if (this.type != Type.INIT) {
            throw new IllegalStateException("branch()/tag() has already been called");
        }
        this.type = Type.BRANCH;
        this.serializeString(TYPE, REF_TYPE_BRANCH);
        return new MongoBranch();
    }

    public Ref name(String name) {
        this.serializeString(NAME, name);
        return this;
    }

    @Override
    BsonWriter build() {
        this.checkPresent(NAME, NAME);
        this.checkPresent(TYPE, TYPE);
        switch (this.type) {
            case TAG: {
                this.checkPresent(COMMIT, COMMIT);
                this.checkNotPresent(COMMITS, COMMITS);
                this.checkNotPresent(TREE, TREE);
                this.checkNotPresent(METADATA, METADATA);
                break;
            }
            case BRANCH: {
                this.checkNotPresent(COMMIT, COMMIT);
                this.checkPresent(COMMITS, COMMITS);
                this.checkPresent(TREE, TREE);
                this.checkPresent(METADATA, METADATA);
                break;
            }
            default: {
                throw new IllegalStateException("Neither tag() nor branch() has been called");
            }
        }
        return super.build();
    }

    private void serializeDelta(BsonWriter writer, int position, Id oldId, Id newId) {
        writer.writeStartDocument();
        this.serializeLong(POSITION, position);
        MongoSerDe.serializeId(writer, OLD_ID, oldId);
        MongoSerDe.serializeId(writer, NEW_ID, newId);
        writer.writeEndDocument();
    }

    static void deserializeBranchCommits(Ref.BranchCommit bc, Document d) {
        List lst = (List)d.get((Object)COMMITS);
        lst.forEach(c -> MongoRef.deserializeBranchCommit(bc, c));
    }

    private static void deserializeBranchCommit(Ref.BranchCommit consumer, Document d) {
        consumer = consumer.id(MongoSerDe.deserializeId(d, "id")).commit(MongoSerDe.deserializeId(d, COMMIT));
        if (d.containsKey((Object)PARENT)) {
            consumer.saved().parent(MongoSerDe.deserializeId(d, PARENT)).done();
        } else {
            Ref.UnsavedCommitDelta unsaved = consumer.unsaved();
            List deltas = (List)d.get((Object)DELTAS);
            deltas.forEach(delta -> MongoRef.deserializeUnsavedDelta(unsaved, delta));
            Ref.UnsavedCommitMutations mutations = unsaved.mutations();
            MongoSerDe.deserializeKeyMutations(d, KEY_LIST).forEach(arg_0 -> ((Ref.UnsavedCommitMutations)mutations).keyMutation(arg_0));
            mutations.done();
        }
    }

    private static void deserializeUnsavedDelta(Ref.UnsavedCommitDelta consumer, Document d) {
        int position = Ints.saturatedCast((long)d.getLong((Object)POSITION));
        Id oldId = MongoSerDe.deserializeId(d, OLD_ID);
        Id newId = MongoSerDe.deserializeId(d, NEW_ID);
        consumer.delta(position, oldId, newId);
    }

    private class MongoBranchCommit
    implements Ref.BranchCommit,
    Ref.SavedCommit,
    Ref.UnsavedCommitDelta,
    Ref.UnsavedCommitMutations {
        int state;

        private MongoBranchCommit() {
        }

        public Ref.BranchCommit id(Id id) {
            this.maybeStart();
            this.assertState(1);
            MongoSerDe.serializeId(MongoRef.this.bsonWriter, "id", id);
            return this;
        }

        public Ref.BranchCommit commit(Id commit) {
            this.maybeStart();
            this.assertState(1);
            MongoSerDe.serializeId(MongoRef.this.bsonWriter, MongoRef.COMMIT, commit);
            return this;
        }

        public Ref.SavedCommit saved() {
            return this;
        }

        public Ref.UnsavedCommitDelta unsaved() {
            return this;
        }

        public Ref.SavedCommit parent(Id parent) {
            this.maybeStart();
            this.assertState(1);
            MongoSerDe.serializeId(MongoRef.this.bsonWriter, MongoRef.PARENT, parent);
            return this;
        }

        public Ref.UnsavedCommitDelta delta(int position, Id oldId, Id newId) {
            this.maybeStart();
            if (this.state == 1) {
                this.state = 2;
                MongoRef.this.bsonWriter.writeStartArray(MongoRef.DELTAS);
            }
            this.assertState(2);
            MongoRef.this.serializeDelta(MongoRef.this.bsonWriter, position, oldId, newId);
            return this;
        }

        public Ref.UnsavedCommitMutations mutations() {
            return this;
        }

        public Ref.UnsavedCommitMutations keyMutation(Key.Mutation keyMutation) {
            this.maybeStart();
            if (this.state == 2) {
                this.state = 1;
                MongoRef.this.bsonWriter.writeEndArray();
            }
            if (this.state == 1) {
                this.state = 3;
                MongoRef.this.bsonWriter.writeStartArray(MongoRef.KEY_LIST);
            }
            this.assertState(3);
            MongoSerDe.serializeKeyMutation(MongoRef.this.bsonWriter, keyMutation);
            return this;
        }

        private void maybeStart() {
            if (this.state == 0) {
                MongoRef.this.bsonWriter.writeStartDocument();
                this.state = 1;
            }
        }

        private void assertState(int expected) {
            if (this.state != expected) {
                throw new IllegalStateException("Wrong order or consumer method invocations (" + expected + " != " + this.state + ". See Javadocs.");
            }
        }

        public Ref.BranchCommit done() {
            if (this.state == 3 || this.state == 2) {
                MongoRef.this.bsonWriter.writeEndArray();
                this.state = 1;
            }
            if (this.state == 1) {
                MongoRef.this.bsonWriter.writeEndDocument();
                this.state = 0;
            }
            return this;
        }
    }

    class MongoBranch
    implements Ref.Branch {
        MongoBranch() {
        }

        public Ref.Branch metadata(Id metadata) {
            MongoRef.this.serializeId(MongoRef.METADATA, metadata);
            return this;
        }

        public Ref.Branch children(Stream<Id> children) {
            MongoRef.this.serializeIds(MongoRef.TREE, children);
            return this;
        }

        public Ref.Branch commits(Consumer<Ref.BranchCommit> commits) {
            MongoRef.this.addProperty(MongoRef.COMMITS);
            MongoRef.this.bsonWriter.writeStartArray(MongoRef.COMMITS);
            commits.accept(new MongoBranchCommit());
            MongoRef.this.bsonWriter.writeEndArray();
            return this;
        }

        public Ref backToRef() {
            return MongoRef.this;
        }
    }

    class MongoTag
    implements Ref.Tag {
        MongoTag() {
        }

        public Ref.Tag commit(Id commit) {
            MongoRef.this.serializeId(MongoRef.COMMIT, commit);
            return this;
        }

        public Ref backToRef() {
            return MongoRef.this;
        }
    }

    private static enum Type {
        INIT,
        TAG,
        BRANCH;

    }
}

