/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.mongodb.MongoBaseValue;
import org.projectnessie.versioned.mongodb.MongoFragment;
import org.projectnessie.versioned.mongodb.MongoL1;
import org.projectnessie.versioned.mongodb.MongoL2;
import org.projectnessie.versioned.mongodb.MongoL3;
import org.projectnessie.versioned.mongodb.MongoRef;
import org.projectnessie.versioned.mongodb.MongoWrappedValue;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;
import org.projectnessie.versioned.tiered.BaseWrappedValue;
import org.projectnessie.versioned.tiered.Fragment;
import org.projectnessie.versioned.tiered.L1;
import org.projectnessie.versioned.tiered.L2;
import org.projectnessie.versioned.tiered.L3;
import org.projectnessie.versioned.tiered.Ref;

final class MongoSerDe {
    private static final Map<ValueType<?>, Function<BsonWriter, MongoBaseValue>> CONSUMERS = ImmutableMap.builder().put((Object)ValueType.L1, MongoL1::new).put((Object)ValueType.L2, MongoL2::new).put((Object)ValueType.L3, MongoL3::new).put((Object)ValueType.KEY_FRAGMENT, MongoFragment::new).put((Object)ValueType.REF, MongoRef::new).put((Object)ValueType.VALUE, MongoWrappedValue::new).put((Object)ValueType.COMMIT_METADATA, MongoWrappedValue::new).build();
    private static final Map<ValueType<?>, BiConsumer<Document, BaseValue>> DESERIALIZERS = ImmutableMap.builder().put((Object)ValueType.L1, (d, c) -> MongoL1.produce(d, (L1)c)).put((Object)ValueType.L2, (d, c) -> MongoL2.produce(d, (L2)c)).put((Object)ValueType.L3, (d, c) -> MongoL3.produce(d, (L3)c)).put((Object)ValueType.KEY_FRAGMENT, (d, c) -> MongoFragment.produce(d, (Fragment)c)).put((Object)ValueType.REF, (d, c) -> MongoRef.produce(d, (Ref)c)).put((Object)ValueType.VALUE, (d, c) -> MongoWrappedValue.produce(d, (BaseWrappedValue)c)).put((Object)ValueType.COMMIT_METADATA, (d, c) -> MongoWrappedValue.produce(d, (BaseWrappedValue)c)).build();
    private static final String KEY_ADDITION = "a";
    private static final String KEY_REMOVAL = "d";

    private MongoSerDe() {
    }

    static <C extends BaseValue<C>> void produceToConsumer(Document d, ValueType<C> valueType, C consumer) {
        DESERIALIZERS.get(valueType).accept(d, consumer);
    }

    private static <C extends BaseValue<C>> MongoBaseValue<C> newMongoConsumer(ValueType<C> valueType, BsonWriter bsonWriter) {
        return CONSUMERS.get(valueType).apply(bsonWriter);
    }

    static <C extends BaseValue<C>> Bson bsonForValueType(final SaveOp<C> saveOp, final String updateOperator) {
        return new Bson(){

            public <T> BsonDocument toBsonDocument(Class<T> clazz, CodecRegistry codecRegistry) {
                BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
                writer.writeStartDocument();
                writer.writeName(updateOperator);
                MongoSerDe.serializeEntity((BsonWriter)writer, saveOp);
                writer.writeEndDocument();
                return writer.getDocument();
            }
        };
    }

    static <C extends BaseValue<C>> void serializeEntity(BsonWriter writer, SaveOp<C> saveOp) {
        writer.writeStartDocument();
        MongoBaseValue<C> consumer = MongoSerDe.newMongoConsumer(saveOp.getType(), writer);
        consumer.id(saveOp.getId());
        saveOp.serialize(consumer);
        consumer.build();
        writer.writeEndDocument();
    }

    static BsonBinary serializeId(Id id) {
        return new BsonBinary(id.toBytes());
    }

    static void serializeId(BsonWriter writer, String property, Id id) {
        writer.writeBinaryData(property, new BsonBinary(id.toBytes()));
    }

    static Id deserializeId(Document d, String param) {
        return Id.of((byte[])((Binary)d.get((Object)param)).getData());
    }

    static Stream<Id> deserializeIds(Document d, String param) {
        List ids = (List)d.get((Object)param);
        return ids.stream().map(b -> Id.of((byte[])b.getData()));
    }

    static BsonBinary serializeBytes(ByteString value) {
        return new BsonBinary(value.toByteArray());
    }

    static Stream<Key> deserializeKeys(Document document, String param) {
        List l = (List)document.get((Object)param);
        return l.stream().map(o -> (List)o).map(MongoSerDe::deserializeKey);
    }

    static void serializeKey(BsonWriter bsonWriter, String prop, Key key) {
        bsonWriter.writeStartArray(prop);
        key.getElements().forEach(arg_0 -> ((BsonWriter)bsonWriter).writeString(arg_0));
        bsonWriter.writeEndArray();
    }

    static Key deserializeKey(List<String> lst) {
        return Key.of((String[])lst.toArray(new String[0]));
    }

    static <X> void serializeArray(BsonWriter writer, String prop, Stream<X> src, BiConsumer<BsonWriter, X> inner) {
        writer.writeStartArray(prop);
        src.forEach(e -> inner.accept(writer, e));
        writer.writeEndArray();
    }

    static void serializeKeyMutation(BsonWriter writer, Key.Mutation keyMutation) {
        writer.writeStartDocument();
        MongoSerDe.serializeKey(writer, MongoSerDe.mutationName(keyMutation.getType()), keyMutation.getKey());
        writer.writeEndDocument();
    }

    private static String mutationName(Key.MutationType type) {
        switch (type) {
            case ADDITION: {
                return KEY_ADDITION;
            }
            case REMOVAL: {
                return KEY_REMOVAL;
            }
        }
        throw new IllegalArgumentException("unknown mutation type " + type);
    }

    static Stream<Key.Mutation> deserializeKeyMutations(Document d, String param) {
        List keyMutations = (List)d.get((Object)param);
        return keyMutations.stream().map(MongoSerDe::deserializeKeyMutation);
    }

    private static Key.Mutation deserializeKeyMutation(Document d) {
        Map.Entry e = (Map.Entry)d.entrySet().stream().findFirst().get();
        String addRemove = (String)e.getKey();
        Key key = MongoSerDe.deserializeKey((List)e.getValue());
        switch (addRemove) {
            case "a": {
                return key.asAddition();
            }
            case "d": {
                return key.asRemoval();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported key '%s' in key-mutation map", addRemove));
    }

    static {
        if (!CONSUMERS.keySet().equals(DESERIALIZERS.keySet())) {
            throw new UnsupportedOperationException("The enum-maps ENTITY_MAP_PRODUCERS and DESERIALIZERS are not equal. This is a bug in the implementation of MongoSerDe.");
        }
        if (!DESERIALIZERS.keySet().equals(new HashSet(ValueType.values()))) {
            throw new UnsupportedOperationException(String.format("The enum-map producerMaps does not have producer-maps matching the available value types (%s vs %s).", DESERIALIZERS.keySet(), new HashSet(ValueType.values())));
        }
    }
}

