/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.mongodb.MongoStoreConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MongoStoreConfig", generator="Immutables")
@Immutable
public final class ImmutableMongoStoreConfig
extends MongoStoreConfig {
    private final String connectionString;
    private final String databaseName;
    private final String tablePrefix;
    private final long timeoutMs;
    private final boolean initializeDatabase;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoStoreConfig(Builder builder) {
        this.connectionString = builder.connectionString;
        if (builder.databaseName != null) {
            this.initShim.databaseName(builder.databaseName);
        }
        if (builder.tablePrefix != null) {
            this.initShim.tablePrefix(builder.tablePrefix);
        }
        if (builder.timeoutMsIsSet()) {
            this.initShim.timeoutMs(builder.timeoutMs);
        }
        if (builder.initializeDatabaseIsSet()) {
            this.initShim.initializeDatabase(builder.initializeDatabase);
        }
        this.databaseName = this.initShim.getDatabaseName();
        this.tablePrefix = this.initShim.getTablePrefix();
        this.timeoutMs = this.initShim.getTimeoutMs();
        this.initializeDatabase = this.initShim.initializeDatabase();
        this.initShim = null;
    }

    private ImmutableMongoStoreConfig(String connectionString, String databaseName, String tablePrefix, long timeoutMs, boolean initializeDatabase) {
        this.connectionString = connectionString;
        this.databaseName = databaseName;
        this.tablePrefix = tablePrefix;
        this.timeoutMs = timeoutMs;
        this.initializeDatabase = initializeDatabase;
        this.initShim = null;
    }

    @Override
    public String getConnectionString() {
        return this.connectionString;
    }

    @Override
    public String getDatabaseName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDatabaseName() : this.databaseName;
    }

    @Override
    public String getTablePrefix() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTablePrefix() : this.tablePrefix;
    }

    @Override
    public long getTimeoutMs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTimeoutMs() : this.timeoutMs;
    }

    @Override
    public boolean initializeDatabase() {
        InitShim shim = this.initShim;
        return shim != null ? shim.initializeDatabase() : this.initializeDatabase;
    }

    public final ImmutableMongoStoreConfig withConnectionString(String value) {
        String newValue = Objects.requireNonNull(value, "connectionString");
        if (this.connectionString.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoStoreConfig(newValue, this.databaseName, this.tablePrefix, this.timeoutMs, this.initializeDatabase);
    }

    public final ImmutableMongoStoreConfig withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (this.databaseName.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoStoreConfig(this.connectionString, newValue, this.tablePrefix, this.timeoutMs, this.initializeDatabase);
    }

    public final ImmutableMongoStoreConfig withTablePrefix(String value) {
        String newValue = Objects.requireNonNull(value, "tablePrefix");
        if (this.tablePrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableMongoStoreConfig(this.connectionString, this.databaseName, newValue, this.timeoutMs, this.initializeDatabase);
    }

    public final ImmutableMongoStoreConfig withTimeoutMs(long value) {
        if (this.timeoutMs == value) {
            return this;
        }
        return new ImmutableMongoStoreConfig(this.connectionString, this.databaseName, this.tablePrefix, value, this.initializeDatabase);
    }

    public final ImmutableMongoStoreConfig withInitializeDatabase(boolean value) {
        if (this.initializeDatabase == value) {
            return this;
        }
        return new ImmutableMongoStoreConfig(this.connectionString, this.databaseName, this.tablePrefix, this.timeoutMs, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoStoreConfig && this.equalTo((ImmutableMongoStoreConfig)another);
    }

    private boolean equalTo(ImmutableMongoStoreConfig another) {
        return this.connectionString.equals(another.connectionString) && this.databaseName.equals(another.databaseName) && this.tablePrefix.equals(another.tablePrefix) && this.timeoutMs == another.timeoutMs && this.initializeDatabase == another.initializeDatabase;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.connectionString.hashCode();
        h += (h << 5) + this.databaseName.hashCode();
        h += (h << 5) + this.tablePrefix.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.timeoutMs);
        h += (h << 5) + Booleans.hashCode((boolean)this.initializeDatabase);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MongoStoreConfig").omitNullValues().add("connectionString", (Object)this.connectionString).add("databaseName", (Object)this.databaseName).add("tablePrefix", (Object)this.tablePrefix).add("timeoutMs", this.timeoutMs).add("initializeDatabase", this.initializeDatabase).toString();
    }

    public static ImmutableMongoStoreConfig copyOf(MongoStoreConfig instance) {
        if (instance instanceof ImmutableMongoStoreConfig) {
            return (ImmutableMongoStoreConfig)instance;
        }
        return ImmutableMongoStoreConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MongoStoreConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_STRING = 1L;
        private static final long OPT_BIT_TIMEOUT_MS = 1L;
        private static final long OPT_BIT_INITIALIZE_DATABASE = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String connectionString;
        @Nullable
        private String databaseName;
        @Nullable
        private String tablePrefix;
        private long timeoutMs;
        private boolean initializeDatabase;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MongoStoreConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionString(instance.getConnectionString());
            this.databaseName(instance.getDatabaseName());
            this.tablePrefix(instance.getTablePrefix());
            this.timeoutMs(instance.getTimeoutMs());
            this.initializeDatabase(instance.initializeDatabase());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectionString(String connectionString) {
            this.connectionString = Objects.requireNonNull(connectionString, "connectionString");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tablePrefix(String tablePrefix) {
            this.tablePrefix = Objects.requireNonNull(tablePrefix, "tablePrefix");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder initializeDatabase(boolean initializeDatabase) {
            this.initializeDatabase = initializeDatabase;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableMongoStoreConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMongoStoreConfig(this);
        }

        private boolean timeoutMsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean initializeDatabaseIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionString");
            }
            return "Cannot build MongoStoreConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="MongoStoreConfig", generator="Immutables")
    private final class InitShim {
        private byte databaseNameBuildStage = 0;
        private String databaseName;
        private byte tablePrefixBuildStage = 0;
        private String tablePrefix;
        private byte timeoutMsBuildStage = 0;
        private long timeoutMs;
        private byte initializeDatabaseBuildStage = 0;
        private boolean initializeDatabase;

        private InitShim() {
        }

        String getDatabaseName() {
            if (this.databaseNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.databaseNameBuildStage == 0) {
                this.databaseNameBuildStage = (byte)-1;
                this.databaseName = Objects.requireNonNull(ImmutableMongoStoreConfig.super.getDatabaseName(), "databaseName");
                this.databaseNameBuildStage = 1;
            }
            return this.databaseName;
        }

        void databaseName(String databaseName) {
            this.databaseName = databaseName;
            this.databaseNameBuildStage = 1;
        }

        String getTablePrefix() {
            if (this.tablePrefixBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tablePrefixBuildStage == 0) {
                this.tablePrefixBuildStage = (byte)-1;
                this.tablePrefix = Objects.requireNonNull(ImmutableMongoStoreConfig.super.getTablePrefix(), "tablePrefix");
                this.tablePrefixBuildStage = 1;
            }
            return this.tablePrefix;
        }

        void tablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
            this.tablePrefixBuildStage = 1;
        }

        long getTimeoutMs() {
            if (this.timeoutMsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.timeoutMsBuildStage == 0) {
                this.timeoutMsBuildStage = (byte)-1;
                this.timeoutMs = ImmutableMongoStoreConfig.super.getTimeoutMs();
                this.timeoutMsBuildStage = 1;
            }
            return this.timeoutMs;
        }

        void timeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
            this.timeoutMsBuildStage = 1;
        }

        boolean initializeDatabase() {
            if (this.initializeDatabaseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.initializeDatabaseBuildStage == 0) {
                this.initializeDatabaseBuildStage = (byte)-1;
                this.initializeDatabase = ImmutableMongoStoreConfig.super.initializeDatabase();
                this.initializeDatabaseBuildStage = 1;
            }
            return this.initializeDatabase;
        }

        void initializeDatabase(boolean initializeDatabase) {
            this.initializeDatabase = initializeDatabase;
            this.initializeDatabaseBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.databaseNameBuildStage == -1) {
                attributes.add("databaseName");
            }
            if (this.tablePrefixBuildStage == -1) {
                attributes.add("tablePrefix");
            }
            if (this.timeoutMsBuildStage == -1) {
                attributes.add("timeoutMs");
            }
            if (this.initializeDatabaseBuildStage == -1) {
                attributes.add("initializeDatabase");
            }
            return "Cannot build MongoStoreConfig, attribute initializers form cycle " + attributes;
        }
    }
}

