/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import java.util.stream.Stream;
import org.bson.BsonWriter;
import org.bson.Document;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.WithPayload;
import org.projectnessie.versioned.mongodb.MongoBaseValue;
import org.projectnessie.versioned.mongodb.MongoSerDe;
import org.projectnessie.versioned.tiered.Fragment;

final class MongoFragment
extends MongoBaseValue<Fragment>
implements Fragment {
    static final String KEY_LIST = "keys";

    static void produce(Document document, Fragment v) {
        MongoFragment.produceBase(document, v).keys(MongoSerDe.deserializeKeys(document, KEY_LIST));
    }

    MongoFragment(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    public Fragment keys(Stream<WithPayload<Key>> keys) {
        this.addProperty(KEY_LIST);
        this.bsonWriter.writeStartArray(KEY_LIST);
        keys.forEach(k -> {
            String payload = k.getPayload() == null ? Character.toString('\u0000') : k.getPayload().toString();
            this.bsonWriter.writeStartArray();
            this.bsonWriter.writeString(payload);
            ((Key)k.getValue()).getElements().forEach(arg_0 -> ((BsonWriter)this.bsonWriter).writeString(arg_0));
            this.bsonWriter.writeEndArray();
        });
        this.bsonWriter.writeEndArray();
        return this;
    }

    @Override
    BsonWriter build() {
        this.checkPresent(KEY_LIST, KEY_LIST);
        return super.build();
    }
}

