/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.bson.BsonBinary;
import org.bson.BsonWriter;
import org.bson.Document;
import org.projectnessie.versioned.mongodb.MongoSerDe;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.tiered.BaseValue;

abstract class MongoBaseValue<C extends BaseValue<C>>
implements BaseValue<C> {
    static final String ID = "id";
    static final String DT = "dt";
    final BsonWriter bsonWriter;
    private final Set<String> properties = new HashSet<String>();

    static <C extends BaseValue<C>> C produceBase(Document document, C v) {
        return (C)v.id(MongoSerDe.deserializeId(document, ID)).dt(document.getLong((Object)DT).longValue());
    }

    protected MongoBaseValue(BsonWriter bsonWriter) {
        this.bsonWriter = bsonWriter;
    }

    public C id(Id id) {
        if (!this.properties.contains(ID)) {
            this.serializeId(ID, id);
        }
        return (C)this;
    }

    public C dt(long dt) {
        if (this.properties.contains(DT)) {
            throw new IllegalStateException(String.format("Property '%s' already serialized.", DT));
        }
        this.serializeLong(DT, dt);
        return (C)this;
    }

    BsonWriter build() {
        this.checkPresent(ID, ID);
        this.checkPresent(DT, DT);
        return this.bsonWriter;
    }

    void addProperty(String id) {
        if (!this.properties.add(id)) {
            throw new IllegalStateException(String.format("Property '%s' already serialized.", id));
        }
    }

    void checkPresent(String id, String name) {
        Preconditions.checkArgument((boolean)this.properties.contains(id), (Object)String.format("Method %s of consumer %s has not been called", name, this.getClass().getSimpleName()));
    }

    void checkNotPresent(String id, String name) {
        Preconditions.checkArgument((!this.properties.contains(id) ? 1 : 0) != 0, (Object)String.format("Method %s of consumer %s must not be called", name, this.getClass().getSimpleName()));
    }

    void serializeId(String property, Id id) {
        this.addProperty(property);
        MongoSerDe.serializeId(this.bsonWriter, property, id);
    }

    void serializeLong(String property, long value) {
        this.addProperty(property);
        this.bsonWriter.writeInt64(property, value);
    }

    void serializeIds(String property, Stream<Id> ids) {
        this.addProperty(property);
        this.bsonWriter.writeStartArray(property);
        ids.forEach(id -> this.bsonWriter.writeBinaryData(new BsonBinary(id.toBytes())));
        this.bsonWriter.writeEndArray();
    }

    void serializeString(String property, String str) {
        this.addProperty(property);
        this.bsonWriter.writeString(property, str);
    }

    <X> void serializeArray(String prop, Stream<X> src, BiConsumer<BsonWriter, X> inner) {
        this.addProperty(prop);
        MongoSerDe.serializeArray(this.bsonWriter, prop, src, inner);
    }
}

