/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.mongodb;

import com.google.protobuf.ByteString;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.versioned.mongodb.MongoBaseValue;
import org.projectnessie.versioned.mongodb.MongoSerDe;
import org.projectnessie.versioned.tiered.BaseWrappedValue;

class MongoWrappedValue<C extends BaseWrappedValue<C>>
extends MongoBaseValue<C>
implements BaseWrappedValue<C> {
    static final String VALUE = "value";

    static <C extends BaseWrappedValue<C>> void produce(Document document, C v) {
        MongoWrappedValue.produceBase(document, v).value(ByteString.copyFrom((byte[])((Binary)document.get((Object)VALUE)).getData()));
    }

    MongoWrappedValue(BsonWriter bsonWriter) {
        super(bsonWriter);
    }

    public C value(ByteString value) {
        this.addProperty(VALUE);
        this.bsonWriter.writeBinaryData(VALUE, MongoSerDe.serializeBytes(value));
        return (C)this;
    }

    @Override
    BsonWriter build() {
        this.checkPresent(VALUE, VALUE);
        return super.build();
    }
}

