/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.versioned.tests;

import com.dremio.nessie.versioned.impl.InternalRef;
import com.dremio.nessie.versioned.impl.L1;
import com.dremio.nessie.versioned.impl.SampleEntities;
import com.dremio.nessie.versioned.store.HasId;
import com.dremio.nessie.versioned.store.NotFoundException;
import com.dremio.nessie.versioned.store.SaveOp;
import com.dremio.nessie.versioned.store.SimpleSchema;
import com.dremio.nessie.versioned.store.Store;
import com.dremio.nessie.versioned.store.ValueType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractTestStore<S extends Store> {
    private Random random;
    protected S store;

    @BeforeEach
    public void setup() {
        if (this.store == null) {
            this.store = this.createStore();
            this.store.start();
            this.random = new Random(this.getRandomSeed());
        }
    }

    @AfterEach
    public void reset() {
        this.resetStoreState();
    }

    protected abstract S createStore();

    protected abstract long getRandomSeed();

    protected abstract void resetStoreState();

    @Test
    public void loadSingleL1() {
        this.putThenLoad(SampleEntities.createL1(this.random), ValueType.L1);
    }

    @Test
    public void loadSingleL2() {
        this.putThenLoad(SampleEntities.createL2(this.random), ValueType.L2);
    }

    @Test
    public void loadSingleL3() {
        this.putThenLoad(SampleEntities.createL3(this.random), ValueType.L3);
    }

    @Test
    public void loadFragment() {
        this.putThenLoad(SampleEntities.createFragment(this.random), ValueType.KEY_FRAGMENT);
    }

    @Test
    public void loadBranch() {
        this.putThenLoad(SampleEntities.createBranch(this.random), ValueType.REF);
    }

    @Test
    public void loadTag() {
        this.putThenLoad(SampleEntities.createTag(this.random), ValueType.REF);
    }

    @Test
    public void loadCommitMetadata() {
        this.putThenLoad(SampleEntities.createCommitMetadata(this.random), ValueType.COMMIT_METADATA);
    }

    @Test
    public void loadValue() {
        this.putThenLoad(SampleEntities.createValue(this.random), ValueType.VALUE);
    }

    @Test
    public void putIfAbsentL1() {
        this.testPutIfAbsent(SampleEntities.createL1(this.random), ValueType.L1);
    }

    @Test
    public void putIfAbsentL2() {
        this.testPutIfAbsent(SampleEntities.createL2(this.random), ValueType.L2);
    }

    @Test
    public void putIfAbsentL3() {
        this.testPutIfAbsent(SampleEntities.createL3(this.random), ValueType.L3);
    }

    @Test
    public void putIfAbsentFragment() {
        this.testPutIfAbsent(SampleEntities.createFragment(this.random), ValueType.KEY_FRAGMENT);
    }

    @Test
    public void putIfAbsentBranch() {
        this.testPutIfAbsent(SampleEntities.createBranch(this.random), ValueType.REF);
    }

    @Test
    public void putIfAbsentTag() {
        this.testPutIfAbsent(SampleEntities.createTag(this.random), ValueType.REF);
    }

    @Test
    public void putIfAbsentCommitMetadata() {
        this.testPutIfAbsent(SampleEntities.createCommitMetadata(this.random), ValueType.COMMIT_METADATA);
    }

    @Test
    public void putIfAbsentValue() {
        this.testPutIfAbsent(SampleEntities.createValue(this.random), ValueType.VALUE);
    }

    @Test
    public void save() {
        L1 l1 = SampleEntities.createL1(this.random);
        InternalRef branch = SampleEntities.createBranch(this.random);
        InternalRef tag = SampleEntities.createTag(this.random);
        ImmutableList saveOps = ImmutableList.of((Object)new SaveOp(ValueType.L1, (HasId)l1), (Object)new SaveOp(ValueType.REF, (HasId)branch), (Object)new SaveOp(ValueType.REF, (HasId)tag));
        this.store.save((List)saveOps);
        saveOps.forEach(s -> {
            try {
                SimpleSchema schema = s.getType().getSchema();
                Assertions.assertEquals((Object)schema.itemToMap((Object)s.getValue(), true), (Object)schema.itemToMap(this.store.loadSingle(s.getType(), s.getValue().getId()), true));
            }
            catch (NotFoundException e) {
                Assertions.fail((Throwable)e);
            }
        });
    }

    private <T extends HasId> void putThenLoad(T sample, ValueType type) {
        try {
            this.store.put(type, sample, Optional.empty());
            this.testLoad(sample, type);
        }
        catch (NotFoundException e) {
            Assertions.fail((Throwable)e);
        }
    }

    private <T extends HasId> void testLoad(T sample, ValueType type) {
        try {
            HasId read = (HasId)this.store.loadSingle(type, sample.getId());
            SimpleSchema schema = type.getSchema();
            Assertions.assertEquals((Object)schema.itemToMap(sample, true), (Object)schema.itemToMap((Object)read, true));
        }
        catch (NotFoundException e) {
            Assertions.fail((Throwable)e);
        }
    }

    private <T extends HasId> void testPutIfAbsent(T sample, ValueType type) {
        Assertions.assertTrue((boolean)this.store.putIfAbsent(type, sample));
        this.testLoad(sample, type);
        Assertions.assertFalse((boolean)this.store.putIfAbsent(type, sample));
        this.testLoad(sample, type);
    }
}

