/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableBranchName;
import org.projectnessie.versioned.ImmutableKey;
import org.projectnessie.versioned.ImmutablePut;
import org.projectnessie.versioned.ImmutableTagName;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.impl.AbstractTieredStoreFixture;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InconsistentValue;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.Store;

public abstract class AbstractITTieredVersionStore {
    private AbstractTieredStoreFixture<?, ?> fixture;

    @BeforeEach
    void setup() {
        this.fixture = this.createNewFixture();
    }

    @AfterEach
    void deleteResources() throws Exception {
        this.fixture.close();
    }

    public VersionStore<String, String> versionStore() {
        return this.fixture;
    }

    public Store store() {
        return this.fixture.getStore();
    }

    protected abstract AbstractTieredStoreFixture<?, ?> createNewFixture();

    @Test
    void checkDuplicateValueCommit() throws Exception {
        BranchName branch = BranchName.of((String)"dupe-values");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world")));
        Assertions.assertEquals((Object)"world", (Object)this.versionStore().getValue((Ref)branch, Key.of((String[])new String[]{"hi"})));
        Assertions.assertEquals((Object)"world", (Object)this.versionStore().getValue((Ref)branch, Key.of((String[])new String[]{"no"})));
    }

    @Test
    void mergeToEmpty() throws Exception {
        BranchName branch1 = BranchName.of((String)"b1");
        BranchName branch2 = BranchName.of((String)"b2");
        this.versionStore().create((NamedRef)branch1, Optional.empty());
        this.versionStore().create((NamedRef)branch2, Optional.empty());
        this.versionStore().commit(branch2, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world")));
        this.versionStore().merge(this.versionStore().toHash((NamedRef)branch2), branch1, Optional.of(this.versionStore().toHash((NamedRef)branch1)));
    }

    @Test
    void mergeNoConflict() throws Exception {
        BranchName branch1 = BranchName.of((String)"b1");
        BranchName branch2 = BranchName.of((String)"b2");
        this.versionStore().create((NamedRef)branch1, Optional.empty());
        this.versionStore().commit(branch1, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"foo"}), (Object)"world1"), (Object)Put.of((Key)Key.of((String[])new String[]{"bar"}), (Object)"world2")));
        this.versionStore().create((NamedRef)branch2, Optional.empty());
        this.versionStore().commit(branch2, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world3"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world4")));
        this.versionStore().merge(this.versionStore().toHash((NamedRef)branch2), branch1, Optional.of(this.versionStore().toHash((NamedRef)branch1)));
        Assertions.assertEquals((Object)"world1", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"foo"})));
        Assertions.assertEquals((Object)"world2", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"bar"})));
        Assertions.assertEquals((Object)"world3", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"hi"})));
        Assertions.assertEquals((Object)"world4", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"no"})));
    }

    @Test
    void mergeConflict() throws Exception {
        BranchName branch1 = BranchName.of((String)"b1");
        BranchName branch2 = BranchName.of((String)"b2");
        this.versionStore().create((NamedRef)branch1, Optional.empty());
        this.versionStore().commit(branch1, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"conflictKey"}), (Object)"world1")));
        this.versionStore().create((NamedRef)branch2, Optional.empty());
        this.versionStore().commit(branch2, Optional.empty(), (Object)"metadata2", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"conflictKey"}), (Object)"world2")));
        ReferenceConflictException ex = (ReferenceConflictException)Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().merge(this.versionStore().toHash((NamedRef)branch2), branch1, Optional.of(this.versionStore().toHash((NamedRef)branch1))));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"conflictKey"));
    }

    @Test
    void checkKeyList() throws Exception {
        BranchName branch = BranchName.of((String)"my-key-list");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Assertions.assertEquals((int)0, (int)((InternalL2)EntityType.L2.loadSingle(this.store(), InternalL2.EMPTY_ID)).size());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"mad mad"}), (Object)"world")));
        Assertions.assertEquals((int)0, (int)((InternalL2)EntityType.L2.loadSingle(this.store(), InternalL2.EMPTY_ID)).size());
        MatcherAssert.assertThat((Object)((ImmutableSet)this.versionStore().getKeys((Ref)branch).map(Key::toString).collect(ImmutableSet.toImmutableSet())), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"hi", "no", "mad mad"}));
    }

    @Test
    void ensureKeyCheckpointsAndMultiFragmentsWork() throws Exception {
        BranchName branch = BranchName.of((String)"lots-of-keys");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash current = this.versionStore().toHash((NamedRef)branch);
        Random r = new Random(1234L);
        char[] longName = new char[4096];
        Arrays.fill(longName, 'a');
        String prefix = new String(longName);
        LinkedList<Key> names = new LinkedList<Key>();
        for (int i = 1; i < 200; ++i) {
            if (i % 5 == 0) {
                Key removal = (Key)names.remove(r.nextInt(names.size()));
                this.versionStore().commit(branch, Optional.of(current), (Object)("commit " + i), Collections.singletonList(Delete.of((Key)removal)));
            } else {
                Key name = Key.of((String[])new String[]{prefix + i});
                names.add(name);
                this.versionStore().commit(branch, Optional.of(current), (Object)("commit " + i), Collections.singletonList(Put.of((Key)name, (Object)"bar")));
            }
            current = this.versionStore().toHash((NamedRef)branch);
        }
        List keysFromStore = this.versionStore().getKeys((Ref)branch).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)(keysFromStore.size() * longName.length), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(400000)));
        MatcherAssert.assertThat(keysFromStore, (Matcher)Matchers.containsInAnyOrder((Object[])names.toArray(new Key[0])));
    }

    @Test
    void multiload() throws Exception {
        BranchName branch = BranchName.of((String)"my-key-list");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world1"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world2"), (Object)Put.of((Key)Key.of((String[])new String[]{"mad mad"}), (Object)"world3")));
        Assertions.assertEquals(Arrays.asList("world1", "world2", "world3"), this.versionStore().getValues((Ref)branch, Arrays.asList(Key.of((String[])new String[]{"hi"}), Key.of((String[])new String[]{"no"}), Key.of((String[])new String[]{"mad mad"}))).stream().map(Optional::get).collect(Collectors.toList()));
    }

    @Test
    void ensureValidEmptyBranchState() throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"empty_branch");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash hash = this.versionStore().toHash((NamedRef)branch);
        Assertions.assertEquals(null, (Object)this.versionStore().getValue((Ref)hash, Key.of((String[])new String[]{"arbitrary"})));
    }

    @Test
    void createAndDeleteTag() throws Exception {
        TagName tag = TagName.of((String)"foo");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.versionStore().create((NamedRef)tag, Optional.empty()));
        this.versionStore().create((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertEquals((Object)InternalL1.EMPTY_ID.toHash(), (Object)this.versionStore().toHash((NamedRef)tag));
        Assertions.assertThrows(ReferenceAlreadyExistsException.class, () -> this.versionStore().create((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash())));
        this.versionStore().delete((NamedRef)tag, Optional.empty());
        this.versionStore().create((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)tag, Optional.of(Id.EMPTY.toHash())));
        this.versionStore().delete((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().create((NamedRef)tag, Optional.of(Id.generateRandom().toHash())));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().delete((NamedRef)tag, Optional.empty()));
    }

    @Test
    void createAndDeleteBranch() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertEquals((Object)InternalL1.EMPTY_ID.toHash(), (Object)this.versionStore().toHash((NamedRef)branch));
        this.versionStore().delete((NamedRef)branch, Optional.empty());
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Assertions.assertThrows(ReferenceAlreadyExistsException.class, () -> this.versionStore().create((NamedRef)branch, Optional.empty()));
        Assertions.assertThrows(ReferenceAlreadyExistsException.class, () -> this.versionStore().create((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash())));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)branch, Optional.of(Id.EMPTY.toHash())));
        this.versionStore().delete((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().create((NamedRef)branch, Optional.of(Id.generateRandom().toHash())));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().delete((NamedRef)branch, Optional.empty()));
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world")));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash())));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)TagName.of((String)"foo"), Optional.empty()));
    }

    @Test
    void conflictingCommit() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        Hash originalHash = ((WithHash)this.versionStore().getCommits((Ref)branch).findFirst().get()).getHash();
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertThrows(InconsistentValue.InconsistentValueException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"my world"))));
    }

    @Test
    void checkRefs() throws Exception {
        this.versionStore().create((NamedRef)BranchName.of((String)"b1"), Optional.empty());
        this.versionStore().create((NamedRef)BranchName.of((String)"b2"), Optional.empty());
        this.versionStore().create((NamedRef)TagName.of((String)"t1"), Optional.of(InternalL1.EMPTY_ID.toHash()));
        this.versionStore().create((NamedRef)TagName.of((String)"t2"), Optional.of(InternalL1.EMPTY_ID.toHash()));
        try (Stream str = this.versionStore().getNamedRefs();){
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"b1", (Object)"b2", (Object)"t1", (Object)"t2"), str.map(wh -> ((NamedRef)wh.getValue()).getName()).collect(Collectors.toSet()));
        }
    }

    @Test
    void checkCommits() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        String c1 = "c1";
        String c2 = "c2";
        Key k1 = Key.of((String[])new String[]{"hi"});
        String v1 = "hello world";
        String v1p = "goodbye world";
        Key k2 = Key.of((String[])new String[]{"my", "friend"});
        String v2 = "not here";
        this.versionStore().commit(branch, Optional.empty(), (Object)c1, (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)v1), (Object)Put.of((Key)k2, (Object)v2)));
        this.versionStore().commit(branch, Optional.empty(), (Object)c2, (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)v1p)));
        List commits = this.versionStore().getCommits((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((Object)ImmutableList.of((Object)c2, (Object)c1), commits.stream().map(wh -> (String)wh.getValue()).collect(Collectors.toList()));
        Assertions.assertEquals((Object)v1, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(1)).getHash(), k1));
        Assertions.assertEquals((Object)v1p, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(0)).getHash(), k1));
        Assertions.assertEquals((Object)v2, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(0)).getHash(), k2));
        Assertions.assertEquals((Object)v2, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(1)).getHash(), k2));
        Assertions.assertEquals((long)2L, (long)this.versionStore().getCommits((Ref)((WithHash)commits.get(0)).getHash()).count());
        TagName tag = TagName.of((String)"tag1");
        this.versionStore().create((NamedRef)tag, Optional.of(((WithHash)commits.get(0)).getHash()));
        Assertions.assertEquals((long)2L, (long)this.versionStore().getCommits((Ref)tag).count());
    }

    @Test
    void assignments() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Key k1 = Key.of((String[])new String[]{"p1"});
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)"v1")));
        Hash c1 = this.versionStore().toHash((NamedRef)branch);
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)"v2")));
        Hash c2 = this.versionStore().toHash((NamedRef)branch);
        TagName t1 = TagName.of((String)"t1");
        BranchName b2 = BranchName.of((String)"b2");
        this.versionStore().create((NamedRef)t1, Optional.of(c1));
        Assertions.assertEquals((Object)"v1", (Object)this.versionStore().getValue((Ref)t1, k1));
        this.versionStore().create((NamedRef)b2, Optional.empty());
        Assertions.assertEquals(null, (Object)this.versionStore().getValue((Ref)b2, k1));
        this.versionStore().assign((NamedRef)t1, Optional.of(c1), c2);
        Assertions.assertEquals((Object)"v2", (Object)this.versionStore().getValue((Ref)t1, k1));
        this.versionStore().assign((NamedRef)b2, Optional.empty(), c1);
        Assertions.assertEquals((Object)"v1", (Object)this.versionStore().getValue((Ref)b2, k1));
        this.versionStore().assign((NamedRef)b2, Optional.of(c1), c2);
        Assertions.assertEquals((Object)"v2", (Object)this.versionStore().getValue((Ref)b2, k1));
    }

    @Test
    void delete() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Key k1 = Key.of((String[])new String[]{"p1"});
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)"v1")));
        Assertions.assertEquals((Object)"v1", (Object)this.versionStore().getValue((Ref)branch, k1));
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Delete.of((Key)k1)));
        Assertions.assertEquals(null, (Object)this.versionStore().getValue((Ref)branch, k1));
    }

    @Test
    void unchangedOperation() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        Hash originalHash = ((WithHash)this.versionStore().getCommits((Ref)branch).findFirst().get()).getHash();
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertThrows(InconsistentValue.InconsistentValueException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"my world"))));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"bar"}), (Object)"mellow"), (Object)Unchanged.of((Key)Key.of((String[])new String[]{"hi"})))));
    }

    @Test
    void checkEmptyHistory() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Assertions.assertEquals((long)0L, (long)this.versionStore().getCommits((Ref)branch).count());
    }

    @Disabled
    @Test
    void completeFlow() throws Exception {
        ImmutableBranchName branch = ImmutableBranchName.builder().name("main").build();
        ImmutableBranchName branch2 = ImmutableBranchName.builder().name("b2").build();
        ImmutableTagName tag = ImmutableTagName.builder().name("t1").build();
        ImmutableKey p1 = ImmutableKey.builder().addElements("my.path").build();
        String commit1 = "my commit 1";
        String commit2 = "my commit 2";
        String v1 = "my.value";
        String v2 = "my.value2";
        this.versionStore().create((NamedRef)branch, Optional.empty());
        try {
            this.versionStore().create((NamedRef)branch, Optional.empty());
            Assertions.assertFalse((boolean)true, (String)"Creating the a branch with the same name as an existing one should fail but didn't.");
        }
        catch (ReferenceAlreadyExistsException referenceAlreadyExistsException) {
            // empty catch block
        }
        this.versionStore().commit((BranchName)branch, Optional.empty(), (Object)"my commit 1", (List)ImmutableList.of((Object)ImmutablePut.builder().key((Key)p1).shouldMatchHash(false).value((Object)"my.value").build()));
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)branch, (Key)p1));
        this.versionStore().create((NamedRef)tag, Optional.of(this.versionStore().toHash((NamedRef)branch)));
        this.versionStore().commit((BranchName)branch, Optional.empty(), (Object)"my commit 2", (List)ImmutableList.of((Object)ImmutablePut.builder().key((Key)p1).shouldMatchHash(false).value((Object)"my.value2").build()));
        Assertions.assertEquals((Object)"my.value2", (Object)this.versionStore().getValue((Ref)branch, (Key)p1));
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)tag, (Key)p1));
        List commits = this.versionStore().getCommits((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(1)).getHash(), (Key)p1));
        Assertions.assertEquals((Object)"my commit 1", (Object)((WithHash)commits.get(1)).getValue());
        Assertions.assertEquals((Object)"my.value2", (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(0)).getHash(), (Key)p1));
        Assertions.assertEquals((Object)"my commit 2", (Object)((WithHash)commits.get(0)).getValue());
        this.versionStore().assign((NamedRef)tag, Optional.of(((WithHash)commits.get(1)).getHash()), ((WithHash)commits.get(0)).getHash());
        Assertions.assertEquals(commits, this.versionStore().getCommits((Ref)tag).collect(Collectors.toList()));
        Assertions.assertEquals(commits, this.versionStore().getCommits((Ref)((WithHash)commits.get(0)).getHash()).collect(Collectors.toList()));
        try (Stream str = this.versionStore().getNamedRefs();){
            Assertions.assertEquals((long)2L, (long)str.count());
        }
        this.versionStore().create((NamedRef)branch2, Optional.of(((WithHash)commits.get(1)).getHash()));
        this.versionStore().delete((NamedRef)branch, Optional.of(((WithHash)commits.get(0)).getHash()));
        str = this.versionStore().getNamedRefs();
        try {
            Assertions.assertEquals((long)2L, (long)str.count());
        }
        finally {
            if (str != null) {
                str.close();
            }
        }
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)branch2, (Key)p1));
    }

    @Test
    void unknownRef() throws Exception {
        BranchName branch = BranchName.of((String)"bar");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        TagName tag = TagName.of((String)"foo");
        Hash expected = this.versionStore().toHash((NamedRef)branch);
        this.versionStore().create((NamedRef)tag, Optional.of(expected));
        this.testRefMatchesToRef((Ref)branch, expected, branch.getName());
        this.testRefMatchesToRef((Ref)tag, expected, tag.getName());
        this.testRefMatchesToRef((Ref)expected, expected, expected.asString());
    }

    private void testRefMatchesToRef(Ref ref, Hash hash, String name) throws ReferenceNotFoundException {
        WithHash val = this.versionStore().toRef(name);
        Assertions.assertEquals((Object)ref, (Object)val.getValue());
        Assertions.assertEquals((Object)hash, (Object)val.getHash());
    }
}

