/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.StringSerializer;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.impl.TieredVersionStore;
import org.projectnessie.versioned.store.Store;

public abstract class AbstractTieredStoreFixture<S extends Store, C>
implements VersionStore<String, String>,
AutoCloseable {
    protected static final StoreWorker<String, String> WORKER = StoreWorker.of((Serializer)StringSerializer.getInstance(), (Serializer)StringSerializer.getInstance());
    private final S store;
    private final C config;
    private final VersionStore<String, String> impl;

    public AbstractTieredStoreFixture(C config) {
        this.config = config;
        this.store = this.createStoreImpl();
        this.store.start();
        this.impl = new TieredVersionStore(WORKER, this.store, true);
    }

    public C getConfig() {
        return this.config;
    }

    public abstract S createStoreImpl();

    public S getStore() {
        return this.store;
    }

    public VersionStore<String, String> getWrapped() {
        return this.impl;
    }

    public Hash toHash(NamedRef ref) throws ReferenceNotFoundException {
        return this.impl.toHash(ref);
    }

    public void commit(BranchName branch, Optional<Hash> expectedHash, String metadata, List<Operation<String>> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        this.impl.commit(branch, expectedHash, (Object)metadata, operations);
    }

    public void transplant(BranchName targetBranch, Optional<Hash> expectedHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        this.impl.transplant(targetBranch, expectedHash, sequenceToTransplant);
    }

    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.impl.merge(fromHash, toBranch, expectedHash);
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.impl.assign(ref, expectedHash, targetHash);
    }

    public void create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        this.impl.create(ref, targetHash);
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.impl.delete(ref, hash);
    }

    public Stream<WithHash<NamedRef>> getNamedRefs() {
        return this.impl.getNamedRefs();
    }

    public Stream<WithHash<String>> getCommits(Ref ref) throws ReferenceNotFoundException {
        return this.impl.getCommits(ref);
    }

    public Stream<Key> getKeys(Ref ref) throws ReferenceNotFoundException {
        return this.impl.getKeys(ref);
    }

    public String getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return (String)this.impl.getValue(ref, key);
    }

    public List<Optional<String>> getValues(Ref ref, List<Key> key) throws ReferenceNotFoundException {
        return this.impl.getValues(ref, key);
    }

    public WithHash<Ref> toRef(String refOfUnknownType) throws ReferenceNotFoundException {
        return this.impl.toRef(refOfUnknownType);
    }

    public Stream<Diff<String>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        return this.impl.getDiffs(from, to);
    }

    public VersionStore.Collector collectGarbage() {
        return this.impl.collectGarbage();
    }
}

