/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableBranchName;
import org.projectnessie.versioned.ImmutableKey;
import org.projectnessie.versioned.ImmutablePut;
import org.projectnessie.versioned.ImmutableTagName;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.SerializerWithPayload;
import org.projectnessie.versioned.StringSerializer;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.Unchanged;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;
import org.projectnessie.versioned.impl.AbstractTieredStoreFixture;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InconsistentValue;
import org.projectnessie.versioned.impl.InternalBranch;
import org.projectnessie.versioned.impl.InternalCommitMetadata;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalRefId;
import org.projectnessie.versioned.impl.KeyList;
import org.projectnessie.versioned.impl.PartialTree;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.ValueType;

public abstract class AbstractITTieredVersionStore {
    private AbstractTieredStoreFixture<?, ?> fixture;

    @BeforeEach
    void setup() {
        this.fixture = this.createNewFixture();
    }

    @AfterEach
    void deleteResources() throws Exception {
        this.fixture.close();
    }

    public VersionStore<String, String, StringSerializer.TestEnum> versionStore() {
        return this.fixture;
    }

    public Store store() {
        return this.fixture.getStore();
    }

    protected abstract AbstractTieredStoreFixture<?, ?> createNewFixture();

    @Test
    void checkValueEntityType() throws Exception {
        BranchName branch = BranchName.of((String)"entity-types");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        ((SerializerWithPayload)Mockito.doReturn((Object)24).when((Object)StringSerializer.getInstance())).getPayload((Object)"world");
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world")));
        Assertions.assertEquals((Object)"world", (Object)this.versionStore().getValue((Ref)branch, Key.of((String[])new String[]{"hi"})));
        List values = this.versionStore().getValues((Ref)branch, (List)Lists.newArrayList((Object[])new Key[]{Key.of((String[])new String[]{"hi"})}));
        Assertions.assertEquals((int)1, (int)values.size());
        Assertions.assertTrue((boolean)((Optional)values.get(0)).isPresent());
        List keys = this.versionStore().getKeys((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)keys.size());
        Assertions.assertEquals((Object)Key.of((String[])new String[]{"hi"}), (Object)((WithType)keys.get(0)).getValue());
        Assertions.assertEquals((Object)StringSerializer.TestEnum.NO, (Object)((WithType)keys.get(0)).getType());
    }

    @Test
    void checkValueEntityTypeWithRemoval() throws Exception {
        BranchName branch = BranchName.of((String)"entity-types-with-removal");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        ((SerializerWithPayload)Mockito.doReturn((Object)24).when((Object)StringSerializer.getInstance())).getPayload((Object)"world");
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world")));
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Delete.of((Key)Key.of((String[])new String[]{"hi"}))));
        List keys = this.versionStore().getKeys((Ref)branch).collect(Collectors.toList());
        Assertions.assertTrue((boolean)keys.isEmpty());
    }

    @Test
    void checkValueEntityTypeWithModification() throws Exception {
        BranchName branch = BranchName.of((String)"entity-types-with-removal");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        ((SerializerWithPayload)Mockito.doReturn((Object)24).when((Object)StringSerializer.getInstance())).getPayload((Object)"world");
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world")));
        List keys = this.versionStore().getKeys((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)keys.size());
        Assertions.assertEquals((Object)Key.of((String[])new String[]{"hi"}), (Object)((WithType)keys.get(0)).getValue());
        Assertions.assertEquals((Object)StringSerializer.TestEnum.NO, (Object)((WithType)keys.get(0)).getType());
        ((SerializerWithPayload)Mockito.doReturn((Object)80).when((Object)StringSerializer.getInstance())).getPayload((Object)"world-weary");
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world-weary")));
        keys = this.versionStore().getKeys((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)keys.size());
        Assertions.assertEquals((Object)Key.of((String[])new String[]{"hi"}), (Object)((WithType)keys.get(0)).getValue());
        Assertions.assertEquals((Object)StringSerializer.TestEnum.YES, (Object)((WithType)keys.get(0)).getType());
    }

    @Test
    void checkDuplicateValueCommit() throws Exception {
        BranchName branch = BranchName.of((String)"dupe-values");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world")));
        Assertions.assertEquals((Object)"world", (Object)this.versionStore().getValue((Ref)branch, Key.of((String[])new String[]{"hi"})));
        Assertions.assertEquals((Object)"world", (Object)this.versionStore().getValue((Ref)branch, Key.of((String[])new String[]{"no"})));
    }

    @Test
    void mergeToEmpty() throws Exception {
        BranchName branch1 = BranchName.of((String)"b1");
        BranchName branch2 = BranchName.of((String)"b2");
        this.versionStore().create((NamedRef)branch1, Optional.empty());
        this.versionStore().create((NamedRef)branch2, Optional.empty());
        this.versionStore().commit(branch2, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world")));
        this.versionStore().merge(this.versionStore().toHash((NamedRef)branch2), branch1, Optional.of(this.versionStore().toHash((NamedRef)branch1)));
    }

    @Test
    void mergeNoConflict() throws Exception {
        BranchName branch1 = BranchName.of((String)"b1");
        BranchName branch2 = BranchName.of((String)"b2");
        Hash initial1 = this.versionStore().create((NamedRef)branch1, Optional.empty());
        Hash commit1 = this.versionStore().commit(branch1, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"foo"}), (Object)"world1"), (Object)Put.of((Key)Key.of((String[])new String[]{"bar"}), (Object)"world2")));
        Assertions.assertNotEquals((Object)initial1, (Object)commit1);
        Hash initial2 = this.versionStore().create((NamedRef)branch2, Optional.empty());
        Hash commit2 = this.versionStore().commit(branch2, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world3"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world4")));
        Assertions.assertNotEquals((Object)initial2, (Object)commit2);
        this.versionStore().merge(this.versionStore().toHash((NamedRef)branch2), branch1, Optional.of(this.versionStore().toHash((NamedRef)branch1)));
        Assertions.assertEquals((Object)"world1", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"foo"})));
        Assertions.assertEquals((Object)"world2", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"bar"})));
        Assertions.assertEquals((Object)"world3", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"hi"})));
        Assertions.assertEquals((Object)"world4", (Object)this.versionStore().getValue((Ref)branch1, Key.of((String[])new String[]{"no"})));
    }

    @Test
    void mergeConflict() throws Exception {
        BranchName branch1 = BranchName.of((String)"b1");
        BranchName branch2 = BranchName.of((String)"b2");
        Hash initial1 = this.versionStore().create((NamedRef)branch1, Optional.empty());
        Hash commit1 = this.versionStore().commit(branch1, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"conflictKey"}), (Object)"world1")));
        Assertions.assertNotEquals((Object)initial1, (Object)commit1);
        Hash initial2 = this.versionStore().create((NamedRef)branch2, Optional.empty());
        Hash commit2 = this.versionStore().commit(branch2, Optional.empty(), (Object)"metadata2", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"conflictKey"}), (Object)"world2")));
        Assertions.assertNotEquals((Object)initial2, (Object)commit2);
        ReferenceConflictException ex = (ReferenceConflictException)Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().merge(this.versionStore().toHash((NamedRef)branch2), branch1, Optional.of(this.versionStore().toHash((NamedRef)branch1))));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"conflictKey"));
    }

    @Test
    void checkKeyList() throws Exception {
        BranchName branch = BranchName.of((String)"my-key-list");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Assertions.assertEquals((int)0, (int)((InternalL2)EntityType.L2.loadSingle(this.store(), InternalL2.EMPTY_ID)).size());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world"), (Object)Put.of((Key)Key.of((String[])new String[]{"mad mad"}), (Object)"world")));
        Assertions.assertEquals((int)0, (int)((InternalL2)EntityType.L2.loadSingle(this.store(), InternalL2.EMPTY_ID)).size());
        MatcherAssert.assertThat((Object)((ImmutableSet)this.versionStore().getKeys((Ref)branch).map(WithType::getValue).map(Key::toString).collect(ImmutableSet.toImmutableSet())), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"hi", "no", "mad mad"}));
    }

    @Test
    void ensureKeyCheckpointsAndMultiFragmentsWork() throws Exception {
        BranchName branch = BranchName.of((String)"lots-of-keys");
        Hash initial = this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash current = this.versionStore().toHash((NamedRef)branch);
        Assertions.assertEquals((Object)current, (Object)initial);
        Random r = new Random(1234L);
        char[] longName = new char[4096];
        Arrays.fill(longName, 'a');
        String prefix = new String(longName);
        LinkedList<Key> names = new LinkedList<Key>();
        Hash last = current;
        for (int i = 1; i < 200; ++i) {
            Hash commitHash;
            if (i % 5 == 0) {
                Key removal = (Key)names.remove(r.nextInt(names.size()));
                commitHash = this.versionStore().commit(branch, Optional.of(current), (Object)("commit " + i), Collections.singletonList(Delete.of((Key)removal)));
            } else {
                Key name = Key.of((String[])new String[]{prefix + i});
                names.add(name);
                commitHash = this.versionStore().commit(branch, Optional.of(current), (Object)("commit " + i), Collections.singletonList(Put.of((Key)name, (Object)"bar")));
            }
            current = this.versionStore().toHash((NamedRef)branch);
            Assertions.assertEquals((Object)current, (Object)commitHash);
            Assertions.assertNotEquals((Object)last, (Object)current);
            last = current;
        }
        List keysFromStore = this.versionStore().getKeys((Ref)branch).map(WithType::getValue).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)(keysFromStore.size() * longName.length), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(400000)));
        MatcherAssert.assertThat(keysFromStore, (Matcher)Matchers.containsInAnyOrder((Object[])names.toArray(new Key[0])));
    }

    @Test
    void multiload() throws Exception {
        BranchName branch = BranchName.of((String)"my-key-list");
        Hash initialHash = this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash commitHash = this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world1"), (Object)Put.of((Key)Key.of((String[])new String[]{"no"}), (Object)"world2"), (Object)Put.of((Key)Key.of((String[])new String[]{"mad mad"}), (Object)"world3")));
        Assertions.assertNotEquals((Object)initialHash, (Object)commitHash);
        Assertions.assertEquals(Arrays.asList("world1", "world2", "world3"), this.versionStore().getValues((Ref)branch, Arrays.asList(Key.of((String[])new String[]{"hi"}), Key.of((String[])new String[]{"no"}), Key.of((String[])new String[]{"mad mad"}))).stream().map(Optional::get).collect(Collectors.toList()));
    }

    @Test
    void ensureValidEmptyBranchState() throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        BranchName branch = BranchName.of((String)"empty_branch");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash hash = this.versionStore().toHash((NamedRef)branch);
        Assertions.assertEquals(null, (Object)this.versionStore().getValue((Ref)hash, Key.of((String[])new String[]{"arbitrary"})));
    }

    @Test
    void createAndDeleteTag() throws Exception {
        TagName tag = TagName.of((String)"foo");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.versionStore().create((NamedRef)tag, Optional.empty()));
        this.versionStore().create((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertEquals((Object)InternalL1.EMPTY_ID.toHash(), (Object)this.versionStore().toHash((NamedRef)tag));
        Assertions.assertThrows(ReferenceAlreadyExistsException.class, () -> this.versionStore().create((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash())));
        this.versionStore().delete((NamedRef)tag, Optional.empty());
        this.versionStore().create((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)tag, Optional.of(Id.EMPTY.toHash())));
        this.versionStore().delete((NamedRef)tag, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().create((NamedRef)tag, Optional.of(Id.generateRandom().toHash())));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().delete((NamedRef)tag, Optional.empty()));
    }

    @Test
    void createAndDeleteBranch() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertEquals((Object)InternalL1.EMPTY_ID.toHash(), (Object)this.versionStore().toHash((NamedRef)branch));
        this.versionStore().delete((NamedRef)branch, Optional.empty());
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Assertions.assertThrows(ReferenceAlreadyExistsException.class, () -> this.versionStore().create((NamedRef)branch, Optional.empty()));
        Assertions.assertThrows(ReferenceAlreadyExistsException.class, () -> this.versionStore().create((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash())));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)branch, Optional.of(Id.EMPTY.toHash())));
        this.versionStore().delete((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash()));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().create((NamedRef)branch, Optional.of(Id.generateRandom().toHash())));
        Assertions.assertThrows(ReferenceNotFoundException.class, () -> this.versionStore().delete((NamedRef)branch, Optional.empty()));
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"world")));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)branch, Optional.of(InternalL1.EMPTY_ID.toHash())));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().delete((NamedRef)TagName.of((String)"foo"), Optional.empty()));
    }

    @Test
    void singleBranchManyUsersDistinctTables() throws Exception {
        this.singleBranchTest("singleBranchManyUsersDistinctTables", user -> String.format("user-table-%d", user), false);
    }

    @Test
    void singleBranchManyUsersSingleTable() throws Exception {
        this.singleBranchTest("singleBranchManyUsersSingleTable", user -> "single-table", true);
    }

    private void singleBranchTest(String branchName, IntFunction<String> tableNameGen, boolean allowInconsistentValueException) throws Exception {
        BranchName branch = BranchName.of((String)branchName);
        int numUsers = 5;
        int numCommits = 50;
        Object[] hashesKnownByUser = new Hash[numUsers];
        Hash createHash = this.versionStore().create((NamedRef)branch, Optional.empty());
        Arrays.fill(hashesKnownByUser, createHash);
        ArrayList<String> expectedValues = new ArrayList<String>();
        for (int commitNum = 0; commitNum < numCommits; ++commitNum) {
            for (int user = 0; user < numUsers; ++user) {
                Hash commitHash;
                Object hashKnownByUser = hashesKnownByUser[user];
                String msg = String.format("user %03d/commit %03d", user, commitNum);
                expectedValues.add(msg);
                String value = String.format("data_file_%03d_%03d", user, commitNum);
                Put put = Put.of((Key)Key.of((String[])new String[]{tableNameGen.apply(user)}), (Object)value);
                try {
                    commitHash = this.versionStore().commit(branch, Optional.of(hashKnownByUser), (Object)msg, (List)ImmutableList.of((Object)put));
                }
                catch (InconsistentValue.InconsistentValueException inconsistentValueException) {
                    if (allowInconsistentValueException) {
                        hashKnownByUser = this.versionStore().toHash((NamedRef)branch);
                        commitHash = this.versionStore().commit(branch, Optional.of(hashKnownByUser), (Object)msg, (List)ImmutableList.of((Object)put));
                    }
                    throw inconsistentValueException;
                }
                Assertions.assertNotEquals((Object)hashKnownByUser, (Object)commitHash);
                hashesKnownByUser[user] = commitHash;
            }
        }
        List committedValues = this.versionStore().getCommits((Ref)branch).map(WithHash::getValue).collect(Collectors.toList());
        Collections.reverse(expectedValues);
        Assertions.assertEquals(expectedValues, committedValues);
    }

    @Test
    void checkpointWithUnsavedL1() throws Exception {
        BranchName branch = BranchName.of((String)"checkpointWithUnsavedL1");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        InternalRefId ref = InternalRefId.of((Ref)branch);
        for (int i = 1; i < 50; ++i) {
            InternalBranch internalBranch = this.simulateCommit(ref, i);
            Assertions.assertEquals((long)i, (long)internalBranch.getCommits().stream().filter(c -> !c.isSaved()).count());
            KeyList keyList = internalBranch.getUpdateState(this.store()).unsafeGetL1().getKeyList();
            Assertions.assertFalse((boolean)keyList.isFull());
            Assertions.assertFalse((boolean)keyList.isEmptyIncremental());
            KeyList.IncrementalList incrementalList = (KeyList.IncrementalList)keyList;
            Assertions.assertEquals((int)i, (int)incrementalList.getDistanceFromCheckpointCommits());
        }
        InternalBranch internalBranch = this.simulateCommit(ref, 50);
        KeyList keyList = internalBranch.getUpdateState(this.store()).unsafeGetL1().getKeyList();
        Assertions.assertTrue((boolean)keyList.isFull());
        Assertions.assertFalse((boolean)keyList.isEmptyIncremental());
    }

    private InternalBranch simulateCommit(InternalRefId ref, int num) {
        List<Put> ops = Collections.singletonList(Put.of((Key)Key.of((String[])new String[]{"key" + num}), (Object)("foo" + num)));
        List keys = ops.stream().map(op -> new InternalKey(op.getKey())).collect(Collectors.toList());
        SerializerWithPayload serializer = AbstractTieredStoreFixture.WORKER.getValueSerializer();
        Serializer metadataSerializer = AbstractTieredStoreFixture.WORKER.getMetadataSerializer();
        PartialTree current = PartialTree.of((SerializerWithPayload)serializer, (InternalRefId)ref, keys);
        String incomingCommit = "metadata";
        InternalCommitMetadata metadata = InternalCommitMetadata.of((ByteString)metadataSerializer.toBytes((Object)incomingCommit));
        this.store().load(current.getLoadChain(b -> {
            InternalBranch.UpdateState updateState = b.getUpdateState(this.store());
            return updateState.unsafeGetL1();
        }, PartialTree.LoadType.NO_VALUES));
        ops.forEach(op -> current.setValueForKey(new InternalKey(op.getKey()), Optional.of((String)((Put)op).getValue())));
        this.store().save(Stream.concat(current.getMostSaveOps(), Stream.of(EntityType.COMMIT_METADATA.createSaveOpForEntity((PersistentBase)metadata))).collect(Collectors.toList()));
        PartialTree.CommitOp commitOp = current.getCommitOp(metadata.getId(), Collections.emptyList(), true, true);
        InternalRef.Builder builder = (InternalRef.Builder)EntityType.REF.newEntityProducer();
        boolean updated = this.store().update(ValueType.REF, ref.getId(), commitOp.getUpdateWithCommit(), Optional.of(commitOp.getTreeCondition()), Optional.of(builder));
        Assertions.assertTrue((boolean)updated);
        return builder.build().getBranch();
    }

    @Test
    void conflictingCommit() throws Exception {
        BranchName branch = BranchName.of((String)"conflictingCommit");
        Hash createHash = this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        Assertions.assertNotEquals((Object)createHash, (Object)initialHash);
        Hash originalHash = ((WithHash)this.versionStore().getCommits((Ref)branch).findFirst().get()).getHash();
        Assertions.assertEquals((Object)initialHash, (Object)originalHash);
        Hash firstHash = this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertNotEquals((Object)originalHash, (Object)firstHash);
        Hash secondHash = this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertNotEquals((Object)originalHash, (Object)secondHash);
        Assertions.assertNotEquals((Object)firstHash, (Object)secondHash);
        Assertions.assertThrows(InconsistentValue.InconsistentValueException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"my world"))));
    }

    @Test
    void conflictingCommitWithHash() throws Exception {
        BranchName branch = BranchName.of((String)"conflictingCommitWithHash");
        Hash createHash = this.versionStore().create((NamedRef)branch, Optional.empty());
        Hash initialHash = this.versionStore().commit(branch, Optional.of(createHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        Assertions.assertNotEquals((Object)createHash, (Object)initialHash);
        Hash originalHash = ((WithHash)this.versionStore().getCommits((Ref)branch).findFirst().get()).getHash();
        Assertions.assertEquals((Object)initialHash, (Object)originalHash);
        Hash firstHash = this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertNotEquals((Object)originalHash, (Object)firstHash);
        Hash secondHash = this.versionStore().commit(branch, Optional.of(firstHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertNotEquals((Object)originalHash, (Object)secondHash);
        Assertions.assertNotEquals((Object)firstHash, (Object)secondHash);
        Assertions.assertThrows(InconsistentValue.InconsistentValueException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"my world"))));
    }

    @Test
    void checkRefs() throws Exception {
        this.versionStore().create((NamedRef)BranchName.of((String)"b1"), Optional.empty());
        this.versionStore().create((NamedRef)BranchName.of((String)"b2"), Optional.empty());
        this.versionStore().create((NamedRef)TagName.of((String)"t1"), Optional.of(InternalL1.EMPTY_ID.toHash()));
        this.versionStore().create((NamedRef)TagName.of((String)"t2"), Optional.of(InternalL1.EMPTY_ID.toHash()));
        try (Stream str = this.versionStore().getNamedRefs();){
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"b1", (Object)"b2", (Object)"t1", (Object)"t2"), str.map(wh -> ((NamedRef)wh.getValue()).getName()).collect(Collectors.toSet()));
        }
    }

    @Test
    void commitRetryCountExceeded() throws Exception {
        BranchName branch = BranchName.of((String)"commitRetryCountExceeded");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        String c1 = "c1";
        String c2 = "c2";
        Key k1 = Key.of((String[])new String[]{"hi"});
        String v1 = "hello world";
        Key k2 = Key.of((String[])new String[]{"my", "friend"});
        String v2 = "not here";
        ((Store)Mockito.doReturn((Object)false).when((Object)this.store())).update((ValueType)Mockito.any(), (Id)Mockito.any(), (UpdateExpression)Mockito.any(), (Optional)Mockito.any(), (Optional)Mockito.any());
        Assertions.assertEquals((Object)"Unable to complete commit due to conflicting events. Retried 5 times before failing.", (Object)((ReferenceConflictException)Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().commit(branch, Optional.empty(), (Object)c1, (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)v1), (Object)Put.of((Key)k2, (Object)v2))))).getMessage());
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 4})
    void checkCommits(int numStoreUpdateFailures) throws Exception {
        BranchName branch = BranchName.of((String)("checkCommits" + numStoreUpdateFailures));
        this.versionStore().create((NamedRef)branch, Optional.empty());
        String c1 = "c1";
        String c2 = "c2";
        Key k1 = Key.of((String[])new String[]{"hi"});
        String v1 = "hello world";
        String v1p = "goodbye world";
        Key k2 = Key.of((String[])new String[]{"my", "friend"});
        String v2 = "not here";
        AtomicInteger commitUpdateTry = new AtomicInteger();
        ((Store)Mockito.doAnswer(invocationOnMock -> {
            if (commitUpdateTry.getAndIncrement() < numStoreUpdateFailures) {
                return false;
            }
            return invocationOnMock.callRealMethod();
        }).when((Object)this.store())).update((ValueType)Mockito.any(), (Id)Mockito.any(), (UpdateExpression)Mockito.any(), (Optional)Mockito.any(), (Optional)Mockito.any());
        this.versionStore().commit(branch, Optional.empty(), (Object)c1, (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)v1), (Object)Put.of((Key)k2, (Object)v2)));
        commitUpdateTry.set(0);
        this.versionStore().commit(branch, Optional.empty(), (Object)c2, (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)v1p)));
        List commits = this.versionStore().getCommits((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((Object)ImmutableList.of((Object)c2, (Object)c1), commits.stream().map(WithHash::getValue).collect(Collectors.toList()));
        Assertions.assertEquals((Object)v1, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(1)).getHash(), k1));
        Assertions.assertEquals((Object)v1p, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(0)).getHash(), k1));
        Assertions.assertEquals((Object)v2, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(0)).getHash(), k2));
        Assertions.assertEquals((Object)v2, (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(1)).getHash(), k2));
        Assertions.assertEquals((long)2L, (long)this.versionStore().getCommits((Ref)((WithHash)commits.get(0)).getHash()).count());
        TagName tag = TagName.of((String)"tag1");
        this.versionStore().create((NamedRef)tag, Optional.of(((WithHash)commits.get(0)).getHash()));
        Assertions.assertEquals((long)2L, (long)this.versionStore().getCommits((Ref)tag).count());
    }

    @Test
    void assignments() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Key k1 = Key.of((String[])new String[]{"p1"});
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)"v1")));
        Hash c1 = this.versionStore().toHash((NamedRef)branch);
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)"v2")));
        Hash c2 = this.versionStore().toHash((NamedRef)branch);
        TagName t1 = TagName.of((String)"t1");
        BranchName b2 = BranchName.of((String)"b2");
        this.versionStore().create((NamedRef)t1, Optional.of(c1));
        Assertions.assertEquals((Object)"v1", (Object)this.versionStore().getValue((Ref)t1, k1));
        this.versionStore().create((NamedRef)b2, Optional.empty());
        Assertions.assertEquals(null, (Object)this.versionStore().getValue((Ref)b2, k1));
        this.versionStore().assign((NamedRef)t1, Optional.of(c1), c2);
        Assertions.assertEquals((Object)"v2", (Object)this.versionStore().getValue((Ref)t1, k1));
        this.versionStore().assign((NamedRef)b2, Optional.empty(), c1);
        Assertions.assertEquals((Object)"v1", (Object)this.versionStore().getValue((Ref)b2, k1));
        this.versionStore().assign((NamedRef)b2, Optional.of(c1), c2);
        Assertions.assertEquals((Object)"v2", (Object)this.versionStore().getValue((Ref)b2, k1));
    }

    @Test
    void delete() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        Key k1 = Key.of((String[])new String[]{"p1"});
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Put.of((Key)k1, (Object)"v1")));
        Assertions.assertEquals((Object)"v1", (Object)this.versionStore().getValue((Ref)branch, k1));
        this.versionStore().commit(branch, Optional.empty(), (Object)"c1", (List)ImmutableList.of((Object)Delete.of((Key)k1)));
        Assertions.assertEquals(null, (Object)this.versionStore().getValue((Ref)branch, k1));
    }

    @Test
    void unchangedOperation() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        Hash originalHash = ((WithHash)this.versionStore().getCommits((Ref)branch).findFirst().get()).getHash();
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"goodbye world")));
        Assertions.assertThrows(InconsistentValue.InconsistentValueException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"my world"))));
        Assertions.assertThrows(ReferenceConflictException.class, () -> this.versionStore().commit(branch, Optional.of(originalHash), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"bar"}), (Object)"mellow"), (Object)Unchanged.of((Key)Key.of((String[])new String[]{"hi"})))));
    }

    @Test
    void checkEmptyHistory() throws Exception {
        BranchName branch = BranchName.of((String)"foo");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        Assertions.assertEquals((long)0L, (long)this.versionStore().getCommits((Ref)branch).count());
    }

    @Disabled
    @Test
    void completeFlow() throws Exception {
        ImmutableBranchName branch = ImmutableBranchName.builder().name("main").build();
        ImmutableBranchName branch2 = ImmutableBranchName.builder().name("b2").build();
        ImmutableTagName tag = ImmutableTagName.builder().name("t1").build();
        ImmutableKey p1 = ImmutableKey.builder().addElements("my.path").build();
        String commit1 = "my commit 1";
        String commit2 = "my commit 2";
        String v1 = "my.value";
        String v2 = "my.value2";
        this.versionStore().create((NamedRef)branch, Optional.empty());
        try {
            this.versionStore().create((NamedRef)branch, Optional.empty());
            Assertions.assertFalse((boolean)true, (String)"Creating the a branch with the same name as an existing one should fail but didn't.");
        }
        catch (ReferenceAlreadyExistsException referenceAlreadyExistsException) {
            // empty catch block
        }
        this.versionStore().commit((BranchName)branch, Optional.empty(), (Object)"my commit 1", (List)ImmutableList.of((Object)ImmutablePut.builder().key((Key)p1).shouldMatchHash(false).value((Object)"my.value").build()));
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)branch, (Key)p1));
        this.versionStore().create((NamedRef)tag, Optional.of(this.versionStore().toHash((NamedRef)branch)));
        this.versionStore().commit((BranchName)branch, Optional.empty(), (Object)"my commit 2", (List)ImmutableList.of((Object)ImmutablePut.builder().key((Key)p1).shouldMatchHash(false).value((Object)"my.value2").build()));
        Assertions.assertEquals((Object)"my.value2", (Object)this.versionStore().getValue((Ref)branch, (Key)p1));
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)tag, (Key)p1));
        List commits = this.versionStore().getCommits((Ref)branch).collect(Collectors.toList());
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(1)).getHash(), (Key)p1));
        Assertions.assertEquals((Object)"my commit 1", (Object)((WithHash)commits.get(1)).getValue());
        Assertions.assertEquals((Object)"my.value2", (Object)this.versionStore().getValue((Ref)((WithHash)commits.get(0)).getHash(), (Key)p1));
        Assertions.assertEquals((Object)"my commit 2", (Object)((WithHash)commits.get(0)).getValue());
        this.versionStore().assign((NamedRef)tag, Optional.of(((WithHash)commits.get(1)).getHash()), ((WithHash)commits.get(0)).getHash());
        Assertions.assertEquals(commits, this.versionStore().getCommits((Ref)tag).collect(Collectors.toList()));
        Assertions.assertEquals(commits, this.versionStore().getCommits((Ref)((WithHash)commits.get(0)).getHash()).collect(Collectors.toList()));
        try (Stream str = this.versionStore().getNamedRefs();){
            Assertions.assertEquals((long)2L, (long)str.count());
        }
        this.versionStore().create((NamedRef)branch2, Optional.of(((WithHash)commits.get(1)).getHash()));
        this.versionStore().delete((NamedRef)branch, Optional.of(((WithHash)commits.get(0)).getHash()));
        str = this.versionStore().getNamedRefs();
        try {
            Assertions.assertEquals((long)2L, (long)str.count());
        }
        finally {
            if (str != null) {
                str.close();
            }
        }
        Assertions.assertEquals((Object)"my.value", (Object)this.versionStore().getValue((Ref)branch2, (Key)p1));
    }

    @Test
    void unknownRef() throws Exception {
        BranchName branch = BranchName.of((String)"bar");
        this.versionStore().create((NamedRef)branch, Optional.empty());
        this.versionStore().commit(branch, Optional.empty(), (Object)"metadata", (List)ImmutableList.of((Object)Put.of((Key)Key.of((String[])new String[]{"hi"}), (Object)"hello world")));
        TagName tag = TagName.of((String)"foo");
        Hash expected = this.versionStore().toHash((NamedRef)branch);
        this.versionStore().create((NamedRef)tag, Optional.of(expected));
        this.testRefMatchesToRef((Ref)branch, expected, branch.getName());
        this.testRefMatchesToRef((Ref)tag, expected, tag.getName());
        this.testRefMatchesToRef((Ref)expected, expected, expected.asString());
    }

    private void testRefMatchesToRef(Ref ref, Hash hash, String name) throws ReferenceNotFoundException {
        WithHash val = this.versionStore().toRef(name);
        Assertions.assertEquals((Object)ref, (Object)val.getValue());
        Assertions.assertEquals((Object)hash, (Object)val.getHash());
    }
}

