/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.projectnessie.versioned.impl.EntityLoadOps;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalFragment;
import org.projectnessie.versioned.impl.InternalKey;
import org.projectnessie.versioned.impl.InternalKeyWithPayload;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalTag;
import org.projectnessie.versioned.impl.PersistentBase;
import org.projectnessie.versioned.impl.SampleEntities;
import org.projectnessie.versioned.impl.condition.ConditionExpression;
import org.projectnessie.versioned.impl.condition.ExpressionFunction;
import org.projectnessie.versioned.impl.condition.ExpressionPath;
import org.projectnessie.versioned.impl.condition.RemoveClause;
import org.projectnessie.versioned.impl.condition.SetClause;
import org.projectnessie.versioned.impl.condition.UpdateClause;
import org.projectnessie.versioned.impl.condition.UpdateExpression;
import org.projectnessie.versioned.store.ConditionFailedException;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.HasId;
import org.projectnessie.versioned.store.LoadStep;
import org.projectnessie.versioned.store.NotFoundException;
import org.projectnessie.versioned.store.SaveOp;
import org.projectnessie.versioned.store.Store;
import org.projectnessie.versioned.store.ValueType;
import org.projectnessie.versioned.tiered.BaseValue;

public abstract class AbstractTestStore<S extends Store> {
    protected static final ExpressionPath COMMITS = ExpressionPath.builder((String)"commits").build();
    protected static final Entity ONE = Entity.ofNumber((int)1);
    protected static final Entity TWO = Entity.ofNumber((int)2);
    protected Random random;
    protected S store;

    @BeforeEach
    void setup() {
        if (this.store == null) {
            this.store = this.createStore();
            this.store.start();
            this.random = new Random(this.getRandomSeed());
        }
    }

    @AfterEach
    void reset() {
        this.resetStoreState();
    }

    protected abstract S createStore();

    protected abstract S createRawStore();

    protected abstract long getRandomSeed();

    protected abstract void resetStoreState();

    protected abstract int loadSize();

    protected boolean supportsDelete() {
        return true;
    }

    protected boolean supportsUpdate() {
        return true;
    }

    protected boolean supportsConditionExpression() {
        return true;
    }

    @Test
    void closeWithoutStart() {
        S localStore = this.createRawStore();
        localStore.close();
    }

    @Test
    void closeTwice() {
        S localStore = this.createRawStore();
        localStore.start();
        localStore.close();
        localStore.close();
    }

    private <C extends BaseValue<C>> void putThenLoad(ValueType<C> type, HasId sample) {
        this.store.put(new EntitySaveOp<C>(type, (PersistentBase)sample).saveOp, Optional.empty());
        this.testLoadSingle(type, sample);
    }

    protected <T extends HasId> void testLoadSingle(ValueType<?> type, T sample) {
        PersistentBase read = EntityType.forType(type).loadSingle(this.store, sample.getId());
        AbstractTestStore.assertEquals(sample, (HasId)read);
    }

    protected static void assertEquals(HasId expected, HasId actual) {
        Assertions.assertEquals((Object)expected, (Object)actual);
        Assertions.assertEquals((Object)expected.getId(), (Object)actual.getId());
    }

    @Nested
    @DisplayName(value="update() tests")
    class UpdateTests {
        UpdateTests() {
        }

        @Test
        void updateWithFailedCondition() {
            if (!AbstractTestStore.this.supportsUpdate() || !AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            InternalRef tag = SampleEntities.createTag(AbstractTestStore.this.random);
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)tag);
            ConditionExpression expression = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"name").build(), (Entity)Entity.ofString((String)"badTagName"))});
            Assertions.assertFalse((boolean)AbstractTestStore.this.store.update(ValueType.REF, tag.getId(), UpdateExpression.of((UpdateClause[])new UpdateClause[]{RemoveClause.of((ExpressionPath)ExpressionPath.builder((String)"metadata").build())}), Optional.of(expression), Optional.empty()));
        }

        @Test
        void updateWithSuccessfulCondition() {
            if (!AbstractTestStore.this.supportsUpdate() || !AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            String tagName = "myTag";
            InternalTag tag = SampleEntities.createTag(AbstractTestStore.this.random).getTag();
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)tag);
            ConditionExpression expression = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"name").build(), (Entity)Entity.ofString((String)"tagName"))});
            InternalRef.Builder builder = (InternalRef.Builder)EntityType.REF.newEntityProducer();
            boolean result = AbstractTestStore.this.store.update(ValueType.REF, tag.getId(), UpdateExpression.of((UpdateClause[])new UpdateClause[]{SetClause.equals((ExpressionPath)ExpressionPath.builder((String)"name").build(), (Entity)Entity.ofString((String)"myTag"))}), Optional.of(expression), Optional.of(builder));
            Assertions.assertTrue((boolean)result);
            InternalTag updated = builder.build().getTag();
            Assertions.assertEquals((Object)tag.getId(), (Object)updated.getId());
            Assertions.assertEquals((Object)tag.getCommit(), (Object)updated.getCommit());
            Assertions.assertEquals((long)tag.getDt(), (long)updated.getDt());
            Assertions.assertNotEquals((Object)tag.getName(), (Object)updated.getName());
            Assertions.assertEquals((Object)"myTag", (Object)updated.getName());
            AbstractTestStore.this.testLoadSingle(ValueType.REF, updated);
        }

        @Test
        protected void updateRemoveOneArray() {
            this.updateRemoveArray(UpdateExpression.of((UpdateClause[])new UpdateClause[]{RemoveClause.of((ExpressionPath)ExpressionPath.builder((String)"keys").position(0).build())}), 1, 10);
        }

        @Test
        protected void updateRemoveOneArrayEnd() {
            this.updateRemoveArray(UpdateExpression.of((UpdateClause[])new UpdateClause[]{RemoveClause.of((ExpressionPath)ExpressionPath.builder((String)"keys").position(9).build())}), 0, 9);
        }

        @Test
        protected void updateRemoveMultipleArrayAscending() {
            UpdateExpression update = UpdateExpression.of((UpdateClause[])new UpdateClause[0]);
            for (int i = 0; i < 5; ++i) {
                update = update.and((UpdateClause)RemoveClause.of((ExpressionPath)ExpressionPath.builder((String)"keys").position(i).build()));
            }
            this.updateRemoveArray(update, 5, 10);
        }

        @Test
        protected void updateRemoveMultipleArrayDescending() {
            UpdateExpression update = UpdateExpression.of((UpdateClause[])new UpdateClause[0]);
            for (int i = 4; i >= 0; --i) {
                update = update.and((UpdateClause)RemoveClause.of((ExpressionPath)ExpressionPath.builder((String)"keys").position(i).build()));
            }
            this.updateRemoveArray(update, 5, 10);
        }

        @Test
        void updateSetEquals() {
            if (!AbstractTestStore.this.supportsUpdate()) {
                return;
            }
            String tagName = "myTag";
            InternalTag tag = SampleEntities.createTag(AbstractTestStore.this.random).getTag();
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)tag);
            InternalRef.Builder builder = (InternalRef.Builder)EntityType.REF.newEntityProducer();
            boolean result = AbstractTestStore.this.store.update(ValueType.REF, tag.getId(), UpdateExpression.of((UpdateClause[])new UpdateClause[]{SetClause.equals((ExpressionPath)ExpressionPath.builder((String)"name").build(), (Entity)Entity.ofString((String)"myTag"))}), Optional.empty(), Optional.of(builder));
            Assertions.assertTrue((boolean)result);
            InternalTag updated = builder.build().getTag();
            Assertions.assertEquals((Object)tag.getId(), (Object)updated.getId());
            Assertions.assertEquals((Object)tag.getCommit(), (Object)updated.getCommit());
            Assertions.assertEquals((long)tag.getDt(), (long)updated.getDt());
            Assertions.assertNotEquals((Object)tag.getName(), (Object)updated.getName());
            Assertions.assertEquals((Object)"myTag", (Object)updated.getName());
            AbstractTestStore.this.testLoadSingle(ValueType.REF, updated);
        }

        @Test
        void updateSetListAppend() {
            if (!AbstractTestStore.this.supportsUpdate()) {
                return;
            }
            String key = "newKey";
            InternalFragment fragment = SampleEntities.createFragment(AbstractTestStore.this.random);
            AbstractTestStore.this.putThenLoad(ValueType.KEY_FRAGMENT, (HasId)fragment);
            InternalFragment.Builder builder = (InternalFragment.Builder)EntityType.KEY_FRAGMENT.newEntityProducer();
            boolean result = AbstractTestStore.this.store.update(ValueType.KEY_FRAGMENT, fragment.getId(), UpdateExpression.of((UpdateClause[])new UpdateClause[]{SetClause.appendToList((ExpressionPath)ExpressionPath.builder((String)"keys").build(), (Entity)Entity.ofList((Entity[])new Entity[]{Entity.ofList((Entity[])new Entity[]{Entity.ofString((String)"24"), Entity.ofString((String)"newKey")})}))}), Optional.empty(), Optional.of(builder));
            Assertions.assertTrue((boolean)result);
            InternalFragment updated = builder.build();
            Assertions.assertEquals((Object)fragment.getId(), (Object)updated.getId());
            ArrayList<InternalKeyWithPayload> oldKeys = new ArrayList<InternalKeyWithPayload>(fragment.getKeys());
            oldKeys.add(InternalKeyWithPayload.of((Byte)24, (InternalKey)InternalKey.fromEntity((Entity)Entity.ofList((Entity[])new Entity[]{Entity.ofString((String)"newKey")}))));
            Assertions.assertEquals(oldKeys, (Object)updated.getKeys());
            AbstractTestStore.this.testLoadSingle(ValueType.KEY_FRAGMENT, updated);
        }

        private void updateRemoveArray(UpdateExpression update, int beginArrayIndex, int endArrayIndex) {
            if (!AbstractTestStore.this.supportsUpdate()) {
                return;
            }
            InternalFragment fragment = SampleEntities.createFragment(AbstractTestStore.this.random);
            AbstractTestStore.this.putThenLoad(ValueType.KEY_FRAGMENT, (HasId)fragment);
            InternalFragment.Builder builder = (InternalFragment.Builder)EntityType.KEY_FRAGMENT.newEntityProducer();
            boolean result = AbstractTestStore.this.store.update(ValueType.KEY_FRAGMENT, fragment.getId(), update, Optional.empty(), Optional.of(builder));
            Assertions.assertTrue((boolean)result);
            InternalFragment updated = builder.build();
            Assertions.assertEquals((Object)fragment.getId(), (Object)updated.getId());
            List oldKeys = fragment.getKeys().subList(beginArrayIndex, endArrayIndex);
            Assertions.assertEquals(oldKeys, (Object)updated.getKeys());
            AbstractTestStore.this.testLoadSingle(ValueType.KEY_FRAGMENT, updated);
        }
    }

    @Nested
    @DisplayName(value="delete() tests")
    class DeleteTests {
        DeleteTests() {
        }

        @Test
        void deleteNoConditionValue() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.VALUE, SampleEntities.createValue(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionL1() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.L1, SampleEntities.createL1(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionL2() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.L2, SampleEntities.createL2(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionL3() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.L3, SampleEntities.createL3(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionFragment() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.KEY_FRAGMENT, SampleEntities.createFragment(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionBranch() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionTag() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.REF, SampleEntities.createTag(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteNoConditionCommitMetadata() {
            if (!AbstractTestStore.this.supportsDelete()) {
                return;
            }
            this.deleteWithCondition(ValueType.COMMIT_METADATA, SampleEntities.createCommitMetadata(AbstractTestStore.this.random), true, Optional.empty());
        }

        @Test
        void deleteConditionMismatchAttributeValue() {
            if (!AbstractTestStore.this.supportsDelete() || !AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            ExpressionFunction expressionFunction = ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"value").build(), (Entity)SampleEntities.createStringEntity(AbstractTestStore.this.random, AbstractTestStore.this.random.nextInt(10) + 1));
            ConditionExpression ex = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{expressionFunction});
            this.deleteWithCondition(ValueType.VALUE, SampleEntities.createValue(AbstractTestStore.this.random), false, Optional.of(ex));
        }

        @Test
        void deleteConditionMismatchAttributeBranch() {
            if (!AbstractTestStore.this.supportsDelete() || !AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            ExpressionFunction expressionFunction = ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"commit").build(), (Entity)SampleEntities.createStringEntity(AbstractTestStore.this.random, AbstractTestStore.this.random.nextInt(10) + 1));
            ConditionExpression ex = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{expressionFunction});
            this.deleteWithCondition(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random), false, Optional.of(ex));
        }

        @Test
        void deleteBranchSizeFail() {
            if (!AbstractTestStore.this.supportsDelete() || !AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            ConditionExpression expression = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionFunction)ExpressionFunction.size((ExpressionPath)COMMITS), (Entity)ONE)});
            this.deleteWithCondition(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random), false, Optional.of(expression));
        }

        @Test
        void deleteBranchSizeSucceed() {
            if (!AbstractTestStore.this.supportsDelete() || !AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            ConditionExpression expression = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionFunction)ExpressionFunction.size((ExpressionPath)COMMITS), (Entity)TWO)});
            this.deleteWithCondition(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random), true, Optional.of(expression));
        }

        protected <T extends HasId> void deleteWithCondition(ValueType<?> type, T sample, boolean shouldSucceed, Optional<ConditionExpression> conditionExpression) {
            AbstractTestStore.this.putThenLoad(type, sample);
            if (shouldSucceed) {
                Assertions.assertTrue((boolean)AbstractTestStore.this.store.delete(type, sample.getId(), conditionExpression));
                Assertions.assertThrows(NotFoundException.class, () -> EntityType.forType((ValueType)type).loadSingle(AbstractTestStore.this.store, sample.getId()));
            } else {
                Assertions.assertFalse((boolean)AbstractTestStore.this.store.delete(type, sample.getId(), conditionExpression));
                AbstractTestStore.this.testLoadSingle(type, sample);
            }
        }
    }

    @Nested
    @DisplayName(value="put() tests")
    class PutWithoutConditionExpressionTests {
        PutWithoutConditionExpressionTests() {
        }

        @Test
        void putWithConditionValue() {
            this.putWithCondition(ValueType.VALUE, SampleEntities.createValue(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionBranch() {
            this.putWithCondition(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionTag() {
            this.putWithCondition(ValueType.REF, SampleEntities.createTag(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionCommitMetadata() {
            this.putWithCondition(ValueType.COMMIT_METADATA, SampleEntities.createCommitMetadata(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionKeyFragment() {
            this.putWithCondition(ValueType.KEY_FRAGMENT, SampleEntities.createFragment(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionL1() {
            this.putWithCondition(ValueType.L1, SampleEntities.createL1(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionL2() {
            this.putWithCondition(ValueType.L2, SampleEntities.createL2(AbstractTestStore.this.random));
        }

        @Test
        void putWithConditionL3() {
            this.putWithCondition(ValueType.L3, SampleEntities.createL3(AbstractTestStore.this.random));
        }

        @Test
        void putTwice() {
            InternalL3 l3 = SampleEntities.createL3(AbstractTestStore.this.random);
            AbstractTestStore.this.putThenLoad(ValueType.L3, (HasId)l3);
            AbstractTestStore.this.putThenLoad(ValueType.L3, (HasId)l3);
        }

        @Test
        void putWithCompoundConditionTag() {
            InternalRef sample = SampleEntities.createTag(AbstractTestStore.this.random);
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)sample);
            InternalRef.Type type = InternalRef.Type.TAG;
            ConditionExpression condition = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"type").build(), (Entity)type.toEntity()), ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"name").build(), (Entity)Entity.ofString((String)"tagName"))});
            this.putConditional(ValueType.REF, (HasId)sample, true, Optional.of(condition));
        }

        @Test
        void putWithFailingConditionExpression() {
            InternalRef sample = SampleEntities.createBranch(AbstractTestStore.this.random);
            InternalRef.Type type = InternalRef.Type.BRANCH;
            ConditionExpression condition = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"type").build(), (Entity)type.toEntity()), ExpressionFunction.equals((ExpressionPath)ExpressionPath.builder((String)"commit").build(), (Entity)Entity.ofString((String)"notEqual"))});
            this.putConditional(ValueType.REF, (HasId)sample, false, Optional.of(condition));
        }

        private <T extends HasId> void putWithCondition(ValueType<?> type, T sample) {
            AbstractTestStore.this.putThenLoad(type, sample);
            ExpressionPath keyName = ExpressionPath.builder((String)"id").build();
            ConditionExpression conditionExpression = ConditionExpression.of((ExpressionFunction[])new ExpressionFunction[]{ExpressionFunction.equals((ExpressionPath)keyName, (Entity)sample.getId().toEntity())});
            this.putConditional(type, sample, true, Optional.of(conditionExpression));
        }

        private <C extends BaseValue<C>> void putConditional(ValueType<C> type, HasId sample, boolean shouldSucceed, Optional<ConditionExpression> conditionExpression) {
            if (!AbstractTestStore.this.supportsConditionExpression()) {
                return;
            }
            try {
                AbstractTestStore.this.store.put(new EntitySaveOp<C>(type, (PersistentBase)sample).saveOp, conditionExpression);
                if (!shouldSucceed) {
                    Assertions.fail();
                }
                AbstractTestStore.this.testLoadSingle(type, sample);
            }
            catch (ConditionFailedException cfe) {
                if (shouldSucceed) {
                    Assertions.fail((Throwable)cfe);
                }
                Assertions.assertThrows(NotFoundException.class, () -> EntityType.forType((ValueType)type).loadSingle(AbstractTestStore.this.store, sample.getId()));
            }
        }
    }

    @Nested
    @DisplayName(value="save() tests")
    class SaveTests {
        SaveTests() {
        }

        @Test
        void save() {
            List<EntitySaveOp> entities = Arrays.asList(new EntitySaveOp(ValueType.L1, SampleEntities.createL1(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.L2, SampleEntities.createL2(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.L3, SampleEntities.createL3(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.KEY_FRAGMENT, SampleEntities.createFragment(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.REF, SampleEntities.createTag(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.COMMIT_METADATA, SampleEntities.createCommitMetadata(AbstractTestStore.this.random)), new EntitySaveOp(ValueType.VALUE, SampleEntities.createValue(AbstractTestStore.this.random)));
            AbstractTestStore.this.store.save(entities.stream().map(e -> e.saveOp).collect(Collectors.toList()));
            Assertions.assertAll(entities.stream().map(s -> () -> {
                try {
                    PersistentBase saveOpValue = s.entity;
                    PersistentBase loadedValue = EntityType.forType(s.type).loadSingle(AbstractTestStore.this.store, saveOpValue.getId());
                    Assertions.assertEquals(saveOpValue, (Object)loadedValue, (String)("type " + s.type));
                    try {
                        loadedValue = EntityType.forType(s.type).buildEntity(producer -> {
                            ValueType t = s.type;
                            BaseValue p = producer;
                            AbstractTestStore.this.store.loadSingle(t, saveOpValue.getId(), p);
                        });
                        Assertions.assertEquals(saveOpValue, (Object)loadedValue, (String)("type " + s.type));
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
                catch (NotFoundException e) {
                    Assertions.fail((String)("type " + s.type), (Throwable)e);
                }
            }));
        }
    }

    @Nested
    @DisplayName(value="putIfAbsent() tests")
    class PutIfAbsentTests {
        PutIfAbsentTests() {
        }

        @Test
        void putIfAbsentL1() {
            this.testPutIfAbsent(ValueType.L1, SampleEntities.createL1(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentL2() {
            this.testPutIfAbsent(ValueType.L2, SampleEntities.createL2(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentL3() {
            this.testPutIfAbsent(ValueType.L3, SampleEntities.createL3(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentFragment() {
            this.testPutIfAbsent(ValueType.KEY_FRAGMENT, SampleEntities.createFragment(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentBranch() {
            this.testPutIfAbsent(ValueType.REF, SampleEntities.createBranch(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentTag() {
            this.testPutIfAbsent(ValueType.REF, SampleEntities.createTag(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentCommitMetadata() {
            this.testPutIfAbsent(ValueType.COMMIT_METADATA, SampleEntities.createCommitMetadata(AbstractTestStore.this.random));
        }

        @Test
        void putIfAbsentValue() {
            this.testPutIfAbsent(ValueType.VALUE, SampleEntities.createValue(AbstractTestStore.this.random));
        }

        protected <C extends BaseValue<C>, T extends PersistentBase<C>> void testPutIfAbsent(ValueType<C> type, T sample) {
            Assertions.assertTrue((boolean)AbstractTestStore.this.store.putIfAbsent(new EntitySaveOp<C>(type, sample).saveOp));
            AbstractTestStore.this.testLoadSingle(type, sample);
            Assertions.assertFalse((boolean)AbstractTestStore.this.store.putIfAbsent(new EntitySaveOp<C>(type, sample).saveOp));
            AbstractTestStore.this.testLoadSingle(type, sample);
        }
    }

    @Nested
    @DisplayName(value="loadSingle() tests")
    class LoadSingleTests {
        LoadSingleTests() {
        }

        @Test
        void loadSingleInvalid() {
            Assertions.assertThrows(NotFoundException.class, () -> EntityType.REF.loadSingle(AbstractTestStore.this.store, SampleEntities.createId(AbstractTestStore.this.random)));
        }

        @Test
        void loadSingleL1() {
            AbstractTestStore.this.putThenLoad(ValueType.L1, (HasId)SampleEntities.createL1(AbstractTestStore.this.random));
        }

        @Test
        void loadSingleL2() {
            AbstractTestStore.this.putThenLoad(ValueType.L2, (HasId)SampleEntities.createL2(AbstractTestStore.this.random));
        }

        @Test
        void loadSingleL3() {
            AbstractTestStore.this.putThenLoad(ValueType.L3, (HasId)SampleEntities.createL3(AbstractTestStore.this.random));
        }

        @Test
        void loadFragment() {
            AbstractTestStore.this.putThenLoad(ValueType.KEY_FRAGMENT, (HasId)SampleEntities.createFragment(AbstractTestStore.this.random));
        }

        @Test
        void loadBranch() {
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)SampleEntities.createBranch(AbstractTestStore.this.random));
        }

        @Test
        void loadTag() {
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)SampleEntities.createTag(AbstractTestStore.this.random));
        }

        @Test
        void loadCommitMetadata() {
            AbstractTestStore.this.putThenLoad(ValueType.COMMIT_METADATA, (HasId)SampleEntities.createCommitMetadata(AbstractTestStore.this.random));
        }

        @Test
        void loadValue() {
            AbstractTestStore.this.putThenLoad(ValueType.VALUE, (HasId)SampleEntities.createValue(AbstractTestStore.this.random));
        }
    }

    @Nested
    @DisplayName(value="load() tests")
    class LoadTests {
        LoadTests() {
        }

        @Test
        void load() {
            ImmutableList creators = ImmutableList.builder().add((Object)new CreatorPair(ValueType.REF, () -> SampleEntities.createTag(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.REF, () -> SampleEntities.createBranch(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.COMMIT_METADATA, () -> SampleEntities.createCommitMetadata(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.VALUE, () -> SampleEntities.createValue(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.L1, () -> SampleEntities.createL1(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.L2, () -> SampleEntities.createL2(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.L3, () -> SampleEntities.createL3(AbstractTestStore.this.random))).add((Object)new CreatorPair(ValueType.KEY_FRAGMENT, () -> SampleEntities.createFragment(AbstractTestStore.this.random))).build();
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (int i = 0; i < 100; ++i) {
                int index = i % creators.size();
                HasId obj = (HasId)((CreatorPair)creators.get((int)index)).supplier.get();
                builder.put(((CreatorPair)creators.get((int)index)).type, (Object)obj);
            }
            ImmutableMultimap objs = builder.build();
            objs.forEach((x$0, x$1) -> AbstractTestStore.this.putThenLoad(x$0, x$1));
            AbstractTestStore.this.store.load(this.createTestLoadStep((Multimap<ValueType<?>, HasId>)objs));
        }

        @Test
        void loadSteps() {
            ImmutableMultimap objs = ImmutableMultimap.builder().put((Object)ValueType.REF, (Object)SampleEntities.createBranch(AbstractTestStore.this.random)).put((Object)ValueType.REF, (Object)SampleEntities.createBranch(AbstractTestStore.this.random)).put((Object)ValueType.COMMIT_METADATA, (Object)SampleEntities.createCommitMetadata(AbstractTestStore.this.random)).build();
            ImmutableMultimap objs2 = ImmutableMultimap.builder().put((Object)ValueType.L3, (Object)SampleEntities.createL3(AbstractTestStore.this.random)).put((Object)ValueType.VALUE, (Object)SampleEntities.createValue(AbstractTestStore.this.random)).put((Object)ValueType.VALUE, (Object)SampleEntities.createValue(AbstractTestStore.this.random)).put((Object)ValueType.VALUE, (Object)SampleEntities.createValue(AbstractTestStore.this.random)).put((Object)ValueType.REF, (Object)SampleEntities.createTag(AbstractTestStore.this.random)).build();
            objs.forEach((x$0, x$1) -> AbstractTestStore.this.putThenLoad(x$0, x$1));
            objs2.forEach((x$0, x$1) -> AbstractTestStore.this.putThenLoad(x$0, x$1));
            LoadStep step2 = this.createTestLoadStep((Multimap<ValueType<?>, HasId>)objs2);
            LoadStep step1 = this.createTestLoadStep((Multimap<ValueType<?>, HasId>)objs, Optional.of(step2));
            AbstractTestStore.this.store.load(step1);
        }

        @Test
        void loadNone() {
            AbstractTestStore.this.store.load(this.createTestLoadStep((Multimap<ValueType<?>, HasId>)ImmutableMultimap.of()));
        }

        @Test
        void loadInvalid() {
            AbstractTestStore.this.putThenLoad(ValueType.REF, (HasId)SampleEntities.createBranch(AbstractTestStore.this.random));
            ImmutableMultimap objs = ImmutableMultimap.of((Object)ValueType.REF, (Object)SampleEntities.createBranch(AbstractTestStore.this.random));
            Assertions.assertThrows(NotFoundException.class, () -> this.lambda$loadInvalid$11((Multimap)objs));
        }

        @Test
        void loadPagination() {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            for (int i = 0; i < 10 + AbstractTestStore.this.loadSize(); ++i) {
                builder.put((Object)ValueType.REF, (Object)SampleEntities.createTag(AbstractTestStore.this.random));
            }
            ImmutableMultimap objs = builder.build();
            objs.forEach((x$0, x$1) -> AbstractTestStore.this.putThenLoad(x$0, x$1));
            AbstractTestStore.this.store.load(this.createTestLoadStep((Multimap<ValueType<?>, HasId>)objs));
        }

        private LoadStep createTestLoadStep(Multimap<ValueType<?>, HasId> objs) {
            return this.createTestLoadStep(objs, Optional.empty());
        }

        private LoadStep createTestLoadStep(Multimap<ValueType<?>, HasId> objs, Optional<LoadStep> next) {
            EntityLoadOps loadOps = new EntityLoadOps();
            objs.forEach((type, val) -> loadOps.load(EntityType.forType((ValueType)type), val.getId(), r -> AbstractTestStore.assertEquals(val, (HasId)r)));
            return loadOps.build(() -> next);
        }

        private /* synthetic */ void lambda$loadInvalid$11(Multimap objs) throws Throwable {
            AbstractTestStore.this.store.load(this.createTestLoadStep(objs));
        }
    }

    static class EntitySaveOp<C extends BaseValue<C>> {
        final ValueType<C> type;
        final PersistentBase<C> entity;
        final SaveOp<C> saveOp;

        EntitySaveOp(ValueType<C> type, PersistentBase<C> entity) {
            this.type = type;
            this.entity = entity;
            this.saveOp = EntityType.forType(type).createSaveOpForEntity(entity);
        }
    }

    static class CreatorPair {
        final ValueType<?> type;
        final Supplier<PersistentBase<?>> supplier;

        CreatorPair(ValueType<?> type, Supplier<PersistentBase<?>> supplier) {
            this.type = type;
            this.supplier = supplier;
        }
    }
}

