/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.mockito.Mockito;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Diff;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Operation;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.Serializer;
import org.projectnessie.versioned.SerializerWithPayload;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.StringSerializer;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.WithHash;
import org.projectnessie.versioned.WithType;
import org.projectnessie.versioned.impl.ImmutableTieredVersionStoreConfig;
import org.projectnessie.versioned.impl.TieredVersionStore;
import org.projectnessie.versioned.impl.TieredVersionStoreConfig;
import org.projectnessie.versioned.store.Store;

public abstract class AbstractTieredStoreFixture<S extends Store, C>
implements VersionStore<String, String, StringSerializer.TestEnum>,
AutoCloseable {
    protected static final StoreWorker<String, String, StringSerializer.TestEnum> WORKER = StoreWorker.of((SerializerWithPayload)StringSerializer.getInstance(), (Serializer)StringSerializer.getInstance());
    private final C config;
    private final S store;
    private final VersionStore<String, String, StringSerializer.TestEnum> versionStore;

    protected AbstractTieredStoreFixture(C config) {
        this.config = config;
        S storeImpl = this.createStoreImpl();
        storeImpl.start();
        this.store = (Store)Mockito.spy(storeImpl);
        TieredVersionStore versionStoreImpl = new TieredVersionStore(WORKER, this.store, (TieredVersionStoreConfig)ImmutableTieredVersionStoreConfig.builder().enableTracing(true).waitOnCollapse(true).build());
        this.versionStore = (VersionStore)Mockito.spy((Object)versionStoreImpl);
    }

    public C getConfig() {
        return this.config;
    }

    public abstract S createStoreImpl();

    public S getStore() {
        return this.store;
    }

    @Nonnull
    public Hash toHash(@Nonnull NamedRef ref) throws ReferenceNotFoundException {
        return this.versionStore.toHash(ref);
    }

    public Hash commit(@Nonnull BranchName branch, @Nonnull Optional<Hash> expectedHash, @Nonnull String metadata, @Nonnull List<Operation<String>> operations) throws ReferenceNotFoundException, ReferenceConflictException {
        return this.versionStore.commit(branch, expectedHash, (Object)metadata, operations);
    }

    public void transplant(BranchName targetBranch, Optional<Hash> expectedHash, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        this.versionStore.transplant(targetBranch, expectedHash, sequenceToTransplant);
    }

    public void merge(Hash fromHash, BranchName toBranch, Optional<Hash> expectedHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.versionStore.merge(fromHash, toBranch, expectedHash);
    }

    public void assign(NamedRef ref, Optional<Hash> expectedHash, Hash targetHash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.versionStore.assign(ref, expectedHash, targetHash);
    }

    public Hash create(NamedRef ref, Optional<Hash> targetHash) throws ReferenceNotFoundException, ReferenceAlreadyExistsException {
        return this.versionStore.create(ref, targetHash);
    }

    public void delete(NamedRef ref, Optional<Hash> hash) throws ReferenceNotFoundException, ReferenceConflictException {
        this.versionStore.delete(ref, hash);
    }

    public Stream<WithHash<NamedRef>> getNamedRefs() {
        return this.versionStore.getNamedRefs();
    }

    public Stream<WithHash<String>> getCommits(Ref ref) throws ReferenceNotFoundException {
        return this.versionStore.getCommits(ref);
    }

    public Stream<WithType<Key, StringSerializer.TestEnum>> getKeys(Ref ref) throws ReferenceNotFoundException {
        return this.versionStore.getKeys(ref);
    }

    public String getValue(Ref ref, Key key) throws ReferenceNotFoundException {
        return (String)this.versionStore.getValue(ref, key);
    }

    public List<Optional<String>> getValues(Ref ref, List<Key> key) throws ReferenceNotFoundException {
        return this.versionStore.getValues(ref, key);
    }

    public WithHash<Ref> toRef(@Nonnull String refOfUnknownType) throws ReferenceNotFoundException {
        return this.versionStore.toRef(refOfUnknownType);
    }

    public Stream<Diff<String>> getDiffs(Ref from, Ref to) throws ReferenceNotFoundException {
        return this.versionStore.getDiffs(from, to);
    }

    public VersionStore.Collector collectGarbage() {
        return this.versionStore.collectGarbage();
    }
}

