/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.impl;

import com.google.protobuf.ByteString;
import java.util.Random;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.WithPayload;
import org.projectnessie.versioned.impl.EntityType;
import org.projectnessie.versioned.impl.InternalCommitMetadata;
import org.projectnessie.versioned.impl.InternalFragment;
import org.projectnessie.versioned.impl.InternalL1;
import org.projectnessie.versioned.impl.InternalL2;
import org.projectnessie.versioned.impl.InternalL3;
import org.projectnessie.versioned.impl.InternalRef;
import org.projectnessie.versioned.impl.InternalValue;
import org.projectnessie.versioned.store.Entity;
import org.projectnessie.versioned.store.Id;
import org.projectnessie.versioned.store.KeyDelta;
import org.projectnessie.versioned.tiered.CommitMetadata;
import org.projectnessie.versioned.tiered.L2;
import org.projectnessie.versioned.tiered.Mutation;
import org.projectnessie.versioned.tiered.Ref;
import org.projectnessie.versioned.tiered.Value;

public class SampleEntities {
    private static final Byte DEFAULT_PAYLOAD = 0;

    public static InternalL1 createL1(Random random) {
        return (InternalL1)EntityType.L1.buildEntity(producer -> producer.commitMetadataId(SampleEntities.createId(random)).children(IntStream.range(0, 43).mapToObj(x -> SampleEntities.createId(random))).ancestors(Stream.of(InternalL1.EMPTY.getId(), Id.EMPTY)).keyMutations(Stream.of(Mutation.Addition.of((Key)Key.of((String[])new String[]{SampleEntities.createString(random, 8), SampleEntities.createString(random, 9)}), (Byte)DEFAULT_PAYLOAD))).incrementalKeyList(InternalL1.EMPTY.getId(), 1));
    }

    public static InternalL2 createL2(Random random) {
        return (InternalL2)EntityType.L2.buildEntity(producer -> ((L2)producer.id(SampleEntities.createId(random))).children(IntStream.range(0, 199).mapToObj(x -> SampleEntities.createId(random))));
    }

    public static InternalL3 createL3(Random random) {
        return (InternalL3)EntityType.L3.buildEntity(producer -> producer.keyDelta(IntStream.range(0, 100).mapToObj(i -> KeyDelta.of((Key)Key.of((String[])new String[]{SampleEntities.createString(random, 5), SampleEntities.createString(random, 9), String.valueOf(i)}), (Id)SampleEntities.createId(random), (Byte)DEFAULT_PAYLOAD))));
    }

    public static InternalFragment createFragment(Random random) {
        return (InternalFragment)EntityType.KEY_FRAGMENT.buildEntity(producer -> producer.keys(IntStream.range(0, 10).mapToObj(i -> WithPayload.of((Byte)DEFAULT_PAYLOAD, (Object)Key.of((String[])new String[]{SampleEntities.createString(random, 5), SampleEntities.createString(random, 9), String.valueOf(i)})))));
    }

    public static InternalRef createBranch(Random random) {
        String name = SampleEntities.createString(random, 10);
        return (InternalRef)EntityType.REF.buildEntity(producer -> ((Ref)producer.id(Id.build((String)name))).name(name).branch().children(IntStream.range(0, 43).mapToObj(x -> SampleEntities.createId(random))).metadata(SampleEntities.createId(random)).commits(bc -> {
            bc.id(SampleEntities.createId(random)).commit(SampleEntities.createId(random)).saved().parent(SampleEntities.createId(random)).done();
            bc.id(SampleEntities.createId(random)).commit(SampleEntities.createId(random)).unsaved().delta(1, SampleEntities.createId(random), SampleEntities.createId(random)).mutations().keyMutation((Mutation)Mutation.Addition.of((Key)Key.of((String[])new String[]{SampleEntities.createString(random, 8), SampleEntities.createString(random, 8)}), (Byte)DEFAULT_PAYLOAD)).done();
        }));
    }

    public static InternalRef createTag(Random random) {
        return (InternalRef)EntityType.REF.buildEntity(producer -> ((Ref)producer.id(SampleEntities.createId(random))).name("tagName").tag().commit(SampleEntities.createId(random)));
    }

    public static InternalCommitMetadata createCommitMetadata(Random random) {
        return (InternalCommitMetadata)EntityType.COMMIT_METADATA.buildEntity(producer -> ((CommitMetadata)producer.id(SampleEntities.createId(random))).value(ByteString.copyFrom((byte[])SampleEntities.createBinary(random, 6))));
    }

    public static InternalValue createValue(Random random) {
        return (InternalValue)EntityType.VALUE.buildEntity(producer -> ((Value)producer.id(SampleEntities.createId(random))).value(ByteString.copyFrom((byte[])SampleEntities.createBinary(random, 6))));
    }

    public static byte[] createBinary(Random random, int numBytes) {
        byte[] buffer = new byte[numBytes];
        random.nextBytes(buffer);
        return buffer;
    }

    public static Id createId(Random random) {
        return Id.of((byte[])SampleEntities.createBinary(random, 20));
    }

    public static Entity createStringEntity(Random random, int numChars) {
        return Entity.ofString((String)SampleEntities.createString(random, numChars));
    }

    private static String createString(Random random, int numChars) {
        return random.ints(97, 123).limit(numChars).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

