/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.ByteString;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.ReferencesUtil;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

public abstract class AbstractNessieExporter {
    public static final String NAMED_REFS_PREFIX = "named-refs";
    public static final String COMMITS_PREFIX = "commits";

    abstract DatabaseAdapter databaseAdapter();

    @Value.Default
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    StoreWorker storeWorker() {
        return DefaultStoreWorker.instance();
    }

    @Value.Default
    int outputBufferSize() {
        return 32768;
    }

    @Value.Default
    long maxFileSize() {
        return Long.MAX_VALUE;
    }

    @Value.Default
    int expectedCommitCount() {
        return 1000000;
    }

    protected abstract void preValidate() throws IOException;

    protected abstract OutputStream newFileOutput(String var1) throws IOException;

    @Value.Default
    ProgressListener progressListener() {
        return (x, y) -> {};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferTypes.ExportMeta exportNessieRepository() throws IOException {
        this.preValidate();
        ExportContext exportContext = new ExportContext(TransferTypes.ExportMeta.newBuilder().setCreatedMillisEpoch(this.databaseAdapter().getConfig().getClock().millis()).setVersion(TransferTypes.ExportVersion.V1));
        try {
            this.progressListener().progress(ProgressEvent.STARTED);
            this.progressListener().progress(ProgressEvent.START_NAMED_REFERENCES);
            try (Stream<TransferTypes.NamedReference> namedRefs = this.exportNamedReferences();){
                namedRefs.forEach(namedReference -> {
                    exportContext.writeNamedReference((TransferTypes.NamedReference)namedReference);
                    this.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
                });
            }
            exportContext.namedReferenceOutput.finishCurrentFile();
            this.progressListener().progress(ProgressEvent.END_NAMED_REFERENCES);
            this.progressListener().progress(ProgressEvent.START_COMMITS);
            Consumer<CommitLogEntry> commitHandler = c -> {
                TransferTypes.Commit commit = this.mapCommitLogEntry((CommitLogEntry)c);
                exportContext.writeCommit(commit);
                this.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
            };
            HeadsAndForkPoints headsAndForks = ReferencesUtil.forDatabaseAdapter((DatabaseAdapter)this.databaseAdapter()).identifyAllHeadsAndForkPoints(this.expectedCommitCount(), commitHandler);
            exportContext.commitOutput.finishCurrentFile();
            this.progressListener().progress(ProgressEvent.END_COMMITS);
            TransferTypes.HeadsAndForks.Builder hf = TransferTypes.HeadsAndForks.newBuilder().setScanStartedAtInMicros(headsAndForks.getScanStartedAtInMicros());
            headsAndForks.getHeads().forEach(h -> hf.addHeads(h.asBytes()));
            headsAndForks.getForkPoints().forEach(h -> hf.addForkPoints(h.asBytes()));
            try (OutputStream output = this.newFileOutput("heads-and-forks");){
                hf.build().writeTo(output);
            }
            this.progressListener().progress(ProgressEvent.START_META);
            TransferTypes.ExportMeta meta = exportContext.finish();
            try (OutputStream output = this.newFileOutput("export-metadata");){
                meta.writeTo(output);
            }
            this.progressListener().progress(ProgressEvent.END_META, meta);
            this.progressListener().progress(ProgressEvent.FINISHED);
            TransferTypes.ExportMeta exportMeta = meta;
            return exportMeta;
        }
        finally {
            exportContext.closeSilently();
        }
    }

    @MustBeClosed
    Stream<TransferTypes.NamedReference> exportNamedReferences() {
        try {
            return this.databaseAdapter().namedRefs(GetNamedRefsParams.DEFAULT).map(refInfo -> TransferTypes.NamedReference.newBuilder().setRefType(this.refType(refInfo.getNamedRef())).setName(refInfo.getNamedRef().getName()).setCommitId(refInfo.getHash().asBytes()).build());
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private TransferTypes.RefType refType(NamedRef namedRef) {
        if (namedRef instanceof TagName) {
            return TransferTypes.RefType.Tag;
        }
        if (namedRef instanceof BranchName) {
            return TransferTypes.RefType.Branch;
        }
        throw new IllegalArgumentException("Unknown named reference type " + namedRef);
    }

    TransferTypes.Commit mapCommitLogEntry(CommitLogEntry entry) {
        TransferTypes.Commit.Builder commitBuilder = TransferTypes.Commit.newBuilder().setCommitId(entry.getHash().asBytes()).setMetadata(entry.getMetadata()).setCommitSequence(entry.getCommitSeq()).setCreatedTimeMicros(entry.getCreatedTime()).setParentCommitId(((Hash)entry.getParents().get(0)).asBytes());
        entry.getAdditionalParents().forEach(p -> commitBuilder.addAdditionalParents(p.asBytes()));
        entry.getDeletes().forEach(d -> commitBuilder.addOperations(this.deleteOperationFromCommit((Key)d)));
        entry.getPuts().forEach(p -> commitBuilder.addOperations(this.putOperationFromCommit((KeyWithBytes)p)));
        return commitBuilder.build();
    }

    protected TransferTypes.Operation.Builder deleteOperationFromCommit(Key delete) {
        return TransferTypes.Operation.newBuilder().setOperationType(TransferTypes.OperationType.Delete).addAllContentKey((Iterable)delete.getElements());
    }

    protected TransferTypes.Operation.Builder putOperationFromCommit(KeyWithBytes put) {
        return TransferTypes.Operation.newBuilder().setOperationType(TransferTypes.OperationType.Put).addAllContentKey((Iterable)put.getKey().getElements()).setContentId(put.getContentId().getId()).setPayload((int)put.getPayload()).setValue(this.contentToValue(this.convertToContent(put)));
    }

    protected Content convertToContent(KeyWithBytes p) {
        return this.storeWorker().valueFromStore(p.getPayload(), p.getValue(), () -> this.databaseAdapter().globalContent(p.getContentId()).map(ContentIdAndBytes::getValue).orElse(null), arg_0 -> ((DatabaseAdapter)this.databaseAdapter()).mapToAttachment(arg_0));
    }

    protected ByteString contentToValue(Content content) {
        try {
            return ByteString.copyFromUtf8((String)this.objectMapper().writeValueAsString((Object)content));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private final class SizeLimitedOutput {
        private final String fileNamePrefix;
        private final Consumer<String> newFileName;
        private final LongConsumer finalEntityCount;
        private int fileNum;
        long entityCount;
        private long currentFileSize;
        private OutputStream output;

        SizeLimitedOutput(String fileNamePrefix, Consumer<String> newFileName, LongConsumer finalEntityCount) {
            this.fileNamePrefix = fileNamePrefix;
            this.newFileName = newFileName;
            this.finalEntityCount = finalEntityCount;
        }

        void writeEntity(AbstractMessage message) {
            try {
                int size = message.getSerializedSize();
                this.currentFileSize += (long)size;
                if (AbstractNessieExporter.this.maxFileSize() != Long.MAX_VALUE && this.currentFileSize > AbstractNessieExporter.this.maxFileSize()) {
                    this.currentFileSize = 0L;
                    this.finishCurrentFile();
                }
                if (this.output == null) {
                    ++this.fileNum;
                    String fileName = String.format("%s-%08d", this.fileNamePrefix, this.fileNum);
                    this.output = new BufferedOutputStream(AbstractNessieExporter.this.newFileOutput(fileName), AbstractNessieExporter.this.outputBufferSize());
                    this.newFileName.accept(fileName);
                }
                message.writeDelimitedTo(this.output);
                ++this.entityCount;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void finish() throws IOException {
            this.finishCurrentFile();
            this.finalEntityCount.accept(this.entityCount);
        }

        private void finishCurrentFile() throws IOException {
            if (this.output != null) {
                try {
                    this.output.flush();
                    this.output.close();
                }
                finally {
                    this.output = null;
                }
            }
        }

        public void closeSilently() {
            try {
                this.finishCurrentFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private final class ExportContext {
        private final TransferTypes.ExportMeta.Builder exportMeta;
        private final SizeLimitedOutput namedReferenceOutput;
        private final SizeLimitedOutput commitOutput;

        ExportContext(TransferTypes.ExportMeta.Builder exportMeta) {
            this.exportMeta = exportMeta;
            this.namedReferenceOutput = new SizeLimitedOutput(AbstractNessieExporter.NAMED_REFS_PREFIX, arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addNamedReferencesFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setNamedReferencesCount(arg_0));
            this.commitOutput = new SizeLimitedOutput(AbstractNessieExporter.COMMITS_PREFIX, arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addCommitsFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setCommitCount(arg_0));
        }

        void writeNamedReference(TransferTypes.NamedReference namedReference) {
            this.namedReferenceOutput.writeEntity((AbstractMessage)namedReference);
        }

        void writeCommit(TransferTypes.Commit commit) {
            this.commitOutput.writeEntity((AbstractMessage)commit);
        }

        TransferTypes.ExportMeta finish() throws IOException {
            this.namedReferenceOutput.finish();
            this.commitOutput.finish();
            return this.exportMeta.build();
        }

        void closeSilently() {
            this.namedReferenceOutput.closeSilently();
            this.commitOutput.closeSilently();
        }
    }

    public static interface Builder<B extends Builder<B, T>, T extends AbstractNessieExporter> {
        public B databaseAdapter(DatabaseAdapter var1);

        public B objectMapper(ObjectMapper var1);

        public B storeWorker(StoreWorker var1);

        public B outputBufferSize(int var1);

        public B maxFileSize(long var1);

        public B expectedCommitCount(int var1);

        public B progressListener(ProgressListener var1);

        public T build();
    }
}

