/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.transfer.AbstractNessieImporter;
import org.projectnessie.versioned.transfer.FileImporter;
import org.projectnessie.versioned.transfer.ProgressListener;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileImporter", generator="Immutables")
@Immutable
public final class ImmutableFileImporter
extends FileImporter {
    private final DatabaseAdapter databaseAdapter;
    private final int inputBufferSize;
    private final int commitBatchSize;
    private final int attachmentBatchSize;
    private final StoreWorker storeWorker;
    private final ObjectMapper objectMapper;
    private final ProgressListener progressListener;
    private final Path sourceDirectory;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFileImporter(Builder builder) {
        this.databaseAdapter = builder.databaseAdapter;
        this.sourceDirectory = builder.sourceDirectory;
        if (builder.inputBufferSizeIsSet()) {
            this.initShim.inputBufferSize(builder.inputBufferSize);
        }
        if (builder.commitBatchSizeIsSet()) {
            this.initShim.commitBatchSize(builder.commitBatchSize);
        }
        if (builder.attachmentBatchSizeIsSet()) {
            this.initShim.attachmentBatchSize(builder.attachmentBatchSize);
        }
        if (builder.storeWorker != null) {
            this.initShim.storeWorker(builder.storeWorker);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener(builder.progressListener);
        }
        this.inputBufferSize = this.initShim.inputBufferSize();
        this.commitBatchSize = this.initShim.commitBatchSize();
        this.attachmentBatchSize = this.initShim.attachmentBatchSize();
        this.storeWorker = this.initShim.storeWorker();
        this.objectMapper = this.initShim.objectMapper();
        this.progressListener = this.initShim.progressListener();
        this.initShim = null;
    }

    private ImmutableFileImporter(DatabaseAdapter databaseAdapter, int inputBufferSize, int commitBatchSize, int attachmentBatchSize, StoreWorker storeWorker, ObjectMapper objectMapper, ProgressListener progressListener, Path sourceDirectory) {
        this.databaseAdapter = databaseAdapter;
        this.inputBufferSize = inputBufferSize;
        this.commitBatchSize = commitBatchSize;
        this.attachmentBatchSize = attachmentBatchSize;
        this.storeWorker = storeWorker;
        this.objectMapper = objectMapper;
        this.progressListener = progressListener;
        this.sourceDirectory = sourceDirectory;
        this.initShim = null;
    }

    @Override
    DatabaseAdapter databaseAdapter() {
        return this.databaseAdapter;
    }

    @Override
    int inputBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inputBufferSize() : this.inputBufferSize;
    }

    @Override
    int commitBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commitBatchSize() : this.commitBatchSize;
    }

    @Override
    int attachmentBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.attachmentBatchSize() : this.attachmentBatchSize;
    }

    @Override
    StoreWorker storeWorker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storeWorker() : this.storeWorker;
    }

    @Override
    ObjectMapper objectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.objectMapper() : this.objectMapper;
    }

    @Override
    ProgressListener progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    @Override
    Path sourceDirectory() {
        return this.sourceDirectory;
    }

    public final ImmutableFileImporter withDatabaseAdapter(DatabaseAdapter value) {
        if (this.databaseAdapter == value) {
            return this;
        }
        DatabaseAdapter newValue = Objects.requireNonNull(value, "databaseAdapter");
        return new ImmutableFileImporter(newValue, this.inputBufferSize, this.commitBatchSize, this.attachmentBatchSize, this.storeWorker, this.objectMapper, this.progressListener, this.sourceDirectory);
    }

    public final ImmutableFileImporter withInputBufferSize(int value) {
        if (this.inputBufferSize == value) {
            return this;
        }
        return new ImmutableFileImporter(this.databaseAdapter, value, this.commitBatchSize, this.attachmentBatchSize, this.storeWorker, this.objectMapper, this.progressListener, this.sourceDirectory);
    }

    public final ImmutableFileImporter withCommitBatchSize(int value) {
        if (this.commitBatchSize == value) {
            return this;
        }
        return new ImmutableFileImporter(this.databaseAdapter, this.inputBufferSize, value, this.attachmentBatchSize, this.storeWorker, this.objectMapper, this.progressListener, this.sourceDirectory);
    }

    public final ImmutableFileImporter withAttachmentBatchSize(int value) {
        if (this.attachmentBatchSize == value) {
            return this;
        }
        return new ImmutableFileImporter(this.databaseAdapter, this.inputBufferSize, this.commitBatchSize, value, this.storeWorker, this.objectMapper, this.progressListener, this.sourceDirectory);
    }

    public final ImmutableFileImporter withStoreWorker(StoreWorker value) {
        if (this.storeWorker == value) {
            return this;
        }
        StoreWorker newValue = Objects.requireNonNull(value, "storeWorker");
        return new ImmutableFileImporter(this.databaseAdapter, this.inputBufferSize, this.commitBatchSize, this.attachmentBatchSize, newValue, this.objectMapper, this.progressListener, this.sourceDirectory);
    }

    public final ImmutableFileImporter withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableFileImporter(this.databaseAdapter, this.inputBufferSize, this.commitBatchSize, this.attachmentBatchSize, this.storeWorker, newValue, this.progressListener, this.sourceDirectory);
    }

    public final ImmutableFileImporter withProgressListener(ProgressListener value) {
        if (this.progressListener == value) {
            return this;
        }
        ProgressListener newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableFileImporter(this.databaseAdapter, this.inputBufferSize, this.commitBatchSize, this.attachmentBatchSize, this.storeWorker, this.objectMapper, newValue, this.sourceDirectory);
    }

    public final ImmutableFileImporter withSourceDirectory(Path value) {
        if (this.sourceDirectory == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "sourceDirectory");
        return new ImmutableFileImporter(this.databaseAdapter, this.inputBufferSize, this.commitBatchSize, this.attachmentBatchSize, this.storeWorker, this.objectMapper, this.progressListener, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileImporter && this.equalTo(0, (ImmutableFileImporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileImporter another) {
        return this.databaseAdapter.equals(another.databaseAdapter) && this.inputBufferSize == another.inputBufferSize && this.commitBatchSize == another.commitBatchSize && this.attachmentBatchSize == another.attachmentBatchSize && this.storeWorker.equals(another.storeWorker) && this.objectMapper.equals(another.objectMapper) && this.progressListener.equals(another.progressListener) && this.sourceDirectory.equals(another.sourceDirectory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseAdapter.hashCode();
        h += (h << 5) + this.inputBufferSize;
        h += (h << 5) + this.commitBatchSize;
        h += (h << 5) + this.attachmentBatchSize;
        h += (h << 5) + this.storeWorker.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        h += (h << 5) + this.sourceDirectory.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileImporter").omitNullValues().add("databaseAdapter", (Object)this.databaseAdapter).add("inputBufferSize", this.inputBufferSize).add("commitBatchSize", this.commitBatchSize).add("attachmentBatchSize", this.attachmentBatchSize).add("storeWorker", (Object)this.storeWorker).add("objectMapper", (Object)this.objectMapper).add("progressListener", (Object)this.progressListener).add("sourceDirectory", (Object)this.sourceDirectory).toString();
    }

    public static ImmutableFileImporter copyOf(FileImporter instance) {
        if (instance instanceof ImmutableFileImporter) {
            return (ImmutableFileImporter)instance;
        }
        return ImmutableFileImporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileImporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FileImporter.Builder {
        private static final long INIT_BIT_DATABASE_ADAPTER = 1L;
        private static final long INIT_BIT_SOURCE_DIRECTORY = 2L;
        private static final long OPT_BIT_INPUT_BUFFER_SIZE = 1L;
        private static final long OPT_BIT_COMMIT_BATCH_SIZE = 2L;
        private static final long OPT_BIT_ATTACHMENT_BATCH_SIZE = 4L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private DatabaseAdapter databaseAdapter;
        private int inputBufferSize;
        private int commitBatchSize;
        private int attachmentBatchSize;
        @Nullable
        private StoreWorker storeWorker;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private ProgressListener progressListener;
        @Nullable
        private Path sourceDirectory;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileImporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractNessieImporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractNessieImporter instance;
            if (object instanceof FileImporter) {
                instance = (FileImporter)object;
                this.sourceDirectory(((FileImporter)instance).sourceDirectory());
            }
            if (object instanceof AbstractNessieImporter) {
                instance = (AbstractNessieImporter)object;
                this.progressListener(instance.progressListener());
                this.databaseAdapter(instance.databaseAdapter());
                this.objectMapper(instance.objectMapper());
                this.commitBatchSize(instance.commitBatchSize());
                this.attachmentBatchSize(instance.attachmentBatchSize());
                this.inputBufferSize(instance.inputBufferSize());
                this.storeWorker(instance.storeWorker());
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder databaseAdapter(DatabaseAdapter databaseAdapter) {
            this.databaseAdapter = Objects.requireNonNull(databaseAdapter, "databaseAdapter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder inputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commitBatchSize(int commitBatchSize) {
            this.commitBatchSize = commitBatchSize;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder attachmentBatchSize(int attachmentBatchSize) {
            this.attachmentBatchSize = attachmentBatchSize;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder storeWorker(StoreWorker storeWorker) {
            this.storeWorker = Objects.requireNonNull(storeWorker, "storeWorker");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder progressListener(ProgressListener progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sourceDirectory(Path sourceDirectory) {
            this.sourceDirectory = Objects.requireNonNull(sourceDirectory, "sourceDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableFileImporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileImporter(this);
        }

        private boolean inputBufferSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean commitBatchSizeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean attachmentBatchSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseAdapter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceDirectory");
            }
            return "Cannot build FileImporter, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FileImporter", generator="Immutables")
    private final class InitShim {
        private byte inputBufferSizeBuildStage = 0;
        private int inputBufferSize;
        private byte commitBatchSizeBuildStage = 0;
        private int commitBatchSize;
        private byte attachmentBatchSizeBuildStage = 0;
        private int attachmentBatchSize;
        private byte storeWorkerBuildStage = 0;
        private StoreWorker storeWorker;
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte progressListenerBuildStage = 0;
        private ProgressListener progressListener;

        private InitShim() {
        }

        int inputBufferSize() {
            if (this.inputBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inputBufferSizeBuildStage == 0) {
                this.inputBufferSizeBuildStage = (byte)-1;
                this.inputBufferSize = ImmutableFileImporter.super.inputBufferSize();
                this.inputBufferSizeBuildStage = 1;
            }
            return this.inputBufferSize;
        }

        void inputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
            this.inputBufferSizeBuildStage = 1;
        }

        int commitBatchSize() {
            if (this.commitBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitBatchSizeBuildStage == 0) {
                this.commitBatchSizeBuildStage = (byte)-1;
                this.commitBatchSize = ImmutableFileImporter.super.commitBatchSize();
                this.commitBatchSizeBuildStage = 1;
            }
            return this.commitBatchSize;
        }

        void commitBatchSize(int commitBatchSize) {
            this.commitBatchSize = commitBatchSize;
            this.commitBatchSizeBuildStage = 1;
        }

        int attachmentBatchSize() {
            if (this.attachmentBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attachmentBatchSizeBuildStage == 0) {
                this.attachmentBatchSizeBuildStage = (byte)-1;
                this.attachmentBatchSize = ImmutableFileImporter.super.attachmentBatchSize();
                this.attachmentBatchSizeBuildStage = 1;
            }
            return this.attachmentBatchSize;
        }

        void attachmentBatchSize(int attachmentBatchSize) {
            this.attachmentBatchSize = attachmentBatchSize;
            this.attachmentBatchSizeBuildStage = 1;
        }

        StoreWorker storeWorker() {
            if (this.storeWorkerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeWorkerBuildStage == 0) {
                this.storeWorkerBuildStage = (byte)-1;
                this.storeWorker = Objects.requireNonNull(ImmutableFileImporter.super.storeWorker(), "storeWorker");
                this.storeWorkerBuildStage = 1;
            }
            return this.storeWorker;
        }

        void storeWorker(StoreWorker storeWorker) {
            this.storeWorker = storeWorker;
            this.storeWorkerBuildStage = 1;
        }

        ObjectMapper objectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(ImmutableFileImporter.super.objectMapper(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        ProgressListener progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                this.progressListener = Objects.requireNonNull(ImmutableFileImporter.super.progressListener(), "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.inputBufferSizeBuildStage == -1) {
                attributes.add("inputBufferSize");
            }
            if (this.commitBatchSizeBuildStage == -1) {
                attributes.add("commitBatchSize");
            }
            if (this.attachmentBatchSizeBuildStage == -1) {
                attributes.add("attachmentBatchSize");
            }
            if (this.storeWorkerBuildStage == -1) {
                attributes.add("storeWorker");
            }
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            return "Cannot build FileImporter, attribute initializers form cycle " + attributes;
        }
    }
}

