/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.AbstractNessieImporter;
import org.projectnessie.versioned.transfer.ImmutableZipArchiveImporter;

@Value.Immutable
public abstract class ZipArchiveImporter
extends AbstractNessieImporter {
    public static Builder builder() {
        return ImmutableZipArchiveImporter.builder();
    }

    abstract Path sourceZipFile();

    @Value.Lazy
    ZipFile zipFile() throws IOException {
        return new ZipFile(this.sourceZipFile().toFile());
    }

    @Override
    protected InputStream newFileInput(String fileName) throws IOException {
        ZipFile zip = this.zipFile();
        ZipEntry entry = zip.getEntry(fileName);
        return new BufferedInputStream(zip.getInputStream(entry));
    }

    public static interface Builder
    extends AbstractNessieImporter.Builder<Builder, ZipArchiveImporter> {
        public Builder sourceZipFile(Path var1);
    }
}

