/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.immutables.value.Value;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.CommitMetaSerializer;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ImmutableHeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.BatchWriter;
import org.projectnessie.versioned.transfer.ImmutableImportResult;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

public abstract class AbstractNessieImporter {
    abstract DatabaseAdapter databaseAdapter();

    @Value.Default
    int inputBufferSize() {
        return 32768;
    }

    @Value.Default
    int commitBatchSize() {
        return 20;
    }

    @Value.Default
    int attachmentBatchSize() {
        return 20;
    }

    @Value.Default
    StoreWorker storeWorker() {
        return DefaultStoreWorker.instance();
    }

    @Value.Default
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    ProgressListener progressListener() {
        return (x, y) -> {};
    }

    public ImportResult importNessieRepository() throws IOException {
        ImmutableHeadsAndForkPoints headsAndForkPoints;
        TransferTypes.ExportMeta exportMeta;
        this.progressListener().progress(ProgressEvent.STARTED);
        this.progressListener().progress(ProgressEvent.START_META);
        try (InputStream input = this.newFileInput("export-metadata");){
            exportMeta = TransferTypes.ExportMeta.parseFrom((InputStream)input);
        }
        this.progressListener().progress(ProgressEvent.END_META, exportMeta);
        try (InputStream input = this.newFileInput("heads-and-forks");){
            TransferTypes.HeadsAndForks hf = TransferTypes.HeadsAndForks.parseFrom((InputStream)input);
            ImmutableHeadsAndForkPoints.Builder hfBuilder = ImmutableHeadsAndForkPoints.builder().scanStartedAtInMicros(hf.getScanStartedAtInMicros());
            hf.getHeadsList().forEach(h -> hfBuilder.addHeads(Hash.of((ByteString)h)));
            hf.getForkPointsList().forEach(h -> hfBuilder.addForkPoints(Hash.of((ByteString)h)));
            headsAndForkPoints = hfBuilder.build();
        }
        this.progressListener().progress(ProgressEvent.START_COMMITS);
        long commitCount = this.importCommits(exportMeta);
        this.progressListener().progress(ProgressEvent.END_COMMITS);
        this.progressListener().progress(ProgressEvent.START_NAMED_REFERENCES);
        long namedReferenceCount = this.importNamedReferences(exportMeta);
        this.progressListener().progress(ProgressEvent.END_NAMED_REFERENCES);
        this.progressListener().progress(ProgressEvent.FINISHED);
        return ImmutableImportResult.builder().exportMeta(exportMeta).headsAndForkPoints((HeadsAndForkPoints)headsAndForkPoints).importedCommitCount(commitCount).importedReferenceCount(namedReferenceCount).build();
    }

    private long importNamedReferences(TransferTypes.ExportMeta exportMeta) throws IOException {
        long namedReferenceCount = 0L;
        for (String fileName : exportMeta.getNamedReferencesFilesList()) {
            InputStream input = this.newFileInput(fileName);
            try {
                TransferTypes.NamedReference namedReference;
                while ((namedReference = TransferTypes.NamedReference.parseDelimitedFrom((InputStream)input)) != null) {
                    TagName ref;
                    switch (namedReference.getRefType()) {
                        case Tag: {
                            ref = TagName.of((String)namedReference.getName());
                            break;
                        }
                        case Branch: {
                            ref = BranchName.of((String)namedReference.getName());
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown reference type " + namedReference);
                        }
                    }
                    try {
                        this.databaseAdapter().create((NamedRef)ref, Hash.of((ByteString)namedReference.getCommitId()));
                    }
                    catch (ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    ++namedReferenceCount;
                    this.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
                }
            }
            finally {
                if (input == null) continue;
                input.close();
            }
        }
        return namedReferenceCount;
    }

    private long importCommits(TransferTypes.ExportMeta exportMeta) throws IOException {
        long commitCount = 0L;
        int keyListDistance = this.databaseAdapter().getConfig().getKeyListDistance();
        try (BatchWriter<Hash, CommitLogEntry> commitBatchWriter = BatchWriter.commitBatchWriter(this.commitBatchSize(), this.databaseAdapter());
             BatchWriter<ContentAttachmentKey, ContentAttachment> attachmentsBatchWriter = BatchWriter.attachmentsBatchWriter(this.attachmentBatchSize(), this.databaseAdapter());){
            for (String fileName : exportMeta.getCommitsFilesList()) {
                InputStream input = this.newFileInput(fileName);
                try {
                    TransferTypes.Commit commit;
                    while ((commit = TransferTypes.Commit.parseDelimitedFrom((InputStream)input)) != null) {
                        ByteString metadata;
                        try (InputStream in = commit.getMetadata().newInput();){
                            metadata = CommitMetaSerializer.METADATA_SERIALIZER.toBytes((Object)((CommitMeta)this.objectMapper().readValue(in, CommitMeta.class)));
                        }
                        ImmutableCommitLogEntry.Builder logEntry = ImmutableCommitLogEntry.builder().createdTime(commit.getCreatedTimeMicros()).commitSeq(commit.getCommitSequence()).hash(Hash.of((ByteString)commit.getCommitId())).metadata(metadata).keyListDistance((int)(commit.getCommitSequence() % (long)keyListDistance)).addParents(Hash.of((ByteString)commit.getParentCommitId()));
                        commit.getAdditionalParentsList().forEach(ap -> logEntry.addAdditionalParents(Hash.of((ByteString)ap)));
                        commit.getOperationsList().forEach(op -> {
                            Key key = Key.of((List)op.getContentKeyList());
                            switch (op.getOperationType()) {
                                case Delete: {
                                    logEntry.addDeletes(key);
                                    break;
                                }
                                case Put: {
                                    try (InputStream inValue = op.getValue().newInput();){
                                        Content content = (Content)this.objectMapper().readValue(inValue, Content.class);
                                        ByteString onRef = this.storeWorker().toStoreOnReferenceState(content, attachmentsBatchWriter::add);
                                        logEntry.addPuts(KeyWithBytes.of((Key)key, (ContentId)ContentId.of((String)op.getContentId()), (byte)((byte)op.getPayload()), (ByteString)onRef));
                                        break;
                                    }
                                    catch (IOException e) {
                                        throw new RuntimeException(e);
                                    }
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown operation type " + op);
                                }
                            }
                        });
                        commitBatchWriter.add((CommitLogEntry)logEntry.build());
                        ++commitCount;
                        this.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
                    }
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
        }
        return commitCount;
    }

    protected abstract InputStream newFileInput(String var1) throws IOException;

    public static interface Builder<B extends Builder<B, T>, T extends AbstractNessieImporter> {
        public B databaseAdapter(DatabaseAdapter var1);

        public B objectMapper(ObjectMapper var1);

        public B storeWorker(StoreWorker var1);

        public B inputBufferSize(int var1);

        public B commitBatchSize(int var1);

        public B attachmentBatchSize(int var1);

        public B progressListener(ProgressListener var1);

        public T build();
    }
}

