/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.ContentAttachmentKey;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;

final class BatchWriter<K, T>
implements AutoCloseable {
    private final Map<K, T> buffer;
    private final int capacity;
    private final Consumer<List<T>> flush;
    private final Function<T, K> keyExtractor;

    static BatchWriter<Hash, CommitLogEntry> commitBatchWriter(int batchSize, DatabaseAdapter databaseAdapter) {
        return new BatchWriter<Hash, CommitLogEntry>(batchSize, entries -> {
            try {
                databaseAdapter.writeMultipleCommits(entries);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, CommitLogEntry::getHash);
    }

    static BatchWriter<ContentAttachmentKey, ContentAttachment> attachmentsBatchWriter(int batchSize, DatabaseAdapter databaseAdapter) {
        return new BatchWriter<ContentAttachmentKey, ContentAttachment>(batchSize, attachments -> databaseAdapter.putAttachments(attachments.stream()), ContentAttachment::getKey);
    }

    BatchWriter(int capacity, Consumer<List<T>> flush, Function<T, K> keyExtractor) {
        this.capacity = capacity;
        this.flush = flush;
        this.keyExtractor = keyExtractor;
        this.buffer = Maps.newHashMapWithExpectedSize((int)capacity);
    }

    void add(T entity) {
        K key = this.keyExtractor.apply(entity);
        this.buffer.put(key, entity);
        if (this.buffer.size() == this.capacity) {
            this.flush();
        }
    }

    T useBuffered(T other) {
        K key = this.keyExtractor.apply(other);
        return this.buffer.getOrDefault(key, other);
    }

    T get(K key) {
        return this.buffer.get(key);
    }

    private void flush() {
        if (!this.buffer.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>(this.buffer.values());
            this.buffer.clear();
            this.flush.accept(list);
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

