/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.AbstractNessieImporter;
import org.projectnessie.versioned.transfer.ImmutableFileImporter;

@Value.Immutable
public abstract class FileImporter
extends AbstractNessieImporter {
    public static Builder builder() {
        return ImmutableFileImporter.builder();
    }

    abstract Path sourceDirectory();

    @Override
    protected InputStream newFileInput(String fileName) throws IOException {
        return new BufferedInputStream(Files.newInputStream(this.sourceDirectory().resolve(fileName), new OpenOption[0]), this.inputBufferSize());
    }

    public static interface Builder
    extends AbstractNessieImporter.Builder<Builder, FileImporter> {
        public Builder sourceDirectory(Path var1);
    }
}

