/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.transfer.AbstractNessieExporter;
import org.projectnessie.versioned.transfer.FileExporter;
import org.projectnessie.versioned.transfer.ProgressListener;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileExporter", generator="Immutables")
@Immutable
public final class ImmutableFileExporter
extends FileExporter {
    private final DatabaseAdapter databaseAdapter;
    private final ObjectMapper objectMapper;
    private final StoreWorker storeWorker;
    private final int outputBufferSize;
    private final long maxFileSize;
    private final int expectedCommitCount;
    private final ProgressListener progressListener;
    private final Path targetDirectory;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFileExporter(Builder builder) {
        this.databaseAdapter = builder.databaseAdapter;
        this.targetDirectory = builder.targetDirectory;
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.storeWorker != null) {
            this.initShim.storeWorker(builder.storeWorker);
        }
        if (builder.outputBufferSizeIsSet()) {
            this.initShim.outputBufferSize(builder.outputBufferSize);
        }
        if (builder.maxFileSizeIsSet()) {
            this.initShim.maxFileSize(builder.maxFileSize);
        }
        if (builder.expectedCommitCountIsSet()) {
            this.initShim.expectedCommitCount(builder.expectedCommitCount);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener(builder.progressListener);
        }
        this.objectMapper = this.initShim.objectMapper();
        this.storeWorker = this.initShim.storeWorker();
        this.outputBufferSize = this.initShim.outputBufferSize();
        this.maxFileSize = this.initShim.maxFileSize();
        this.expectedCommitCount = this.initShim.expectedCommitCount();
        this.progressListener = this.initShim.progressListener();
        this.initShim = null;
    }

    private ImmutableFileExporter(DatabaseAdapter databaseAdapter, ObjectMapper objectMapper, StoreWorker storeWorker, int outputBufferSize, long maxFileSize, int expectedCommitCount, ProgressListener progressListener, Path targetDirectory) {
        this.databaseAdapter = databaseAdapter;
        this.objectMapper = objectMapper;
        this.storeWorker = storeWorker;
        this.outputBufferSize = outputBufferSize;
        this.maxFileSize = maxFileSize;
        this.expectedCommitCount = expectedCommitCount;
        this.progressListener = progressListener;
        this.targetDirectory = targetDirectory;
        this.initShim = null;
    }

    @Override
    DatabaseAdapter databaseAdapter() {
        return this.databaseAdapter;
    }

    @Override
    ObjectMapper objectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.objectMapper() : this.objectMapper;
    }

    @Override
    StoreWorker storeWorker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storeWorker() : this.storeWorker;
    }

    @Override
    int outputBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputBufferSize() : this.outputBufferSize;
    }

    @Override
    long maxFileSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxFileSize() : this.maxFileSize;
    }

    @Override
    int expectedCommitCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expectedCommitCount() : this.expectedCommitCount;
    }

    @Override
    ProgressListener progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    @Override
    Path targetDirectory() {
        return this.targetDirectory;
    }

    public final ImmutableFileExporter withDatabaseAdapter(DatabaseAdapter value) {
        if (this.databaseAdapter == value) {
            return this;
        }
        DatabaseAdapter newValue = Objects.requireNonNull(value, "databaseAdapter");
        return new ImmutableFileExporter(newValue, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.progressListener, this.targetDirectory);
    }

    public final ImmutableFileExporter withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableFileExporter(this.databaseAdapter, newValue, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.progressListener, this.targetDirectory);
    }

    public final ImmutableFileExporter withStoreWorker(StoreWorker value) {
        if (this.storeWorker == value) {
            return this;
        }
        StoreWorker newValue = Objects.requireNonNull(value, "storeWorker");
        return new ImmutableFileExporter(this.databaseAdapter, this.objectMapper, newValue, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.progressListener, this.targetDirectory);
    }

    public final ImmutableFileExporter withOutputBufferSize(int value) {
        if (this.outputBufferSize == value) {
            return this;
        }
        return new ImmutableFileExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, value, this.maxFileSize, this.expectedCommitCount, this.progressListener, this.targetDirectory);
    }

    public final ImmutableFileExporter withMaxFileSize(long value) {
        if (this.maxFileSize == value) {
            return this;
        }
        return new ImmutableFileExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, value, this.expectedCommitCount, this.progressListener, this.targetDirectory);
    }

    public final ImmutableFileExporter withExpectedCommitCount(int value) {
        if (this.expectedCommitCount == value) {
            return this;
        }
        return new ImmutableFileExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, value, this.progressListener, this.targetDirectory);
    }

    public final ImmutableFileExporter withProgressListener(ProgressListener value) {
        if (this.progressListener == value) {
            return this;
        }
        ProgressListener newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableFileExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, newValue, this.targetDirectory);
    }

    public final ImmutableFileExporter withTargetDirectory(Path value) {
        if (this.targetDirectory == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "targetDirectory");
        return new ImmutableFileExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.progressListener, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileExporter && this.equalTo(0, (ImmutableFileExporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileExporter another) {
        return this.databaseAdapter.equals(another.databaseAdapter) && this.objectMapper.equals(another.objectMapper) && this.storeWorker.equals(another.storeWorker) && this.outputBufferSize == another.outputBufferSize && this.maxFileSize == another.maxFileSize && this.expectedCommitCount == another.expectedCommitCount && this.progressListener.equals(another.progressListener) && this.targetDirectory.equals(another.targetDirectory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseAdapter.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.storeWorker.hashCode();
        h += (h << 5) + this.outputBufferSize;
        h += (h << 5) + Longs.hashCode((long)this.maxFileSize);
        h += (h << 5) + this.expectedCommitCount;
        h += (h << 5) + this.progressListener.hashCode();
        h += (h << 5) + this.targetDirectory.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileExporter").omitNullValues().add("databaseAdapter", (Object)this.databaseAdapter).add("objectMapper", (Object)this.objectMapper).add("storeWorker", (Object)this.storeWorker).add("outputBufferSize", this.outputBufferSize).add("maxFileSize", this.maxFileSize).add("expectedCommitCount", this.expectedCommitCount).add("progressListener", (Object)this.progressListener).add("targetDirectory", (Object)this.targetDirectory).toString();
    }

    public static ImmutableFileExporter copyOf(FileExporter instance) {
        if (instance instanceof ImmutableFileExporter) {
            return (ImmutableFileExporter)instance;
        }
        return ImmutableFileExporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileExporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FileExporter.Builder {
        private static final long INIT_BIT_DATABASE_ADAPTER = 1L;
        private static final long INIT_BIT_TARGET_DIRECTORY = 2L;
        private static final long OPT_BIT_OUTPUT_BUFFER_SIZE = 1L;
        private static final long OPT_BIT_MAX_FILE_SIZE = 2L;
        private static final long OPT_BIT_EXPECTED_COMMIT_COUNT = 4L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private DatabaseAdapter databaseAdapter;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private StoreWorker storeWorker;
        private int outputBufferSize;
        private long maxFileSize;
        private int expectedCommitCount;
        @Nullable
        private ProgressListener progressListener;
        @Nullable
        private Path targetDirectory;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AbstractNessieExporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(FileExporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractNessieExporter instance;
            if (object instanceof AbstractNessieExporter) {
                instance = (AbstractNessieExporter)object;
                this.progressListener(instance.progressListener());
                this.expectedCommitCount(instance.expectedCommitCount());
                this.databaseAdapter(instance.databaseAdapter());
                this.objectMapper(instance.objectMapper());
                this.outputBufferSize(instance.outputBufferSize());
                this.maxFileSize(instance.maxFileSize());
                this.storeWorker(instance.storeWorker());
            }
            if (object instanceof FileExporter) {
                instance = (FileExporter)object;
                this.targetDirectory(((FileExporter)instance).targetDirectory());
            }
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder databaseAdapter(DatabaseAdapter databaseAdapter) {
            this.databaseAdapter = Objects.requireNonNull(databaseAdapter, "databaseAdapter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder storeWorker(StoreWorker storeWorker) {
            this.storeWorker = Objects.requireNonNull(storeWorker, "storeWorker");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedCommitCount(int expectedCommitCount) {
            this.expectedCommitCount = expectedCommitCount;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder progressListener(ProgressListener progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder targetDirectory(Path targetDirectory) {
            this.targetDirectory = Objects.requireNonNull(targetDirectory, "targetDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public ImmutableFileExporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileExporter(this);
        }

        private boolean outputBufferSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean maxFileSizeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean expectedCommitCountIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseAdapter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("targetDirectory");
            }
            return "Cannot build FileExporter, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="FileExporter", generator="Immutables")
    private final class InitShim {
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte storeWorkerBuildStage = 0;
        private StoreWorker storeWorker;
        private byte outputBufferSizeBuildStage = 0;
        private int outputBufferSize;
        private byte maxFileSizeBuildStage = 0;
        private long maxFileSize;
        private byte expectedCommitCountBuildStage = 0;
        private int expectedCommitCount;
        private byte progressListenerBuildStage = 0;
        private ProgressListener progressListener;

        private InitShim() {
        }

        ObjectMapper objectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(ImmutableFileExporter.super.objectMapper(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        StoreWorker storeWorker() {
            if (this.storeWorkerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeWorkerBuildStage == 0) {
                this.storeWorkerBuildStage = (byte)-1;
                this.storeWorker = Objects.requireNonNull(ImmutableFileExporter.super.storeWorker(), "storeWorker");
                this.storeWorkerBuildStage = 1;
            }
            return this.storeWorker;
        }

        void storeWorker(StoreWorker storeWorker) {
            this.storeWorker = storeWorker;
            this.storeWorkerBuildStage = 1;
        }

        int outputBufferSize() {
            if (this.outputBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputBufferSizeBuildStage == 0) {
                this.outputBufferSizeBuildStage = (byte)-1;
                this.outputBufferSize = ImmutableFileExporter.super.outputBufferSize();
                this.outputBufferSizeBuildStage = 1;
            }
            return this.outputBufferSize;
        }

        void outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            this.outputBufferSizeBuildStage = 1;
        }

        long maxFileSize() {
            if (this.maxFileSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxFileSizeBuildStage == 0) {
                this.maxFileSizeBuildStage = (byte)-1;
                this.maxFileSize = ImmutableFileExporter.super.maxFileSize();
                this.maxFileSizeBuildStage = 1;
            }
            return this.maxFileSize;
        }

        void maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.maxFileSizeBuildStage = 1;
        }

        int expectedCommitCount() {
            if (this.expectedCommitCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expectedCommitCountBuildStage == 0) {
                this.expectedCommitCountBuildStage = (byte)-1;
                this.expectedCommitCount = ImmutableFileExporter.super.expectedCommitCount();
                this.expectedCommitCountBuildStage = 1;
            }
            return this.expectedCommitCount;
        }

        void expectedCommitCount(int expectedCommitCount) {
            this.expectedCommitCount = expectedCommitCount;
            this.expectedCommitCountBuildStage = 1;
        }

        ProgressListener progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                this.progressListener = Objects.requireNonNull(ImmutableFileExporter.super.progressListener(), "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.storeWorkerBuildStage == -1) {
                attributes.add("storeWorker");
            }
            if (this.outputBufferSizeBuildStage == -1) {
                attributes.add("outputBufferSize");
            }
            if (this.maxFileSizeBuildStage == -1) {
                attributes.add("maxFileSize");
            }
            if (this.expectedCommitCountBuildStage == -1) {
                attributes.add("expectedCommitCount");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            return "Cannot build FileExporter, attribute initializers form cycle " + attributes;
        }
    }
}

