/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ImportResult", generator="Immutables")
@Immutable
public final class ImmutableImportResult
implements ImportResult {
    private final TransferTypes.ExportMeta exportMeta;
    private final HeadsAndForkPoints headsAndForkPoints;
    private final long importedCommitCount;
    private final long importedReferenceCount;

    private ImmutableImportResult(TransferTypes.ExportMeta exportMeta, HeadsAndForkPoints headsAndForkPoints, long importedCommitCount, long importedReferenceCount) {
        this.exportMeta = exportMeta;
        this.headsAndForkPoints = headsAndForkPoints;
        this.importedCommitCount = importedCommitCount;
        this.importedReferenceCount = importedReferenceCount;
    }

    @Override
    public TransferTypes.ExportMeta exportMeta() {
        return this.exportMeta;
    }

    @Override
    public HeadsAndForkPoints headsAndForkPoints() {
        return this.headsAndForkPoints;
    }

    @Override
    public long importedCommitCount() {
        return this.importedCommitCount;
    }

    @Override
    public long importedReferenceCount() {
        return this.importedReferenceCount;
    }

    public final ImmutableImportResult withExportMeta(TransferTypes.ExportMeta value) {
        if (this.exportMeta == value) {
            return this;
        }
        TransferTypes.ExportMeta newValue = Objects.requireNonNull(value, "exportMeta");
        return new ImmutableImportResult(newValue, this.headsAndForkPoints, this.importedCommitCount, this.importedReferenceCount);
    }

    public final ImmutableImportResult withHeadsAndForkPoints(HeadsAndForkPoints value) {
        if (this.headsAndForkPoints == value) {
            return this;
        }
        HeadsAndForkPoints newValue = Objects.requireNonNull(value, "headsAndForkPoints");
        return new ImmutableImportResult(this.exportMeta, newValue, this.importedCommitCount, this.importedReferenceCount);
    }

    public final ImmutableImportResult withImportedCommitCount(long value) {
        if (this.importedCommitCount == value) {
            return this;
        }
        return new ImmutableImportResult(this.exportMeta, this.headsAndForkPoints, value, this.importedReferenceCount);
    }

    public final ImmutableImportResult withImportedReferenceCount(long value) {
        if (this.importedReferenceCount == value) {
            return this;
        }
        return new ImmutableImportResult(this.exportMeta, this.headsAndForkPoints, this.importedCommitCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImportResult && this.equalTo(0, (ImmutableImportResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableImportResult another) {
        return this.exportMeta.equals((Object)another.exportMeta) && this.headsAndForkPoints.equals(another.headsAndForkPoints) && this.importedCommitCount == another.importedCommitCount && this.importedReferenceCount == another.importedReferenceCount;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.exportMeta.hashCode();
        h += (h << 5) + this.headsAndForkPoints.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.importedCommitCount);
        h += (h << 5) + Longs.hashCode((long)this.importedReferenceCount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ImportResult").omitNullValues().add("exportMeta", (Object)this.exportMeta).add("headsAndForkPoints", (Object)this.headsAndForkPoints).add("importedCommitCount", this.importedCommitCount).add("importedReferenceCount", this.importedReferenceCount).toString();
    }

    public static ImmutableImportResult copyOf(ImportResult instance) {
        if (instance instanceof ImmutableImportResult) {
            return (ImmutableImportResult)instance;
        }
        return ImmutableImportResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ImportResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXPORT_META = 1L;
        private static final long INIT_BIT_HEADS_AND_FORK_POINTS = 2L;
        private static final long INIT_BIT_IMPORTED_COMMIT_COUNT = 4L;
        private static final long INIT_BIT_IMPORTED_REFERENCE_COUNT = 8L;
        private long initBits = 15L;
        @Nullable
        private TransferTypes.ExportMeta exportMeta;
        @Nullable
        private HeadsAndForkPoints headsAndForkPoints;
        private long importedCommitCount;
        private long importedReferenceCount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ImportResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.exportMeta(instance.exportMeta());
            this.headsAndForkPoints(instance.headsAndForkPoints());
            this.importedCommitCount(instance.importedCommitCount());
            this.importedReferenceCount(instance.importedReferenceCount());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exportMeta(TransferTypes.ExportMeta exportMeta) {
            this.exportMeta = Objects.requireNonNull(exportMeta, "exportMeta");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder headsAndForkPoints(HeadsAndForkPoints headsAndForkPoints) {
            this.headsAndForkPoints = Objects.requireNonNull(headsAndForkPoints, "headsAndForkPoints");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder importedCommitCount(long importedCommitCount) {
            this.importedCommitCount = importedCommitCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder importedReferenceCount(long importedReferenceCount) {
            this.importedReferenceCount = importedReferenceCount;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableImportResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImportResult(this.exportMeta, this.headsAndForkPoints, this.importedCommitCount, this.importedReferenceCount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("exportMeta");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("headsAndForkPoints");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("importedCommitCount");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("importedReferenceCount");
            }
            return "Cannot build ImportResult, some of required attributes are not set " + attributes;
        }
    }
}

