/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.IOException;
import java.io.OutputStream;
import org.projectnessie.versioned.transfer.ExportContext;
import org.projectnessie.versioned.transfer.ExportFileSupplier;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

abstract class ExportCommon {
    final ExportFileSupplier exportFiles;
    final NessieExporter exporter;

    ExportCommon(ExportFileSupplier exportFiles, NessieExporter exporter) {
        this.exportFiles = exportFiles;
        this.exporter = exporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransferTypes.ExportMeta exportRepo() throws IOException {
        ExportContext exportContext = this.createExportContext(this.getExportVersion());
        try {
            this.exporter.progressListener().progress(ProgressEvent.STARTED);
            this.exporter.progressListener().progress(ProgressEvent.START_NAMED_REFERENCES);
            this.exportReferences(exportContext);
            exportContext.namedReferenceOutput.finishCurrentFile();
            this.exporter.progressListener().progress(ProgressEvent.END_NAMED_REFERENCES);
            this.exporter.progressListener().progress(ProgressEvent.START_COMMITS);
            TransferTypes.HeadsAndForks headsAndForks = this.exportCommits(exportContext);
            exportContext.commitOutput.finishCurrentFile();
            this.writeHeadsAndForks(headsAndForks);
            this.exporter.progressListener().progress(ProgressEvent.END_COMMITS);
            this.exporter.progressListener().progress(ProgressEvent.START_META);
            this.writeRepositoryDescription();
            TransferTypes.ExportMeta meta = exportContext.finish();
            this.writeExportMeta(meta);
            this.exporter.progressListener().progress(ProgressEvent.END_META, meta);
            this.exporter.progressListener().progress(ProgressEvent.FINISHED);
            TransferTypes.ExportMeta exportMeta = meta;
            return exportMeta;
        }
        finally {
            exportContext.closeSilently();
        }
    }

    abstract long currentTimestampMillis();

    ExportContext createExportContext(TransferTypes.ExportVersion exportVersion) {
        return new ExportContext(this.exportFiles, this.exporter, TransferTypes.ExportMeta.newBuilder().setCreatedMillisEpoch(this.currentTimestampMillis()).setVersion(exportVersion));
    }

    abstract TransferTypes.ExportVersion getExportVersion();

    abstract void exportReferences(ExportContext var1);

    abstract TransferTypes.HeadsAndForks exportCommits(ExportContext var1);

    abstract void writeRepositoryDescription() throws IOException;

    void writeExportMeta(TransferTypes.ExportMeta meta) throws IOException {
        try (OutputStream output = this.exportFiles.newFileOutput("export-metadata");){
            meta.writeTo(output);
        }
    }

    void writeHeadsAndForks(TransferTypes.HeadsAndForks hf) throws IOException {
        try (OutputStream output = this.exportFiles.newFileOutput("heads-and-forks");){
            hf.writeTo(output);
        }
    }
}

