/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.ExportFileSupplier;
import org.projectnessie.versioned.transfer.ImmutableFileExporter;

@Value.Immutable
public abstract class FileExporter
implements ExportFileSupplier {
    public static Builder builder() {
        return ImmutableFileExporter.builder();
    }

    abstract Path targetDirectory();

    @Override
    public void preValidate() throws IOException {
        if (Files.isDirectory(this.targetDirectory(), new LinkOption[0])) {
            try (Stream<Path> listing = Files.list(this.targetDirectory());){
                Preconditions.checkState((!listing.findAny().isPresent() ? 1 : 0) != 0, (String)"Target directory %s must be empty, but is not", (Object)this.targetDirectory());
            }
        } else {
            Files.createDirectories(this.targetDirectory(), new FileAttribute[0]);
        }
    }

    @Override
    public OutputStream newFileOutput(String fileName) throws IOException {
        return Files.newOutputStream(this.targetDirectory().resolve(fileName), new OpenOption[0]);
    }

    @Override
    public void close() {
    }

    public static interface Builder {
        public Builder targetDirectory(Path var1);

        public FileExporter build();
    }
}

