/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.ImmutableFileImporter;
import org.projectnessie.versioned.transfer.ImportFileSupplier;

@Value.Immutable
public abstract class FileImporter
implements ImportFileSupplier {
    public static Builder builder() {
        return ImmutableFileImporter.builder();
    }

    @Value.Default
    int inputBufferSize() {
        return 32768;
    }

    abstract Path sourceDirectory();

    @Override
    public InputStream newFileInput(String fileName) throws IOException {
        return new BufferedInputStream(Files.newInputStream(this.sourceDirectory().resolve(fileName), new OpenOption[0]), this.inputBufferSize());
    }

    @Override
    public void close() {
    }

    public static interface Builder {
        public Builder sourceDirectory(Path var1);

        public Builder inputBufferSize(int var1);

        public FileImporter build();
    }
}

