/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.transfer.FileExporter;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileExporter", generator="Immutables")
@Immutable
public final class ImmutableFileExporter
extends FileExporter {
    private final Path targetDirectory;

    private ImmutableFileExporter(Path targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    @Override
    Path targetDirectory() {
        return this.targetDirectory;
    }

    public final ImmutableFileExporter withTargetDirectory(Path value) {
        if (this.targetDirectory == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "targetDirectory");
        return new ImmutableFileExporter(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileExporter && this.equalTo(0, (ImmutableFileExporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileExporter another) {
        return this.targetDirectory.equals(another.targetDirectory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.targetDirectory.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileExporter").omitNullValues().add("targetDirectory", (Object)this.targetDirectory).toString();
    }

    public static ImmutableFileExporter copyOf(FileExporter instance) {
        if (instance instanceof ImmutableFileExporter) {
            return (ImmutableFileExporter)instance;
        }
        return ImmutableFileExporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileExporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FileExporter.Builder {
        private static final long INIT_BIT_TARGET_DIRECTORY = 1L;
        private long initBits = 1L;
        @Nullable
        private Path targetDirectory;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileExporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.targetDirectory(instance.targetDirectory());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder targetDirectory(Path targetDirectory) {
            this.targetDirectory = Objects.requireNonNull(targetDirectory, "targetDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableFileExporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileExporter(this.targetDirectory);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetDirectory");
            }
            return "Cannot build FileExporter, some of required attributes are not set " + attributes;
        }
    }
}

