/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.transfer.ExportFileSupplier;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressListener;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="NessieExporter", generator="Immutables")
@Immutable
public final class ImmutableNessieExporter
extends NessieExporter {
    private final DatabaseAdapter databaseAdapter;
    private final ObjectMapper objectMapper;
    private final StoreWorker storeWorker;
    private final int outputBufferSize;
    private final long maxFileSize;
    private final int expectedCommitCount;
    private final ExportFileSupplier exportFileSupplier;
    private final ProgressListener progressListener;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNessieExporter(Builder builder) {
        this.databaseAdapter = builder.databaseAdapter;
        this.exportFileSupplier = builder.exportFileSupplier;
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.storeWorker != null) {
            this.initShim.storeWorker(builder.storeWorker);
        }
        if (builder.outputBufferSizeIsSet()) {
            this.initShim.outputBufferSize(builder.outputBufferSize);
        }
        if (builder.maxFileSizeIsSet()) {
            this.initShim.maxFileSize(builder.maxFileSize);
        }
        if (builder.expectedCommitCountIsSet()) {
            this.initShim.expectedCommitCount(builder.expectedCommitCount);
        }
        if (builder.progressListener != null) {
            this.initShim.progressListener(builder.progressListener);
        }
        this.objectMapper = this.initShim.objectMapper();
        this.storeWorker = this.initShim.storeWorker();
        this.outputBufferSize = this.initShim.outputBufferSize();
        this.maxFileSize = this.initShim.maxFileSize();
        this.expectedCommitCount = this.initShim.expectedCommitCount();
        this.progressListener = this.initShim.progressListener();
        this.initShim = null;
    }

    private ImmutableNessieExporter(DatabaseAdapter databaseAdapter, ObjectMapper objectMapper, StoreWorker storeWorker, int outputBufferSize, long maxFileSize, int expectedCommitCount, ExportFileSupplier exportFileSupplier, ProgressListener progressListener) {
        this.databaseAdapter = databaseAdapter;
        this.objectMapper = objectMapper;
        this.storeWorker = storeWorker;
        this.outputBufferSize = outputBufferSize;
        this.maxFileSize = maxFileSize;
        this.expectedCommitCount = expectedCommitCount;
        this.exportFileSupplier = exportFileSupplier;
        this.progressListener = progressListener;
        this.initShim = null;
    }

    @Override
    DatabaseAdapter databaseAdapter() {
        return this.databaseAdapter;
    }

    @Override
    ObjectMapper objectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.objectMapper() : this.objectMapper;
    }

    @Override
    StoreWorker storeWorker() {
        InitShim shim = this.initShim;
        return shim != null ? shim.storeWorker() : this.storeWorker;
    }

    @Override
    int outputBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.outputBufferSize() : this.outputBufferSize;
    }

    @Override
    long maxFileSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxFileSize() : this.maxFileSize;
    }

    @Override
    int expectedCommitCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expectedCommitCount() : this.expectedCommitCount;
    }

    @Override
    ExportFileSupplier exportFileSupplier() {
        return this.exportFileSupplier;
    }

    @Override
    ProgressListener progressListener() {
        InitShim shim = this.initShim;
        return shim != null ? shim.progressListener() : this.progressListener;
    }

    public final ImmutableNessieExporter withDatabaseAdapter(DatabaseAdapter value) {
        if (this.databaseAdapter == value) {
            return this;
        }
        DatabaseAdapter newValue = Objects.requireNonNull(value, "databaseAdapter");
        return new ImmutableNessieExporter(newValue, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return new ImmutableNessieExporter(this.databaseAdapter, newValue, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withStoreWorker(StoreWorker value) {
        if (this.storeWorker == value) {
            return this;
        }
        StoreWorker newValue = Objects.requireNonNull(value, "storeWorker");
        return new ImmutableNessieExporter(this.databaseAdapter, this.objectMapper, newValue, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withOutputBufferSize(int value) {
        if (this.outputBufferSize == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, value, this.maxFileSize, this.expectedCommitCount, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withMaxFileSize(long value) {
        if (this.maxFileSize == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, value, this.expectedCommitCount, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withExpectedCommitCount(int value) {
        if (this.expectedCommitCount == value) {
            return this;
        }
        return new ImmutableNessieExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, value, this.exportFileSupplier, this.progressListener);
    }

    public final ImmutableNessieExporter withExportFileSupplier(ExportFileSupplier value) {
        if (this.exportFileSupplier == value) {
            return this;
        }
        ExportFileSupplier newValue = Objects.requireNonNull(value, "exportFileSupplier");
        return new ImmutableNessieExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, newValue, this.progressListener);
    }

    public final ImmutableNessieExporter withProgressListener(ProgressListener value) {
        if (this.progressListener == value) {
            return this;
        }
        ProgressListener newValue = Objects.requireNonNull(value, "progressListener");
        return new ImmutableNessieExporter(this.databaseAdapter, this.objectMapper, this.storeWorker, this.outputBufferSize, this.maxFileSize, this.expectedCommitCount, this.exportFileSupplier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNessieExporter && this.equalTo(0, (ImmutableNessieExporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableNessieExporter another) {
        return this.databaseAdapter.equals(another.databaseAdapter) && this.objectMapper.equals(another.objectMapper) && this.storeWorker.equals(another.storeWorker) && this.outputBufferSize == another.outputBufferSize && this.maxFileSize == another.maxFileSize && this.expectedCommitCount == another.expectedCommitCount && this.exportFileSupplier.equals(another.exportFileSupplier) && this.progressListener.equals(another.progressListener);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseAdapter.hashCode();
        h += (h << 5) + this.objectMapper.hashCode();
        h += (h << 5) + this.storeWorker.hashCode();
        h += (h << 5) + this.outputBufferSize;
        h += (h << 5) + Longs.hashCode((long)this.maxFileSize);
        h += (h << 5) + this.expectedCommitCount;
        h += (h << 5) + this.exportFileSupplier.hashCode();
        h += (h << 5) + this.progressListener.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"NessieExporter").omitNullValues().add("databaseAdapter", (Object)this.databaseAdapter).add("objectMapper", (Object)this.objectMapper).add("storeWorker", (Object)this.storeWorker).add("outputBufferSize", this.outputBufferSize).add("maxFileSize", this.maxFileSize).add("expectedCommitCount", this.expectedCommitCount).add("exportFileSupplier", (Object)this.exportFileSupplier).add("progressListener", (Object)this.progressListener).toString();
    }

    public static ImmutableNessieExporter copyOf(NessieExporter instance) {
        if (instance instanceof ImmutableNessieExporter) {
            return (ImmutableNessieExporter)instance;
        }
        return ImmutableNessieExporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NessieExporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements NessieExporter.Builder {
        private static final long INIT_BIT_DATABASE_ADAPTER = 1L;
        private static final long INIT_BIT_EXPORT_FILE_SUPPLIER = 2L;
        private static final long OPT_BIT_OUTPUT_BUFFER_SIZE = 1L;
        private static final long OPT_BIT_MAX_FILE_SIZE = 2L;
        private static final long OPT_BIT_EXPECTED_COMMIT_COUNT = 4L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private DatabaseAdapter databaseAdapter;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private StoreWorker storeWorker;
        private int outputBufferSize;
        private long maxFileSize;
        private int expectedCommitCount;
        @Nullable
        private ExportFileSupplier exportFileSupplier;
        @Nullable
        private ProgressListener progressListener;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(NessieExporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.databaseAdapter(instance.databaseAdapter());
            this.objectMapper(instance.objectMapper());
            this.storeWorker(instance.storeWorker());
            this.outputBufferSize(instance.outputBufferSize());
            this.maxFileSize(instance.maxFileSize());
            this.expectedCommitCount(instance.expectedCommitCount());
            this.exportFileSupplier(instance.exportFileSupplier());
            this.progressListener(instance.progressListener());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder databaseAdapter(DatabaseAdapter databaseAdapter) {
            this.databaseAdapter = Objects.requireNonNull(databaseAdapter, "databaseAdapter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder storeWorker(StoreWorker storeWorker) {
            this.storeWorker = Objects.requireNonNull(storeWorker, "storeWorker");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.optBits |= 2L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder expectedCommitCount(int expectedCommitCount) {
            this.expectedCommitCount = expectedCommitCount;
            this.optBits |= 4L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder exportFileSupplier(ExportFileSupplier exportFileSupplier) {
            this.exportFileSupplier = Objects.requireNonNull(exportFileSupplier, "exportFileSupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder progressListener(ProgressListener progressListener) {
            this.progressListener = Objects.requireNonNull(progressListener, "progressListener");
            return this;
        }

        @Override
        public ImmutableNessieExporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNessieExporter(this);
        }

        private boolean outputBufferSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean maxFileSizeIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean expectedCommitCountIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseAdapter");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("exportFileSupplier");
            }
            return "Cannot build NessieExporter, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="NessieExporter", generator="Immutables")
    private final class InitShim {
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte storeWorkerBuildStage = 0;
        private StoreWorker storeWorker;
        private byte outputBufferSizeBuildStage = 0;
        private int outputBufferSize;
        private byte maxFileSizeBuildStage = 0;
        private long maxFileSize;
        private byte expectedCommitCountBuildStage = 0;
        private int expectedCommitCount;
        private byte progressListenerBuildStage = 0;
        private ProgressListener progressListener;

        private InitShim() {
        }

        ObjectMapper objectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(ImmutableNessieExporter.super.objectMapper(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        StoreWorker storeWorker() {
            if (this.storeWorkerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.storeWorkerBuildStage == 0) {
                this.storeWorkerBuildStage = (byte)-1;
                this.storeWorker = Objects.requireNonNull(ImmutableNessieExporter.super.storeWorker(), "storeWorker");
                this.storeWorkerBuildStage = 1;
            }
            return this.storeWorker;
        }

        void storeWorker(StoreWorker storeWorker) {
            this.storeWorker = storeWorker;
            this.storeWorkerBuildStage = 1;
        }

        int outputBufferSize() {
            if (this.outputBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputBufferSizeBuildStage == 0) {
                this.outputBufferSizeBuildStage = (byte)-1;
                this.outputBufferSize = ImmutableNessieExporter.super.outputBufferSize();
                this.outputBufferSizeBuildStage = 1;
            }
            return this.outputBufferSize;
        }

        void outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            this.outputBufferSizeBuildStage = 1;
        }

        long maxFileSize() {
            if (this.maxFileSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxFileSizeBuildStage == 0) {
                this.maxFileSizeBuildStage = (byte)-1;
                this.maxFileSize = ImmutableNessieExporter.super.maxFileSize();
                this.maxFileSizeBuildStage = 1;
            }
            return this.maxFileSize;
        }

        void maxFileSize(long maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.maxFileSizeBuildStage = 1;
        }

        int expectedCommitCount() {
            if (this.expectedCommitCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expectedCommitCountBuildStage == 0) {
                this.expectedCommitCountBuildStage = (byte)-1;
                this.expectedCommitCount = ImmutableNessieExporter.super.expectedCommitCount();
                this.expectedCommitCountBuildStage = 1;
            }
            return this.expectedCommitCount;
        }

        void expectedCommitCount(int expectedCommitCount) {
            this.expectedCommitCount = expectedCommitCount;
            this.expectedCommitCountBuildStage = 1;
        }

        ProgressListener progressListener() {
            if (this.progressListenerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.progressListenerBuildStage == 0) {
                this.progressListenerBuildStage = (byte)-1;
                this.progressListener = Objects.requireNonNull(ImmutableNessieExporter.super.progressListener(), "progressListener");
                this.progressListenerBuildStage = 1;
            }
            return this.progressListener;
        }

        void progressListener(ProgressListener progressListener) {
            this.progressListener = progressListener;
            this.progressListenerBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.storeWorkerBuildStage == -1) {
                attributes.add("storeWorker");
            }
            if (this.outputBufferSizeBuildStage == -1) {
                attributes.add("outputBufferSize");
            }
            if (this.maxFileSizeBuildStage == -1) {
                attributes.add("maxFileSize");
            }
            if (this.expectedCommitCountBuildStage == -1) {
                attributes.add("expectedCommitCount");
            }
            if (this.progressListenerBuildStage == -1) {
                attributes.add("progressListener");
            }
            return "Cannot build NessieExporter, attribute initializers form cycle " + attributes;
        }
    }
}

