/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.ZipOutputStream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.transfer.ZipArchiveExporter;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ZipArchiveExporter", generator="Immutables")
@Immutable
public final class ImmutableZipArchiveExporter
extends ZipArchiveExporter {
    private final Path outputFile;
    private volatile transient long lazyInitBitmap;
    private static final long ZIP_OUTPUT_LAZY_INIT_BIT = 1L;
    private transient ZipOutputStream zipOutput;

    private ImmutableZipArchiveExporter(Path outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    Path outputFile() {
        return this.outputFile;
    }

    public final ImmutableZipArchiveExporter withOutputFile(Path value) {
        if (this.outputFile == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "outputFile");
        return new ImmutableZipArchiveExporter(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableZipArchiveExporter && this.equalTo(0, (ImmutableZipArchiveExporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableZipArchiveExporter another) {
        return this.outputFile.equals(another.outputFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.outputFile.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ZipArchiveExporter").omitNullValues().add("outputFile", (Object)this.outputFile).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ZipOutputStream zipOutput() throws IOException {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableZipArchiveExporter immutableZipArchiveExporter = this;
            synchronized (immutableZipArchiveExporter) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.zipOutput = Objects.requireNonNull(super.zipOutput(), "zipOutput");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.zipOutput;
    }

    public static ImmutableZipArchiveExporter copyOf(ZipArchiveExporter instance) {
        if (instance instanceof ImmutableZipArchiveExporter) {
            return (ImmutableZipArchiveExporter)instance;
        }
        return ImmutableZipArchiveExporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ZipArchiveExporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ZipArchiveExporter.Builder {
        private static final long INIT_BIT_OUTPUT_FILE = 1L;
        private long initBits = 1L;
        @Nullable
        private Path outputFile;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ZipArchiveExporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.outputFile(instance.outputFile());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder outputFile(Path outputFile) {
            this.outputFile = Objects.requireNonNull(outputFile, "outputFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableZipArchiveExporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableZipArchiveExporter(this.outputFile);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("outputFile");
            }
            return "Cannot build ZipArchiveExporter, some of required attributes are not set " + attributes;
        }
    }
}

