/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.ZipFile;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.transfer.ZipArchiveImporter;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ZipArchiveImporter", generator="Immutables")
@Immutable
public final class ImmutableZipArchiveImporter
extends ZipArchiveImporter {
    private final Path sourceZipFile;
    private volatile transient long lazyInitBitmap;
    private static final long ZIP_FILE_LAZY_INIT_BIT = 1L;
    private transient ZipFile zipFile;

    private ImmutableZipArchiveImporter(Path sourceZipFile) {
        this.sourceZipFile = sourceZipFile;
    }

    @Override
    Path sourceZipFile() {
        return this.sourceZipFile;
    }

    public final ImmutableZipArchiveImporter withSourceZipFile(Path value) {
        if (this.sourceZipFile == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "sourceZipFile");
        return new ImmutableZipArchiveImporter(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableZipArchiveImporter && this.equalTo(0, (ImmutableZipArchiveImporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableZipArchiveImporter another) {
        return this.sourceZipFile.equals(another.sourceZipFile);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sourceZipFile.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ZipArchiveImporter").omitNullValues().add("sourceZipFile", (Object)this.sourceZipFile).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    ZipFile zipFile() throws IOException {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableZipArchiveImporter immutableZipArchiveImporter = this;
            synchronized (immutableZipArchiveImporter) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.zipFile = Objects.requireNonNull(super.zipFile(), "zipFile");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.zipFile;
    }

    public static ImmutableZipArchiveImporter copyOf(ZipArchiveImporter instance) {
        if (instance instanceof ImmutableZipArchiveImporter) {
            return (ImmutableZipArchiveImporter)instance;
        }
        return ImmutableZipArchiveImporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ZipArchiveImporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ZipArchiveImporter.Builder {
        private static final long INIT_BIT_SOURCE_ZIP_FILE = 1L;
        private long initBits = 1L;
        @Nullable
        private Path sourceZipFile;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ZipArchiveImporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.sourceZipFile(instance.sourceZipFile());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sourceZipFile(Path sourceZipFile) {
            this.sourceZipFile = Objects.requireNonNull(sourceZipFile, "sourceZipFile");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableZipArchiveImporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableZipArchiveImporter(this.sourceZipFile);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceZipFile");
            }
            return "Cannot build ZipArchiveImporter, some of required attributes are not set " + attributes;
        }
    }
}

