/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.immutables.value.Value;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.ImmutableNessieImporter;
import org.projectnessie.versioned.transfer.ImportDatabaseAdapter;
import org.projectnessie.versioned.transfer.ImportFileSupplier;
import org.projectnessie.versioned.transfer.ImportResult;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

@Value.Immutable
public abstract class NessieImporter {
    public static Builder builder() {
        return ImmutableNessieImporter.builder();
    }

    abstract DatabaseAdapter databaseAdapter();

    @Value.Default
    int commitBatchSize() {
        return 20;
    }

    @Value.Default
    int attachmentBatchSize() {
        return 20;
    }

    @Value.Default
    StoreWorker storeWorker() {
        return DefaultStoreWorker.instance();
    }

    @Value.Default
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    ProgressListener progressListener() {
        return (x, y) -> {};
    }

    abstract ImportFileSupplier importFileSupplier();

    public TransferTypes.HeadsAndForks loadHeadsAndForks() throws IOException {
        try (InputStream input = this.importFileSupplier().newFileInput("heads-and-forks");){
            TransferTypes.HeadsAndForks headsAndForks = TransferTypes.HeadsAndForks.parseFrom((InputStream)input);
            return headsAndForks;
        }
    }

    public ImportResult importNessieRepository() throws IOException {
        this.progressListener().progress(ProgressEvent.STARTED);
        this.progressListener().progress(ProgressEvent.START_META);
        TransferTypes.ExportMeta exportMeta = this.loadExportMeta();
        this.progressListener().progress(ProgressEvent.END_META, exportMeta);
        return new ImportDatabaseAdapter(exportMeta, this).importRepo();
    }

    private TransferTypes.ExportMeta loadExportMeta() throws IOException {
        TransferTypes.ExportMeta exportMeta;
        try (InputStream input = this.importFileSupplier().newFileInput("export-metadata");){
            exportMeta = TransferTypes.ExportMeta.parseFrom((InputStream)input);
        }
        return exportMeta;
    }

    public static interface Builder {
        public Builder databaseAdapter(DatabaseAdapter var1);

        public Builder objectMapper(ObjectMapper var1);

        public Builder storeWorker(StoreWorker var1);

        public Builder commitBatchSize(int var1);

        public Builder attachmentBatchSize(int var1);

        public Builder progressListener(ProgressListener var1);

        public Builder importFileSupplier(ImportFileSupplier var1);

        public NessieImporter build();
    }
}

