/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.ExportFileSupplier;
import org.projectnessie.versioned.transfer.ImmutableZipArchiveExporter;

@Value.Immutable
public abstract class ZipArchiveExporter
implements ExportFileSupplier {
    public static Builder builder() {
        return ImmutableZipArchiveExporter.builder();
    }

    abstract Path outputFile();

    @Value.Lazy
    ZipOutputStream zipOutput() throws IOException {
        return new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(this.outputFile(), new OpenOption[0])));
    }

    @Override
    public void preValidate() {
    }

    @Override
    public OutputStream newFileOutput(String fileName) throws IOException {
        ZipOutputStream out = this.zipOutput();
        out.putNextEntry(new ZipEntry(fileName));
        return new NonClosingOutputStream(out);
    }

    @Override
    public void close() throws Exception {
        this.zipOutput().close();
    }

    private static final class NonClosingOutputStream
    extends OutputStream {
        private final ZipOutputStream out;
        private boolean open = true;

        private NonClosingOutputStream(ZipOutputStream out) {
            this.out = out;
        }

        @Override
        public void write(byte[] b) throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            Preconditions.checkState((boolean)this.open);
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.open) {
                try {
                    this.out.closeEntry();
                }
                finally {
                    this.open = false;
                }
            }
        }
    }

    public static interface Builder {
        public Builder outputFile(Path var1);

        public ZipArchiveExporter build();
    }
}

