/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.projectnessie.versioned.ContentAttachment;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;

final class BatchWriter<T>
implements AutoCloseable {
    private final Set<T> buffer;
    private final int capacity;
    private final Consumer<List<T>> flush;

    static BatchWriter<CommitLogEntry> commitBatchWriter(int batchSize, DatabaseAdapter databaseAdapter) {
        return new BatchWriter<CommitLogEntry>(batchSize, entries -> {
            try {
                databaseAdapter.writeMultipleCommits(entries);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    static BatchWriter<ContentAttachment> attachmentsBatchWriter(int batchSize, DatabaseAdapter databaseAdapter) {
        return new BatchWriter<ContentAttachment>(batchSize, attachments -> databaseAdapter.putAttachments(attachments.stream()));
    }

    BatchWriter(int capacity, Consumer<List<T>> flush) {
        this.capacity = capacity;
        this.flush = flush;
        this.buffer = Sets.newLinkedHashSetWithExpectedSize((int)capacity);
    }

    void add(T entity) {
        this.buffer.add(entity);
        if (this.buffer.size() == this.capacity) {
            this.flush();
        }
    }

    private void flush() {
        if (!this.buffer.isEmpty()) {
            ArrayList<T> list = new ArrayList<T>(this.buffer);
            this.buffer.clear();
            this.flush.accept(list);
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

