/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.protobuf.AbstractMessage;
import java.io.IOException;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.SizeLimitedOutput;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ExportContext {
    private final TransferTypes.ExportMeta.Builder exportMeta;
    final SizeLimitedOutput namedReferenceOutput;
    final SizeLimitedOutput commitOutput;

    ExportContext(ExportFileSupplier exportFiles, NessieExporter exporter, TransferTypes.ExportMeta.Builder exportMeta) {
        this.exportMeta = exportMeta;
        this.namedReferenceOutput = new SizeLimitedOutput(exportFiles, exporter, "named-refs", arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addNamedReferencesFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setNamedReferencesCount(arg_0));
        this.commitOutput = new SizeLimitedOutput(exportFiles, exporter, "commits", arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).addCommitsFiles(arg_0), arg_0 -> ((TransferTypes.ExportMeta.Builder)exportMeta).setCommitCount(arg_0));
    }

    void writeNamedReference(TransferTypes.NamedReference namedReference) {
        this.namedReferenceOutput.writeEntity((AbstractMessage)namedReference);
    }

    void writeCommit(TransferTypes.Commit commit) {
        this.commitOutput.writeEntity((AbstractMessage)commit);
    }

    TransferTypes.ExportMeta finish() throws IOException {
        this.namedReferenceOutput.finish();
        this.commitOutput.finish();
        return this.exportMeta.build();
    }

    void closeSilently() {
        this.namedReferenceOutput.closeSilently();
        this.commitOutput.closeSilently();
    }
}

