/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.projectnessie.model.Content;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.ReferencesUtil;
import org.projectnessie.versioned.transfer.ExportCommon;
import org.projectnessie.versioned.transfer.ExportContext;
import org.projectnessie.versioned.transfer.NessieExporter;
import org.projectnessie.versioned.transfer.ProgressEvent;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

final class ExportDatabaseAdapter
extends ExportCommon {
    ExportDatabaseAdapter(ExportFileSupplier exportFiles, NessieExporter exporter) {
        super(exportFiles, exporter);
    }

    @Override
    long currentTimestampMillis() {
        return Objects.requireNonNull(this.exporter.databaseAdapter()).getConfig().getClock().millis();
    }

    @Override
    TransferTypes.ExportVersion getExportVersion() {
        return TransferTypes.ExportVersion.V1;
    }

    @Override
    void writeRepositoryDescription() {
    }

    @Override
    TransferTypes.HeadsAndForks exportCommits(ExportContext exportContext) {
        Consumer<CommitLogEntry> commitHandler = c -> {
            TransferTypes.Commit commit = this.mapCommitLogEntry((CommitLogEntry)c);
            exportContext.writeCommit(commit);
            this.exporter.progressListener().progress(ProgressEvent.COMMIT_WRITTEN);
        };
        HeadsAndForkPoints headsAndForkPoints = this.exporter.fullScan() ? this.scanDatabase(commitHandler) : this.scanAllReferences(commitHandler);
        TransferTypes.HeadsAndForks.Builder hf = TransferTypes.HeadsAndForks.newBuilder().setScanStartedAtInMicros(headsAndForkPoints.getScanStartedAtInMicros());
        headsAndForkPoints.getHeads().forEach(h -> hf.addHeads(h.asBytes()));
        headsAndForkPoints.getForkPoints().forEach(h -> hf.addForkPoints(h.asBytes()));
        return hf.build();
    }

    private HeadsAndForkPoints scanDatabase(Consumer<CommitLogEntry> commitHandler) {
        return ReferencesUtil.forDatabaseAdapter((DatabaseAdapter)this.exporter.databaseAdapter()).identifyAllHeadsAndForkPoints(this.exporter.expectedCommitCount(), commitHandler);
    }

    private HeadsAndForkPoints scanAllReferences(Consumer<CommitLogEntry> commitHandler) {
        DatabaseAdapter databaseAdapter = Objects.requireNonNull(this.exporter.databaseAdapter());
        ReferencesUtil.IdentifyHeadsAndForkPoints identify = new ReferencesUtil.IdentifyHeadsAndForkPoints(this.exporter.expectedCommitCount(), databaseAdapter.getConfig().currentTimeInMicros());
        try (Stream namedRefs = databaseAdapter.namedRefs(GetNamedRefsParams.DEFAULT);){
            namedRefs.map(ReferenceInfo::getHash).forEach(head -> {
                try (Stream commits = databaseAdapter.commitLog(head);){
                    Iterator commitIter = commits.iterator();
                    while (commitIter.hasNext()) {
                        CommitLogEntry commit = (CommitLogEntry)commitIter.next();
                        if (!identify.handleCommit(commit)) {
                            break;
                        }
                        commitHandler.accept(commit);
                    }
                }
                catch (ReferenceNotFoundException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
        return identify.finish();
    }

    @Override
    void exportReferences(ExportContext exportContext) {
        try (Stream<TransferTypes.NamedReference> namedRefs = this.exportNamedReferences();){
            namedRefs.forEach(namedReference -> {
                exportContext.writeNamedReference((TransferTypes.NamedReference)namedReference);
                this.exporter.progressListener().progress(ProgressEvent.NAMED_REFERENCE_WRITTEN);
            });
        }
    }

    @MustBeClosed
    Stream<TransferTypes.NamedReference> exportNamedReferences() {
        try {
            return Objects.requireNonNull(this.exporter.databaseAdapter()).namedRefs(GetNamedRefsParams.DEFAULT).map(refInfo -> TransferTypes.NamedReference.newBuilder().setRefType(this.refType(refInfo.getNamedRef())).setName(refInfo.getNamedRef().getName()).setCommitId(refInfo.getHash().asBytes()).build());
        }
        catch (ReferenceNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private TransferTypes.RefType refType(NamedRef namedRef) {
        if (namedRef instanceof TagName) {
            return TransferTypes.RefType.Tag;
        }
        if (namedRef instanceof BranchName) {
            return TransferTypes.RefType.Branch;
        }
        throw new IllegalArgumentException("Unknown named reference type " + namedRef);
    }

    TransferTypes.Commit mapCommitLogEntry(CommitLogEntry entry) {
        TransferTypes.Commit.Builder commitBuilder = TransferTypes.Commit.newBuilder().setCommitId(entry.getHash().asBytes()).setMetadata(entry.getMetadata()).setCommitSequence(entry.getCommitSeq()).setCreatedTimeMicros(entry.getCreatedTime()).setParentCommitId(((Hash)entry.getParents().get(0)).asBytes());
        entry.getAdditionalParents().forEach(p -> commitBuilder.addAdditionalParents(p.asBytes()));
        entry.getDeletes().forEach(d -> commitBuilder.addOperations(this.deleteOperationFromCommit((Key)d)));
        entry.getPuts().forEach(p -> commitBuilder.addOperations(this.putOperationFromCommit((KeyWithBytes)p)));
        return commitBuilder.build();
    }

    private TransferTypes.Operation.Builder deleteOperationFromCommit(Key delete) {
        return TransferTypes.Operation.newBuilder().setOperationType(TransferTypes.OperationType.Delete).addAllContentKey((Iterable)delete.getElements());
    }

    private TransferTypes.Operation.Builder putOperationFromCommit(KeyWithBytes put) {
        return TransferTypes.Operation.newBuilder().setOperationType(TransferTypes.OperationType.Put).addAllContentKey((Iterable)put.getKey().getElements()).setContentId(put.getContentId().getId()).setPayload((int)put.getPayload()).setValue(this.contentToValue(this.convertToContent(put)));
    }

    private Content convertToContent(KeyWithBytes p) {
        return this.exporter.storeWorker().valueFromStore(p.getPayload(), p.getValue(), () -> Objects.requireNonNull(this.exporter.databaseAdapter()).globalContent(p.getContentId()).map(ContentIdAndBytes::getValue).orElse(null), arg_0 -> ((DatabaseAdapter)Objects.requireNonNull(this.exporter.databaseAdapter())).mapToAttachment(arg_0));
    }

    private ByteString contentToValue(Content content) {
        try {
            return ByteString.copyFromUtf8((String)this.exporter.objectMapper().writeValueAsString((Object)content));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

