/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer.files;

import com.google.common.base.Preconditions;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.files.ImmutableZipArchiveImporter;
import org.projectnessie.versioned.transfer.files.ImportFileSupplier;

@Value.Immutable
public abstract class ZipArchiveImporter
implements ImportFileSupplier {
    public static Builder builder() {
        return ImmutableZipArchiveImporter.builder();
    }

    abstract Path sourceZipFile();

    @Value.Lazy
    ZipFile zipFile() throws IOException {
        return new ZipFile(this.sourceZipFile().toFile());
    }

    @Override
    @Nonnull
    public InputStream newFileInput(@Nonnull String fileName) throws IOException {
        ZipFile zip = this.zipFile();
        ZipEntry entry = zip.getEntry(fileName);
        if (entry == null) {
            throw new FileNotFoundException(fileName);
        }
        Preconditions.checkState((!entry.isDirectory() ? 1 : 0) != 0, (String)"%s is a directory, expect a file", (Object)fileName);
        return new BufferedInputStream(zip.getInputStream(entry));
    }

    @Override
    public void close() throws IOException {
        this.zipFile().close();
    }

    public static interface Builder {
        public Builder sourceZipFile(Path var1);

        public ZipArchiveImporter build();
    }
}

