/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.immutables.value.Value;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.store.DefaultStoreWorker;
import org.projectnessie.versioned.transfer.ExportDatabaseAdapter;
import org.projectnessie.versioned.transfer.ImmutableNessieExporter;
import org.projectnessie.versioned.transfer.ProgressListener;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.serialize.TransferTypes;

@Value.Immutable
public abstract class NessieExporter {
    public static final String NAMED_REFS_PREFIX = "named-refs";
    public static final String COMMITS_PREFIX = "commits";

    public static Builder builder() {
        return ImmutableNessieExporter.builder();
    }

    abstract DatabaseAdapter databaseAdapter();

    @Value.Default
    boolean fullScan() {
        return false;
    }

    @Value.Default
    ObjectMapper objectMapper() {
        return new ObjectMapper();
    }

    @Value.Default
    StoreWorker storeWorker() {
        return DefaultStoreWorker.instance();
    }

    @Value.Default
    int outputBufferSize() {
        return 32768;
    }

    @Value.Default
    long maxFileSize() {
        return Long.MAX_VALUE;
    }

    @Value.Default
    int expectedCommitCount() {
        return 1000000;
    }

    abstract ExportFileSupplier exportFileSupplier();

    @Value.Default
    ProgressListener progressListener() {
        return (x, y) -> {};
    }

    public TransferTypes.ExportMeta exportNessieRepository() throws IOException {
        ExportFileSupplier exportFiles = this.exportFileSupplier();
        exportFiles.preValidate();
        return new ExportDatabaseAdapter(exportFiles, this).exportRepo();
    }

    public static interface Builder {
        public Builder databaseAdapter(DatabaseAdapter var1);

        public Builder objectMapper(ObjectMapper var1);

        public Builder storeWorker(StoreWorker var1);

        public Builder outputBufferSize(int var1);

        public Builder maxFileSize(long var1);

        public Builder expectedCommitCount(int var1);

        public Builder progressListener(ProgressListener var1);

        public Builder exportFileSupplier(ExportFileSupplier var1);

        public Builder fullScan(boolean var1);

        public NessieExporter build();
    }
}

