/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer.files;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.transfer.files.FileImporter;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FileImporter", generator="Immutables")
@Immutable
public final class ImmutableFileImporter
extends FileImporter {
    private final int inputBufferSize;
    private final Path sourceDirectory;

    private ImmutableFileImporter(Builder builder) {
        this.sourceDirectory = builder.sourceDirectory;
        this.inputBufferSize = builder.inputBufferSizeIsSet() ? builder.inputBufferSize : super.inputBufferSize();
    }

    private ImmutableFileImporter(int inputBufferSize, Path sourceDirectory) {
        this.inputBufferSize = inputBufferSize;
        this.sourceDirectory = sourceDirectory;
    }

    @Override
    int inputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    Path sourceDirectory() {
        return this.sourceDirectory;
    }

    public final ImmutableFileImporter withInputBufferSize(int value) {
        if (this.inputBufferSize == value) {
            return this;
        }
        return new ImmutableFileImporter(value, this.sourceDirectory);
    }

    public final ImmutableFileImporter withSourceDirectory(Path value) {
        if (this.sourceDirectory == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "sourceDirectory");
        return new ImmutableFileImporter(this.inputBufferSize, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFileImporter && this.equalTo(0, (ImmutableFileImporter)another);
    }

    private boolean equalTo(int synthetic, ImmutableFileImporter another) {
        return this.inputBufferSize == another.inputBufferSize && this.sourceDirectory.equals(another.sourceDirectory);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.inputBufferSize;
        h += (h << 5) + this.sourceDirectory.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FileImporter").omitNullValues().add("inputBufferSize", this.inputBufferSize).add("sourceDirectory", (Object)this.sourceDirectory).toString();
    }

    public static ImmutableFileImporter copyOf(FileImporter instance) {
        if (instance instanceof ImmutableFileImporter) {
            return (ImmutableFileImporter)instance;
        }
        return ImmutableFileImporter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FileImporter", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements FileImporter.Builder {
        private static final long INIT_BIT_SOURCE_DIRECTORY = 1L;
        private static final long OPT_BIT_INPUT_BUFFER_SIZE = 1L;
        private long initBits = 1L;
        private long optBits;
        private int inputBufferSize;
        @Nullable
        private Path sourceDirectory;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FileImporter instance) {
            Objects.requireNonNull(instance, "instance");
            this.inputBufferSize(instance.inputBufferSize());
            this.sourceDirectory(instance.sourceDirectory());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder inputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder sourceDirectory(Path sourceDirectory) {
            this.sourceDirectory = Objects.requireNonNull(sourceDirectory, "sourceDirectory");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public ImmutableFileImporter build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFileImporter(this);
        }

        private boolean inputBufferSizeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sourceDirectory");
            }
            return "Cannot build FileImporter, some of required attributes are not set " + attributes;
        }
    }
}

