/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer.files;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.versioned.transfer.files.ExportFileSupplier;
import org.projectnessie.versioned.transfer.files.ImmutableFileExporter;

@Value.Immutable
public abstract class FileExporter
implements ExportFileSupplier {
    public static Builder builder() {
        return ImmutableFileExporter.builder();
    }

    abstract Path targetDirectory();

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Path getTargetPath() {
        return this.targetDirectory();
    }

    @Override
    public void preValidate() throws IOException {
        if (Files.isDirectory(this.targetDirectory(), new LinkOption[0])) {
            try (Stream<Path> listing = Files.list(this.targetDirectory());){
                Preconditions.checkState((!listing.findAny().isPresent() ? 1 : 0) != 0, (String)"Target directory %s must be empty, but is not", (Object)this.targetDirectory());
            }
        } else {
            Files.createDirectories(this.targetDirectory(), new FileAttribute[0]);
        }
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public OutputStream newFileOutput(@javax.annotation.Nonnull @Nonnull String fileName) throws IOException {
        Preconditions.checkArgument((fileName.indexOf(47) == -1 && fileName.indexOf(92) == -1 ? 1 : 0) != 0, (Object)"Directories not supported");
        Path f = Paths.get(fileName, new String[0]);
        Preconditions.checkArgument((!fileName.isEmpty() ? 1 : 0) != 0, (Object)"Invalid file name argument");
        f = this.targetDirectory().resolve(f);
        Preconditions.checkState((!Files.exists(f, new LinkOption[0]) ? 1 : 0) != 0, (String)"File %s already exists", (Object)fileName);
        return Files.newOutputStream(f, new OpenOption[0]);
    }

    @Override
    public void close() {
    }

    public static interface Builder {
        public Builder targetDirectory(Path var1);

        public FileExporter build();
    }
}

