/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.primitives.Ints;
import jakarta.annotation.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ReferencesUtil;
import org.projectnessie.versioned.transfer.ImmutableCommitLogOptimization;

@Value.Immutable
public abstract class CommitLogOptimization {
    public static Builder builder() {
        return ImmutableCommitLogOptimization.builder();
    }

    abstract DatabaseAdapter databaseAdapter();

    @Value.Default
    int totalCommitCount() {
        return 1000000;
    }

    @javax.annotation.Nullable
    @Nullable
    abstract HeadsAndForkPoints headsAndForks();

    public void optimize() {
        HeadsAndForkPoints headsAndForks = this.headsAndForks();
        if (headsAndForks == null) {
            ReferencesUtil refsUtil = ReferencesUtil.forDatabaseAdapter((DatabaseAdapter)this.databaseAdapter());
            headsAndForks = refsUtil.identifyAllHeadsAndForkPoints(this.totalCommitCount(), e -> {});
        }
        int parentsPerCommit = this.databaseAdapter().getConfig().getParentsPerCommit();
        CommitParentsState commitParentsState = new CommitParentsState(this.databaseAdapter());
        KeyListsState keyListState = new KeyListsState(this.databaseAdapter());
        for (Hash head : headsAndForks.getHeads()) {
            try (Stream log = this.databaseAdapter().commitLog(head);){
                int delayedStop = -1;
                Iterator logIter = log.iterator();
                while (logIter.hasNext()) {
                    CommitLogEntry entry = (CommitLogEntry)logIter.next();
                    if (delayedStop == -1) {
                        if (commitParentsState.canStopIterating(entry)) {
                            delayedStop = parentsPerCommit;
                        }
                    } else {
                        if (delayedStop == 0) {
                            commitParentsState.clear();
                            break;
                        }
                        --delayedStop;
                    }
                    commitParentsState.handleEntry(entry);
                    keyListState.handleEntry(entry);
                }
            }
            catch (ReferenceNotFoundException e2) {
                throw new RuntimeException(e2);
            }
            commitParentsState.drain();
        }
        keyListState.updateCommitsWithKeyLists();
    }

    static final class CommitParentsState {
        private final DatabaseAdapter databaseAdapter;
        private final int parentsPerCommit;
        private final ArrayDeque<CommitLogEntry> lastEntries;

        CommitParentsState(DatabaseAdapter databaseAdapter) {
            this.databaseAdapter = databaseAdapter;
            this.parentsPerCommit = databaseAdapter.getConfig().getParentsPerCommit();
            this.lastEntries = new ArrayDeque(this.parentsPerCommit + 1);
        }

        boolean canStopIterating(CommitLogEntry entry) {
            return entry.getParents().size() >= this.parentsPerCommit;
        }

        private boolean full() {
            return this.lastEntries.size() == this.parentsPerCommit + 1;
        }

        void handleEntry(CommitLogEntry entry) {
            if (this.full()) {
                this.lastEntries.removeFirst();
            }
            this.lastEntries.add(entry);
            if (this.full()) {
                this.updateLeastRecentCommitLogEntryParents();
            }
        }

        void drain() {
            while (!this.lastEntries.isEmpty()) {
                this.updateLeastRecentCommitLogEntryParents();
            }
        }

        private void updateLeastRecentCommitLogEntryParents() {
            CommitLogEntry commitToUpdate = this.lastEntries.removeFirst();
            List currentParents = commitToUpdate.getParents();
            if (currentParents.size() >= this.parentsPerCommit) {
                return;
            }
            ImmutableCommitLogEntry.Builder newEntry = ImmutableCommitLogEntry.builder().from(commitToUpdate);
            ArrayList<Hash> calculatedParents = new ArrayList<Hash>(this.lastEntries.size());
            this.lastEntries.forEach(e -> calculatedParents.add(e.getHash()));
            if (calculatedParents.size() < this.parentsPerCommit) {
                calculatedParents.add(this.databaseAdapter.noAncestorHash());
            }
            if (!calculatedParents.subList(0, currentParents.size()).equals(currentParents)) {
                throw new IllegalStateException(String.format("commit %s calculated parents %s must start with the exsting list of parents %s", commitToUpdate.getHash().asString(), calculatedParents, currentParents));
            }
            newEntry.parents(calculatedParents);
            try {
                this.databaseAdapter.updateMultipleCommits(Collections.singletonList(newEntry.build()));
            }
            catch (ReferenceNotFoundException e2) {
                throw new RuntimeException(e2);
            }
        }

        void clear() {
            this.lastEntries.clear();
        }
    }

    static final class KeyListsState {
        private final DatabaseAdapter databaseAdapter;
        private final int keyListDistance;
        private final List<List<Hash>> updateCommitsByKeyListSeq = new ArrayList<List<Hash>>();

        KeyListsState(DatabaseAdapter databaseAdapter) {
            this.keyListDistance = databaseAdapter.getConfig().getKeyListDistance();
            this.databaseAdapter = databaseAdapter;
        }

        void handleEntry(CommitLogEntry entry) {
            if (entry.getCommitSeq() > 0L && entry.getCommitSeq() % (long)this.keyListDistance == 0L) {
                int keyListSeq = Ints.checkedCast((long)(entry.getCommitSeq() / (long)this.keyListDistance)) - 1;
                if (!entry.hasKeySummary()) {
                    while (keyListSeq >= this.updateCommitsByKeyListSeq.size()) {
                        this.updateCommitsByKeyListSeq.add(null);
                    }
                    Hash commitId = entry.getHash();
                    List<Hash> commitIdsToUpdate = this.updateCommitsByKeyListSeq.get(keyListSeq);
                    if (commitIdsToUpdate == null) {
                        this.updateCommitsByKeyListSeq.set(keyListSeq, Collections.singletonList(commitId));
                    } else if (!commitIdsToUpdate.contains(commitId)) {
                        if (commitIdsToUpdate.size() == 1) {
                            commitIdsToUpdate = new ArrayList<Hash>(commitIdsToUpdate);
                            this.updateCommitsByKeyListSeq.set(keyListSeq, commitIdsToUpdate);
                        }
                        commitIdsToUpdate.add(commitId);
                    }
                }
            }
        }

        void updateCommitsWithKeyLists() {
            try (Stream entries = this.databaseAdapter.fetchCommitLogEntries(this.updateCommitsByKeyListSeq.stream().filter(Objects::nonNull).flatMap(Collection::stream));){
                entries.map(entry -> {
                    try {
                        return this.databaseAdapter.rebuildKeyList(entry, h -> null);
                    }
                    catch (ReferenceNotFoundException ignore) {
                        return null;
                    }
                }).filter(Objects::nonNull).forEach(e -> {
                    try {
                        this.databaseAdapter.updateMultipleCommits(Collections.singletonList(e));
                    }
                    catch (ReferenceNotFoundException ex) {
                        throw new RuntimeException(ex);
                    }
                });
            }
        }
    }

    public static interface Builder {
        public Builder databaseAdapter(DatabaseAdapter var1);

        public Builder headsAndForks(HeadsAndForkPoints var1);

        public Builder totalCommitCount(int var1);

        public CommitLogOptimization build();
    }
}

