/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.transfer;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.HeadsAndForkPoints;
import org.projectnessie.versioned.transfer.CommitLogOptimization;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitLogOptimization", generator="Immutables")
@Immutable
public final class ImmutableCommitLogOptimization
extends CommitLogOptimization {
    private final DatabaseAdapter databaseAdapter;
    private final int totalCommitCount;
    @jakarta.annotation.Nullable
    private final HeadsAndForkPoints headsAndForks;

    private ImmutableCommitLogOptimization(Builder builder) {
        this.databaseAdapter = builder.databaseAdapter;
        this.headsAndForks = builder.headsAndForks;
        this.totalCommitCount = builder.totalCommitCountIsSet() ? builder.totalCommitCount : super.totalCommitCount();
    }

    private ImmutableCommitLogOptimization(DatabaseAdapter databaseAdapter, int totalCommitCount, @jakarta.annotation.Nullable HeadsAndForkPoints headsAndForks) {
        this.databaseAdapter = databaseAdapter;
        this.totalCommitCount = totalCommitCount;
        this.headsAndForks = headsAndForks;
    }

    @Override
    DatabaseAdapter databaseAdapter() {
        return this.databaseAdapter;
    }

    @Override
    int totalCommitCount() {
        return this.totalCommitCount;
    }

    @Override
    @jakarta.annotation.Nullable
    HeadsAndForkPoints headsAndForks() {
        return this.headsAndForks;
    }

    public final ImmutableCommitLogOptimization withDatabaseAdapter(DatabaseAdapter value) {
        if (this.databaseAdapter == value) {
            return this;
        }
        DatabaseAdapter newValue = Objects.requireNonNull(value, "databaseAdapter");
        return new ImmutableCommitLogOptimization(newValue, this.totalCommitCount, this.headsAndForks);
    }

    public final ImmutableCommitLogOptimization withTotalCommitCount(int value) {
        if (this.totalCommitCount == value) {
            return this;
        }
        return new ImmutableCommitLogOptimization(this.databaseAdapter, value, this.headsAndForks);
    }

    public final ImmutableCommitLogOptimization withHeadsAndForks(@jakarta.annotation.Nullable HeadsAndForkPoints value) {
        if (this.headsAndForks == value) {
            return this;
        }
        return new ImmutableCommitLogOptimization(this.databaseAdapter, this.totalCommitCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitLogOptimization && this.equalTo(0, (ImmutableCommitLogOptimization)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitLogOptimization another) {
        return this.databaseAdapter.equals(another.databaseAdapter) && this.totalCommitCount == another.totalCommitCount && Objects.equals(this.headsAndForks, another.headsAndForks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databaseAdapter.hashCode();
        h += (h << 5) + this.totalCommitCount;
        h += (h << 5) + Objects.hashCode(this.headsAndForks);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitLogOptimization").omitNullValues().add("databaseAdapter", (Object)this.databaseAdapter).add("totalCommitCount", this.totalCommitCount).add("headsAndForks", (Object)this.headsAndForks).toString();
    }

    public static ImmutableCommitLogOptimization copyOf(CommitLogOptimization instance) {
        if (instance instanceof ImmutableCommitLogOptimization) {
            return (ImmutableCommitLogOptimization)instance;
        }
        return ImmutableCommitLogOptimization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitLogOptimization", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CommitLogOptimization.Builder {
        private static final long INIT_BIT_DATABASE_ADAPTER = 1L;
        private static final long OPT_BIT_TOTAL_COMMIT_COUNT = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private DatabaseAdapter databaseAdapter;
        private int totalCommitCount;
        @Nullable
        private HeadsAndForkPoints headsAndForks;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitLogOptimization instance) {
            Objects.requireNonNull(instance, "instance");
            this.databaseAdapter(instance.databaseAdapter());
            this.totalCommitCount(instance.totalCommitCount());
            HeadsAndForkPoints headsAndForksValue = instance.headsAndForks();
            if (headsAndForksValue != null) {
                this.headsAndForks(headsAndForksValue);
            }
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder databaseAdapter(DatabaseAdapter databaseAdapter) {
            this.databaseAdapter = Objects.requireNonNull(databaseAdapter, "databaseAdapter");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder totalCommitCount(int totalCommitCount) {
            this.totalCommitCount = totalCommitCount;
            this.optBits |= 1L;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder headsAndForks(@jakarta.annotation.Nullable HeadsAndForkPoints headsAndForks) {
            this.headsAndForks = headsAndForks;
            return this;
        }

        @Override
        public ImmutableCommitLogOptimization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitLogOptimization(this);
        }

        private boolean totalCommitCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databaseAdapter");
            }
            return "Cannot build CommitLogOptimization, some of required attributes are not set " + attributes;
        }
    }
}

