/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.testing.azurite;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.nessie.testing.containerspec.ContainerSpecHelper;
import org.projectnessie.testing.azurite.AzuriteAccess;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.Base58;

public class AzuriteContainer
extends GenericContainer<AzuriteContainer>
implements AzuriteAccess,
ExtensionContext.Store.CloseableResource {
    private static final int DEFAULT_PORT = 10000;
    private static final String LOG_WAIT_REGEX = "Azurite Blob service is successfully listening at .*";
    private final String storageContainer;
    private final String account;
    private final String accountFq;
    private final String secret;
    private final String secretBase64;

    public AzuriteContainer() {
        this(null, null, null, null);
    }

    public AzuriteContainer(String image, String storageContainer, String account, String secret) {
        super(ContainerSpecHelper.builder().name("azurite").containerClass(AzuriteContainer.class).build().dockerImageName(image));
        if (storageContainer == null) {
            storageContainer = AzuriteContainer.randomString("filesystem");
        }
        if (account == null) {
            account = AzuriteContainer.randomString("account");
        }
        if (secret == null) {
            secret = AzuriteContainer.randomString("secret");
        }
        this.storageContainer = storageContainer;
        this.account = account;
        this.accountFq = account + ".dfs.core.windows.net";
        this.secret = secret;
        this.secretBase64 = new String(Base64.getEncoder().encode(secret.getBytes(StandardCharsets.UTF_8)));
        this.addExposedPort(10000);
        this.setWaitStrategy((WaitStrategy)new LogMessageWaitStrategy().withRegEx(LOG_WAIT_REGEX));
        this.addEnv("AZURITE_ACCOUNTS", account + ":" + this.secretBase64);
    }

    public void start() {
        super.start();
        this.createStorageContainer();
    }

    @Override
    public void createStorageContainer() {
        this.serviceClient().createFileSystem(this.storageContainer);
    }

    @Override
    public void deleteStorageContainer() {
        this.serviceClient().deleteFileSystem(this.storageContainer);
    }

    @Override
    public DataLakeServiceClient serviceClient() {
        return new DataLakeServiceClientBuilder().endpoint(this.endpoint()).credential(this.credential()).buildClient();
    }

    @Override
    public String storageContainer() {
        return this.storageContainer;
    }

    @Override
    public String location(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return String.format("abfs://%s@%s/%s", this.storageContainer, this.accountFq, path);
    }

    @Override
    public String endpoint() {
        return String.format("http://%s/%s", this.endpointHostPort(), this.account);
    }

    @Override
    public String endpointHostPort() {
        return String.format("%s:%d", this.getHost(), this.getMappedPort(10000));
    }

    @Override
    public StorageSharedKeyCredential credential() {
        return new StorageSharedKeyCredential(this.account, this.secretBase64);
    }

    @Override
    public String account() {
        return this.account;
    }

    @Override
    public String accountFq() {
        return this.accountFq;
    }

    @Override
    public String secret() {
        return this.secret;
    }

    @Override
    public String secretBase64() {
        return this.secretBase64;
    }

    @Override
    public Map<String, String> icebergProperties() {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("io-impl", "org.apache.iceberg.azure.adlsv2.ADLSFileIO");
        r.put("adls.connection-string." + this.accountFq, this.endpoint());
        r.put("adls.auth.shared-key.account.name", this.account);
        r.put("adls.auth.shared-key.account.key", this.secretBase64);
        return r;
    }

    @Override
    public Map<String, String> hadoopConfig() {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("fs.azure.impl", "org.apache.hadoop.fs.azure.AzureNativeFileSystemStore");
        r.put("fs.AbstractFileSystem.azure.impl", "org.apache.hadoop.fs.azurebfs.Abfs");
        r.put("fs.azure.always.use.https", "false");
        r.put("fs.azure.abfs.endpoint", this.endpointHostPort());
        r.put("fs.azure.test.emulator", "true");
        r.put("fs.azure.storage.emulator.account.name", this.account);
        r.put("fs.azure.account.auth.type", "SharedKey");
        r.put("fs.azure.account.key." + this.accountFq, this.secretBase64);
        return r;
    }

    private static String randomString(String prefix) {
        return prefix + "-" + Base58.randomString((int)6).toLowerCase(Locale.ROOT);
    }

    public void close() {
        this.stop();
    }
}

