/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.testing.azurite;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.projectnessie.testing.azurite.Azurite;
import org.projectnessie.testing.azurite.AzuriteAccess;
import org.projectnessie.testing.azurite.AzuriteContainer;

public class AzuriteExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver,
ExecutionCondition {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{AzuriteExtension.class});

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        if (OS.current() == OS.LINUX) {
            return ConditionEvaluationResult.enabled((String)"Running on Linux");
        }
        if (OS.current() == OS.MAC) {
            return ConditionEvaluationResult.enabled((String)"Running on macOS");
        }
        return ConditionEvaluationResult.disabled((String)String.format("Disabled on %s", OS.current().name()));
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        AnnotationUtils.findAnnotatedFields((Class)testClass, Azurite.class, ReflectionUtils::isStatic).forEach(field -> this.injectField(context, (Field)field));
    }

    public void beforeEach(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        AnnotationUtils.findAnnotatedFields((Class)testClass, Azurite.class, ReflectionUtils::isNotStatic).forEach(field -> this.injectField(context, (Field)field));
    }

    private void injectField(ExtensionContext context, Field field) {
        try {
            Azurite azurite = (Azurite)AnnotationUtils.findAnnotation((AnnotatedElement)field, Azurite.class).orElseThrow(IllegalStateException::new);
            AzuriteAccess container = (AzuriteAccess)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)field.toString(), x -> this.createContainer(azurite), AzuriteAccess.class);
            ReflectionUtils.makeAccessible((Field)field).set(context.getTestInstance().orElse(null), container);
        }
        catch (Throwable t) {
            ExceptionUtils.throwAsUncheckedException((Throwable)t);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (parameterContext.findAnnotation(Azurite.class).isEmpty()) {
            return false;
        }
        return parameterContext.getParameter().getType().isAssignableFrom(AzuriteAccess.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return extensionContext.getStore(NAMESPACE).getOrComputeIfAbsent((Object)(AzuriteExtension.class.getName() + "#" + parameterContext.getParameter().getName()), k -> {
            Azurite azurite = (Azurite)parameterContext.findAnnotation(Azurite.class).get();
            return this.createContainer(azurite);
        }, AzuriteAccess.class);
    }

    private AzuriteAccess createContainer(Azurite azurite) {
        String bucket = AzuriteExtension.nonDefault(azurite.storageContainer());
        String account = AzuriteExtension.nonDefault(azurite.storageContainer());
        String secret = AzuriteExtension.nonDefault(azurite.storageContainer());
        AzuriteContainer container = (AzuriteContainer)new AzuriteContainer(null, bucket, account, secret).withStartupAttempts(5);
        container.start();
        return container;
    }

    private static String nonDefault(String s) {
        return s.equals("azurite_default_value__") ? null : s;
    }
}

