/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import jakarta.annotation.Nonnull;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.projectnessie.catalog.files.api.ObjectIO;
import org.projectnessie.catalog.model.snapshot.NessieEntitySnapshot;
import org.projectnessie.catalog.model.snapshot.NessieTableSnapshot;
import org.projectnessie.catalog.model.snapshot.NessieViewSnapshot;
import org.projectnessie.catalog.service.impl.EntitySnapshotTaskBehavior;
import org.projectnessie.catalog.service.impl.EntitySnapshotTaskRequest;
import org.projectnessie.catalog.service.impl.Util;
import org.projectnessie.catalog.service.objtypes.EntitySnapshotObj;
import org.projectnessie.model.Content;
import org.projectnessie.nessie.tasks.api.TaskRequest;
import org.projectnessie.nessie.tasks.api.TasksService;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergStuff {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergStuff.class);
    private final ObjectIO objectIO;
    private final Persist persist;
    private final TasksService tasksService;
    private final EntitySnapshotTaskBehavior snapshotTaskBehavior;
    private final Executor executor;

    IcebergStuff(ObjectIO objectIO, Persist persist, TasksService tasksService, EntitySnapshotTaskBehavior snapshotTaskBehavior, Executor executor) {
        this.objectIO = objectIO;
        this.persist = persist;
        this.tasksService = tasksService;
        this.snapshotTaskBehavior = snapshotTaskBehavior;
        this.executor = executor;
    }

    public <S extends NessieEntitySnapshot<?>> CompletionStage<S> retrieveIcebergSnapshot(ObjId snapshotId, Content content) {
        EntitySnapshotTaskRequest snapshotTaskRequest = EntitySnapshotTaskRequest.entitySnapshotTaskRequest(snapshotId, content, null, this.snapshotTaskBehavior, this.persist, this.objectIO, this.executor);
        return this.triggerIcebergSnapshot(snapshotTaskRequest);
    }

    @Nonnull
    private <S extends NessieEntitySnapshot<?>> CompletionStage<S> triggerIcebergSnapshot(EntitySnapshotTaskRequest snapshotTaskRequest) {
        return this.tasksService.forPersist(this.persist).submit((TaskRequest)snapshotTaskRequest).thenCompose(snapshotObj -> {
            NessieEntitySnapshot entitySnapshot = snapshotObj.snapshot();
            if (entitySnapshot instanceof NessieTableSnapshot) {
                return CompletableFuture.completedStage(this.mapToTableSnapshot((EntitySnapshotObj)snapshotObj));
            }
            if (entitySnapshot instanceof NessieViewSnapshot) {
                return CompletableFuture.completedStage(this.mapToViewSnapshot((EntitySnapshotObj)snapshotObj));
            }
            throw new IllegalArgumentException("Unsupported snapshot type: " + snapshotObj.getClass().getSimpleName());
        });
    }

    @Nonnull
    public <S extends NessieEntitySnapshot<?>> CompletionStage<S> storeSnapshot(S snapshot, Content content) {
        EntitySnapshotTaskRequest snapshotTaskRequest = EntitySnapshotTaskRequest.entitySnapshotTaskRequest(Util.nessieIdToObjId(snapshot.id()), content, snapshot, this.snapshotTaskBehavior, this.persist, this.objectIO, this.executor);
        return this.triggerIcebergSnapshot(snapshotTaskRequest);
    }

    NessieTableSnapshot mapToTableSnapshot(@Nonnull EntitySnapshotObj snapshotObj) {
        LOGGER.debug("Fetching table snapshot from database for snapshot ID {}", (Object)snapshotObj.id());
        NessieTableSnapshot tableSnapshot = (NessieTableSnapshot)snapshotObj.snapshot();
        NessieTableSnapshot.Builder snapshotBuilder = NessieTableSnapshot.builder().from(tableSnapshot);
        NessieTableSnapshot snapshot = snapshotBuilder.build();
        LOGGER.debug("Loaded table snapshot with {} schemas and {} partition definitions", (Object)snapshot.schemas().size(), (Object)snapshot.partitionDefinitions().size());
        return snapshot;
    }

    NessieViewSnapshot mapToViewSnapshot(@Nonnull EntitySnapshotObj snapshotObj) {
        LOGGER.debug("Fetching view snapshot from database for snapshot ID {}", (Object)snapshotObj.id());
        NessieViewSnapshot viewSnapshot = (NessieViewSnapshot)snapshotObj.snapshot();
        NessieViewSnapshot.Builder snapshotBuilder = NessieViewSnapshot.builder().from(viewSnapshot);
        NessieViewSnapshot snapshot = snapshotBuilder.build();
        LOGGER.debug("Loaded view snapshot with {} schemas", (Object)snapshot.schemas().size());
        return snapshot;
    }
}

