/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.catalog.files.api.ObjectIO;
import org.projectnessie.catalog.model.snapshot.NessieEntitySnapshot;
import org.projectnessie.catalog.service.impl.EntitySnapshotTaskRequest;
import org.projectnessie.catalog.service.objtypes.EntitySnapshotObj;
import org.projectnessie.model.Content;
import org.projectnessie.nessie.tasks.api.TaskBehavior;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Persist;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EntitySnapshotTaskRequest", generator="Immutables")
@Immutable
public final class ImmutableEntitySnapshotTaskRequest
implements EntitySnapshotTaskRequest {
    private final TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior;
    private final ObjId objId;
    @Nullable
    private final Content content;
    @Nullable
    private final NessieEntitySnapshot<?> snapshot;
    private final Persist persist;
    private final ObjectIO objectIO;
    private final Executor executor;
    private transient int hashCode;

    private ImmutableEntitySnapshotTaskRequest(TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior, ObjId objId, @Nullable Content content, @Nullable NessieEntitySnapshot<?> snapshot, Persist persist, ObjectIO objectIO, Executor executor) {
        this.behavior = Objects.requireNonNull(behavior, "behavior");
        this.objId = Objects.requireNonNull(objId, "objId");
        this.content = content;
        this.snapshot = snapshot;
        this.persist = Objects.requireNonNull(persist, "persist");
        this.objectIO = Objects.requireNonNull(objectIO, "objectIO");
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    private ImmutableEntitySnapshotTaskRequest(ImmutableEntitySnapshotTaskRequest original, TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior, ObjId objId, @Nullable Content content, @Nullable NessieEntitySnapshot<?> snapshot, Persist persist, ObjectIO objectIO, Executor executor) {
        this.behavior = behavior;
        this.objId = objId;
        this.content = content;
        this.snapshot = snapshot;
        this.persist = persist;
        this.objectIO = objectIO;
        this.executor = executor;
    }

    @Override
    public TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior() {
        return this.behavior;
    }

    @Override
    public ObjId objId() {
        return this.objId;
    }

    @Override
    @Nullable
    public Content content() {
        return this.content;
    }

    @Override
    @Nullable
    public NessieEntitySnapshot<?> snapshot() {
        return this.snapshot;
    }

    @Override
    public Persist persist() {
        return this.persist;
    }

    @Override
    public ObjectIO objectIO() {
        return this.objectIO;
    }

    @Override
    public Executor executor() {
        return this.executor;
    }

    public final ImmutableEntitySnapshotTaskRequest withBehavior(TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> value) {
        if (this.behavior == value) {
            return this;
        }
        TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> newValue = Objects.requireNonNull(value, "behavior");
        return new ImmutableEntitySnapshotTaskRequest(this, newValue, this.objId, this.content, this.snapshot, this.persist, this.objectIO, this.executor);
    }

    public final ImmutableEntitySnapshotTaskRequest withObjId(ObjId value) {
        if (this.objId == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "objId");
        return new ImmutableEntitySnapshotTaskRequest(this, this.behavior, newValue, this.content, this.snapshot, this.persist, this.objectIO, this.executor);
    }

    public final ImmutableEntitySnapshotTaskRequest withContent(@Nullable Content value) {
        if (this.content == value) {
            return this;
        }
        return new ImmutableEntitySnapshotTaskRequest(this, this.behavior, this.objId, value, this.snapshot, this.persist, this.objectIO, this.executor);
    }

    public final ImmutableEntitySnapshotTaskRequest withSnapshot(@Nullable NessieEntitySnapshot<?> value) {
        if (this.snapshot == value) {
            return this;
        }
        return new ImmutableEntitySnapshotTaskRequest(this, this.behavior, this.objId, this.content, value, this.persist, this.objectIO, this.executor);
    }

    public final ImmutableEntitySnapshotTaskRequest withPersist(Persist value) {
        if (this.persist == value) {
            return this;
        }
        Persist newValue = Objects.requireNonNull(value, "persist");
        return new ImmutableEntitySnapshotTaskRequest(this, this.behavior, this.objId, this.content, this.snapshot, newValue, this.objectIO, this.executor);
    }

    public final ImmutableEntitySnapshotTaskRequest withObjectIO(ObjectIO value) {
        if (this.objectIO == value) {
            return this;
        }
        ObjectIO newValue = Objects.requireNonNull(value, "objectIO");
        return new ImmutableEntitySnapshotTaskRequest(this, this.behavior, this.objId, this.content, this.snapshot, this.persist, newValue, this.executor);
    }

    public final ImmutableEntitySnapshotTaskRequest withExecutor(Executor value) {
        if (this.executor == value) {
            return this;
        }
        Executor newValue = Objects.requireNonNull(value, "executor");
        return new ImmutableEntitySnapshotTaskRequest(this, this.behavior, this.objId, this.content, this.snapshot, this.persist, this.objectIO, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntitySnapshotTaskRequest && this.equalTo(0, (ImmutableEntitySnapshotTaskRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntitySnapshotTaskRequest another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.behavior.equals(another.behavior) && this.objId.equals(another.objId) && Objects.equals(this.content, another.content);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.behavior.hashCode();
        h += (h << 5) + this.objId.hashCode();
        h += (h << 5) + Objects.hashCode(this.content);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntitySnapshotTaskRequest").omitNullValues().add("behavior", this.behavior).add("objId", (Object)this.objId).add("content", (Object)this.content).toString();
    }

    public static ImmutableEntitySnapshotTaskRequest of(TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior, ObjId objId, @Nullable Content content, @Nullable NessieEntitySnapshot<?> snapshot, Persist persist, ObjectIO objectIO, Executor executor) {
        return new ImmutableEntitySnapshotTaskRequest(behavior, objId, content, snapshot, persist, objectIO, executor);
    }

    public static ImmutableEntitySnapshotTaskRequest copyOf(EntitySnapshotTaskRequest instance) {
        if (instance instanceof ImmutableEntitySnapshotTaskRequest) {
            return (ImmutableEntitySnapshotTaskRequest)instance;
        }
        return ImmutableEntitySnapshotTaskRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EntitySnapshotTaskRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BEHAVIOR = 1L;
        private static final long INIT_BIT_OBJ_ID = 2L;
        private static final long INIT_BIT_PERSIST = 4L;
        private static final long INIT_BIT_OBJECT_I_O = 8L;
        private static final long INIT_BIT_EXECUTOR = 16L;
        private long initBits = 31L;
        @javax.annotation.Nullable
        private TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior;
        @javax.annotation.Nullable
        private ObjId objId;
        @javax.annotation.Nullable
        private Content content;
        @javax.annotation.Nullable
        private NessieEntitySnapshot<?> snapshot;
        @javax.annotation.Nullable
        private Persist persist;
        @javax.annotation.Nullable
        private ObjectIO objectIO;
        @javax.annotation.Nullable
        private Executor executor;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EntitySnapshotTaskRequest instance) {
            NessieEntitySnapshot<?> snapshotValue;
            Objects.requireNonNull(instance, "instance");
            this.behavior(instance.behavior());
            this.objId(instance.objId());
            Content contentValue = instance.content();
            if (contentValue != null) {
                this.content(contentValue);
            }
            if ((snapshotValue = instance.snapshot()) != null) {
                this.snapshot(snapshotValue);
            }
            this.persist(instance.persist());
            this.objectIO(instance.objectIO());
            this.executor(instance.executor());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder behavior(TaskBehavior<EntitySnapshotObj, EntitySnapshotObj.Builder> behavior) {
            this.behavior = Objects.requireNonNull(behavior, "behavior");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objId(ObjId objId) {
            this.objId = Objects.requireNonNull(objId, "objId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder content(@Nullable Content content) {
            this.content = content;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshot(@Nullable NessieEntitySnapshot<?> snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder persist(Persist persist) {
            this.persist = Objects.requireNonNull(persist, "persist");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objectIO(ObjectIO objectIO) {
            this.objectIO = Objects.requireNonNull(objectIO, "objectIO");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 31L;
            this.behavior = null;
            this.objId = null;
            this.content = null;
            this.snapshot = null;
            this.persist = null;
            this.objectIO = null;
            this.executor = null;
            return this;
        }

        public ImmutableEntitySnapshotTaskRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntitySnapshotTaskRequest(null, this.behavior, this.objId, this.content, this.snapshot, this.persist, this.objectIO, this.executor);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("behavior");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("objId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("persist");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("objectIO");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("executor");
            }
            return "Cannot build EntitySnapshotTaskRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

