/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.catalog.service.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.projectnessie.catalog.formats.iceberg.nessie.CatalogOps;
import org.projectnessie.catalog.model.snapshot.NessieEntitySnapshot;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Operations;
import org.projectnessie.services.spi.TreeService;
import org.projectnessie.versioned.RequestMeta;

final class MultiTableUpdate {
    private final TreeService treeService;
    private final ImmutableOperations.Builder operations;
    private final List<SingleTableUpdate> tableUpdates = new ArrayList<SingleTableUpdate>();
    private final List<String> storedLocations = new ArrayList<String>();
    private Map<ContentKey, String> addedContentsMap;
    private Branch targetBranch;
    private boolean committed;
    private final RequestMeta.RequestMetaBuilder requestMeta;

    MultiTableUpdate(TreeService treeService, Branch target, RequestMeta.RequestMetaBuilder requestMeta) {
        this.treeService = treeService;
        this.operations = ImmutableOperations.builder();
        this.targetBranch = target;
        this.requestMeta = requestMeta;
    }

    ImmutableOperations.Builder operations() {
        return this.operations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiTableUpdate commit() throws NessieConflictException, NessieNotFoundException {
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            this.committed = true;
            if (!this.tableUpdates.isEmpty()) {
                RequestMeta.RequestMetaBuilder checkMeta = this.requestMeta;
                for (SingleTableUpdate update : this.tableUpdates) {
                    checkMeta.addKeyActions(update.key, update.catalogOps.stream().map(Enum::name).collect(Collectors.toUnmodifiableSet()));
                }
                CommitResponse commitResponse = this.treeService.commitMultipleOperations(this.targetBranch().getName(), this.targetBranch.getHash(), (Operations)this.operations.build(), checkMeta.build());
                this.addedContentsMap = commitResponse.getAddedContents() != null ? commitResponse.toAddedContentsMap() : Map.of();
                this.targetBranch = commitResponse.getTargetBranch();
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Branch targetBranch() {
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            return this.targetBranch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<ContentKey, String> addedContentsMap() {
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            return this.addedContentsMap != null ? this.addedContentsMap : Map.of();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SingleTableUpdate> tableUpdates() {
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            return this.tableUpdates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> storedLocations() {
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            return this.storedLocations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUpdate(ContentKey key, SingleTableUpdate singleTableUpdate) {
        Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"Already committed");
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            this.tableUpdates.add(singleTableUpdate);
            this.operations.addOperations((Operation)Operation.Put.of((ContentKey)key, (Content)singleTableUpdate.content));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStoredLocation(String location) {
        Preconditions.checkState((!this.committed ? 1 : 0) != 0, (Object)"Already committed");
        MultiTableUpdate multiTableUpdate = this;
        synchronized (multiTableUpdate) {
            this.storedLocations.add(location);
        }
    }

    static final class SingleTableUpdate {
        final NessieEntitySnapshot<?> snapshot;
        final Content content;
        final ContentKey key;
        final Set<CatalogOps> catalogOps;

        SingleTableUpdate(NessieEntitySnapshot<?> snapshot, Content content, ContentKey key, Set<CatalogOps> catalogOps) {
            this.snapshot = snapshot;
            this.content = content;
            this.key = key;
            this.catalogOps = catalogOps;
        }
    }
}

